/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.file;

import com.luna.common.file.FileNameUtil;
import com.luna.common.file.FileSystemUtil;
import com.luna.common.file.FileTools;
import com.luna.common.file.compress.Deflate;
import com.luna.common.file.compress.Gzip;
import com.luna.common.file.compress.ZipCopyVisitor;
import com.luna.common.file.compress.ZipReader;
import com.luna.common.file.compress.ZipWriter;
import com.luna.common.io.FastByteArrayOutputStream;
import com.luna.common.io.IoUtil;
import com.luna.common.text.CharsetUtil;
import com.luna.common.text.StrFormatter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final Charset DEFAULT_CHARSET = CharsetUtil.defaultCharset();

    public static ZipFile toZipFile(File file, Charset charset) {
        try {
            return new ZipFile(file, Optional.ofNullable(charset).orElse(CharsetUtil.CHARSET_UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getStream(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try {
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, charset);
    }

    public static void append(Path zipPath, Path appendFilePath, CopyOption ... options) throws IOException {
        try (FileSystem zipFileSystem2 = FileSystemUtil.createZip(zipPath.toString());){
            if (Files.isDirectory(appendFilePath, new LinkOption[0])) {
                Path source = appendFilePath.getParent();
                if (null == source) {
                    source = appendFilePath;
                }
                Files.walkFileTree(appendFilePath, new ZipCopyVisitor(source, zipFileSystem2, options));
            } else {
                Files.copy(appendFilePath, zipFileSystem2.getPath(FileTools.getName(appendFilePath), new String[0]), options);
            }
        }
        catch (FileAlreadyExistsException zipFileSystem2) {
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public static File zip(String srcPath) throws IOException {
        return ZipUtil.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, Charset charset) throws IOException {
        return ZipUtil.zip(new File(srcPath), charset);
    }

    public static File zip(File srcFile) throws IOException {
        return ZipUtil.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, Charset charset) throws IOException {
        File zipFile = new File(srcFile.getParentFile(), FileNameUtil.mainName(srcFile) + ".zip");
        ZipUtil.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws IOException {
        return ZipUtil.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws IOException {
        return ZipUtil.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, Charset charset, boolean withSrcDir) throws IOException {
        File srcFile = new File(srcPath);
        File zipFile = new File(zipPath);
        ZipUtil.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws IOException {
        return ZipUtil.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, File ... srcFiles) throws IOException {
        return ZipUtil.zip(zipFile, charset, withSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IOException {
        ZipUtil.validateFiles(zipFile, srcFiles);
        ZipWriter.of(zipFile, charset).add(withSrcDir, filter, srcFiles).close();
        return zipFile;
    }

    public static void zip(OutputStream out, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IOException {
        ZipWriter.of(out, charset).add(withSrcDir, filter, srcFiles).close();
    }

    @Deprecated
    public static void zip(ZipOutputStream zipOutputStream, boolean withSrcDir, FileFilter filter, File ... srcFiles) {
        try (ZipWriter zipWriter = new ZipWriter(zipOutputStream);){
            zipWriter.add(withSrcDir, filter, srcFiles);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File zip(File zipFile, String path, String data) {
        return ZipUtil.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, Charset charset) {
        return ZipUtil.zip(zipFile, path, IoUtil.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) {
        return ZipUtil.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, Charset charset) {
        return ZipUtil.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) {
        return ZipUtil.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins, Charset charset) {
        try (ZipWriter zipWriter = ZipWriter.of(zipFile, charset);){
            zipWriter.add(paths, ins);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return zipFile;
    }

    public static void zip(OutputStream out, String[] paths, InputStream[] ins) {
        ZipUtil.zip(ZipUtil.getZipOutputStream(out, DEFAULT_CHARSET), paths, ins);
    }

    public static void zip(ZipOutputStream zipOutputStream, String[] paths, InputStream[] ins) {
        try (ZipWriter zipWriter = new ZipWriter(zipOutputStream);){
            zipWriter.add(paths, ins);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File unzip(String zipFilePath) {
        return ZipUtil.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, Charset charset) {
        return ZipUtil.unzip(new File(zipFilePath), charset);
    }

    public static File unzip(File zipFile) {
        return ZipUtil.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, Charset charset) {
        File destDir = new File(zipFile.getParentFile(), FileNameUtil.mainName(zipFile));
        return ZipUtil.unzip(zipFile, destDir, charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) {
        return ZipUtil.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, Charset charset) {
        FileTools.createDirectory(outFileDir);
        return ZipUtil.unzip(new File(zipFilePath), new File(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) {
        return ZipUtil.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, Charset charset) {
        return ZipUtil.unzip(ZipUtil.toZipFile(zipFile, charset), outFile);
    }

    public static File unzip(ZipFile zipFile, File outFile) {
        if (outFile.exists() && outFile.isFile()) {
            throw new IllegalArgumentException(StrFormatter.format("Target path [{}] exist!", outFile.getAbsolutePath()));
        }
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.readTo(outFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outFile;
    }

    public static InputStream get(File zipFile, Charset charset, String path) throws IOException {
        return ZipUtil.get(ZipUtil.toZipFile(zipFile, charset), path);
    }

    public static InputStream get(ZipFile zipFile, String path) throws IOException {
        ZipEntry entry = zipFile.getEntry(path);
        if (null != entry) {
            return ZipUtil.getStream(zipFile, entry);
        }
        return null;
    }

    public static void read(ZipFile zipFile, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.read(consumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File unzip(InputStream in, File outFile, Charset charset) {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipUtil.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.readTo(outFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outFile;
    }

    public static void read(ZipInputStream zipStream, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.read(consumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) throws IOException {
        return ZipUtil.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, Charset charset, String name) throws IOException {
        return ZipUtil.unzipFileBytes(new File(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) throws IOException {
        return ZipUtil.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(File zipFile, Charset charset, String name) throws IOException {
        try (ZipReader reader = ZipReader.of(zipFile, charset);){
            byte[] byArray = IoUtil.readBytes(reader.get(name));
            return byArray;
        }
    }

    public static byte[] gzip(String content, String charset) {
        return ZipUtil.gzip(CharsetUtil.bytes(content, CharsetUtil.charset(charset)));
    }

    public static byte[] gzip(byte[] buf) {
        return ZipUtil.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) {
        BufferedInputStream in = null;
        try {
            in = IoUtil.toBuffered(IoUtil.toStream(file));
            byte[] byArray = ZipUtil.gzip(in, (int)file.length());
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static byte[] gzip(InputStream in) {
        return ZipUtil.gzip(in, 32);
    }

    public static byte[] gzip(InputStream in, int length) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Gzip.of(in, bos).gzip().close();
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, String charset) {
        return CharsetUtil.str(ZipUtil.unGzip(buf), CharsetUtil.charset(charset));
    }

    public static byte[] unGzip(byte[] buf) {
        return ZipUtil.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) {
        return ZipUtil.unGzip(in, 32);
    }

    public static byte[] unGzip(InputStream in, int length) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(length);
        Gzip.of(in, bos).unGzip().close();
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, String charset, int level) {
        return ZipUtil.zlib(CharsetUtil.bytes(content, CharsetUtil.charset(charset)), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        BufferedInputStream in = null;
        try {
            in = IoUtil.toBuffered(IoUtil.toStream(file));
            byte[] byArray = ZipUtil.zlib(in, level, (int)file.length());
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipUtil.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipUtil.zlib(in, level, 32);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).deflater(level);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, String charset) {
        return CharsetUtil.str(ZipUtil.unZlib(buf), CharsetUtil.charset(charset));
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipUtil.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipUtil.unZlib(in, 32);
    }

    public static byte[] unZlib(InputStream in, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).inflater();
        return out.toByteArray();
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws IOException {
        if (zipFile.isDirectory()) {
            throw new IOException(StrFormatter.format("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile()));
        }
        for (File srcFile : srcFiles) {
            File parentFile;
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                String format = StrFormatter.format("File [{}] not exist!", srcFile.getAbsolutePath());
                throw new IOException(format);
            }
            try {
                parentFile = zipFile.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                parentFile = zipFile.getParentFile();
            }
            Path parentPath = srcFile.toPath().toAbsolutePath().normalize();
            Path sunPath = parentFile.toPath().toAbsolutePath().normalize();
            if (!srcFile.isDirectory() || !parentPath.startsWith(sunPath)) continue;
            String format = StrFormatter.format("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getPath(), srcFile.getPath());
            throw new IOException(format);
        }
    }
}

