/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.engine.model;

import com.google.common.collect.Maps;
import com.luna.common.engine.model.NodeConf;
import com.luna.common.engine.model.NodeName;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class NodeChain {
    private Map<NodeName, NodeConf> nodeMap = Maps.newLinkedHashMap();

    private static NodeName getNodeName(String groupName, Class nodeClass) {
        NodeName nodeName = StringUtils.isNotBlank((CharSequence)groupName) ? new NodeName(groupName, nodeClass.getName()) : new NodeName(null, nodeClass.getName());
        return nodeName;
    }

    public void add(String groupName, Class nodeClass, NodeConf nodeConf) {
        NodeName nodeName = NodeChain.getNodeName(groupName, nodeClass);
        this.add(nodeName, nodeConf);
    }

    public void add(Class nodeName, NodeConf nodeConf) {
        this.add(nodeName.getName(), nodeName, nodeConf);
    }

    public void add(NodeName nodeName, NodeConf nodeConf) {
        if (this.nodeMap.containsKey(nodeName)) {
            return;
        }
        this.nodeMap.put(nodeName, nodeConf);
    }

    public void replace(String groupName, Class nodeClass, NodeConf nodeConf) {
        NodeName nodeName = NodeChain.getNodeName(groupName, nodeClass);
        this.nodeMap.put(nodeName, nodeConf);
    }

    public void replace(NodeName nodeName, NodeConf nodeConf) {
        this.nodeMap.put(nodeName, nodeConf);
    }

    public void replace(Class nodeName, NodeConf nodeConf) {
        this.replace(nodeName.getName(), nodeName, nodeConf);
    }

    public void remove(Class nodeName) {
        this.remove(nodeName.getName(), nodeName);
    }

    public void remove(String groupName, Class nodeClass) {
        NodeName nodeName = NodeChain.getNodeName(groupName, nodeClass);
        this.nodeMap.remove(nodeName);
    }

    public Set<String> getNodeNameList() {
        return this.getNodeList().stream().map(NodeName::getNodeName).collect(Collectors.toSet());
    }

    public Set<NodeName> getNodeList() {
        return this.nodeMap.keySet();
    }

    public NodeChain deepClone() {
        LinkedHashMap<NodeName, NodeConf> cloneMap = new LinkedHashMap<NodeName, NodeConf>(this.nodeMap);
        NodeChain nodeChain = new NodeChain();
        nodeChain.setNodeMap(cloneMap);
        return nodeChain;
    }

    @Generated
    public Map<NodeName, NodeConf> getNodeMap() {
        return this.nodeMap;
    }

    @Generated
    public void setNodeMap(Map<NodeName, NodeConf> nodeMap) {
        this.nodeMap = nodeMap;
    }
}

