/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.date;

import com.luna.common.date.DateUnit;
import com.luna.common.date.DayWeekEnum;
import com.luna.common.utils.ObjectUtils;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DateUtils {
    public static final String ISO8601_COMPATIBLE_PATTERN = "yyyy-M-d'T'H:m:s";
    public static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ZONE_STR = "Asia/Shanghai";
    public static final String FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String FORMAT_YYYY_MM = "yyyy-MM";
    public static final String FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_HH_MM_SS = "HH:mm:ss";
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmssSSS";
    public static final String FORMAT_CHINESE = "yyyy\u5e74M\u6708d\u65e5";
    public static final String FORMAT_HH_MM = "HH:mm";
    public static final String FORMAT_YMDHMS = "yyyyMMdd hh:mm:ss";
    public static final String START_TIME = "00:00:00";
    public static final String END_TIME = "23:59:59";
    public static final DateTimeFormatter ISO8601_COMPATIBLE_FORMAT = DateTimeFormatter.ofPattern("yyyy-M-d'T'H:m:s", Locale.getDefault()).withZone(ZoneId.of("Asia/Shanghai"));
    public static final DateTimeFormatter ISO8601_PATTERN_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault()).withZone(ZoneId.of("Asia/Shanghai"));
    public static final DateTimeFormatter DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).withZone(ZoneId.of("Asia/Shanghai"));
    public static final DateTimeFormatter DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.getDefault()).withZone(ZoneId.of("Asia/Shanghai"));
    private static final SimpleDateFormat SDF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat PURE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat SDF_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat SDF_SHORTDATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat SDF_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat SDF_SIMPLEDATETIME = new SimpleDateFormat("yyyyMMdd");
    private static final Map<String, SimpleDateFormat> SIMPLE_DATE_FORMATERS = new HashMap<String, SimpleDateFormat>();
    private static final Map<String, DateTimeFormatter> DATE_FORMATERS = new HashMap<String, DateTimeFormatter>();

    private static SimpleDateFormat getCachedDateFormat(String aMask) {
        return SIMPLE_DATE_FORMATERS.get(aMask);
    }

    private static DateTimeFormatter getCachedDateTimeFormat(String aMask) {
        return DATE_FORMATERS.get(aMask);
    }

    public static String formatDateMonth(Date aDate) {
        return DateUtils.format(FORMAT_YYYY_MM, aDate);
    }

    public static String formatDate(Date aDate) {
        return DateUtils.format(FORMAT_YYYY_MM_DD, aDate);
    }

    public static String formatDateTime(Date date) {
        return DateUtils.format(FORMAT_YYYY_MM_DD_HH_MM_SS, date);
    }

    public static String formatDateTimeStr(Date date) {
        return DateUtils.format(FORMAT_YYYYMMDDHHMMSS, date);
    }

    public static String formatTime(Date date) {
        return DateUtils.format(FORMAT_HH_MM_SS, date);
    }

    public static String formatDate(long time) {
        return DateUtils.formatDate(new Date(time));
    }

    public static String formatDateMonth(Long time) {
        return DateUtils.formatDateMonth(new Date(time));
    }

    public static String formatDateTime(long time) {
        return DateUtils.formatDateTime(new Date(time));
    }

    public static String formatDateTimeStr(long time) {
        return DateUtils.formatDateTimeStr(new Date(time));
    }

    public static String formatTime(long time) {
        return DateUtils.formatTime(new Date(time));
    }

    public static String datePath() {
        Date now = new Date();
        return DateFormatUtils.format((Date)now, (String)"yyyy/MM/dd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(String aMask, Date aDate) {
        if (aDate == null) {
            return null;
        }
        SimpleDateFormat sd = DateUtils.getCachedDateFormat(aMask);
        if (sd == null) {
            sd = new SimpleDateFormat(aMask);
            return sd.format(aDate);
        }
        SimpleDateFormat simpleDateFormat = sd;
        synchronized (simpleDateFormat) {
            return sd.format(aDate);
        }
    }

    public static String formatTime(String aMask, Date date) {
        return DateUtils.formatTime(aMask, date.toInstant());
    }

    public static Date convertToDate(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.from(temporalAccessor);
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        Instant instant = zonedDateTime.toInstant();
        return Date.from(instant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTime(String aMask, TemporalAccessor aDate) {
        if (aDate == null) {
            return null;
        }
        DateTimeFormatter sd = DateUtils.getCachedDateTimeFormat(aMask);
        if (sd == null) {
            sd = DateTimeFormatter.ofPattern(aMask, Locale.getDefault()).withZone(ZoneId.of(ZONE_STR));
            return sd.format(aDate);
        }
        DateTimeFormatter dateTimeFormatter = sd;
        synchronized (dateTimeFormatter) {
            return sd.format(aDate);
        }
    }

    public static Date parseTime(String aMask, String strDate) {
        return DateUtils.convertToDate(DateUtils.parseTimeSd(aMask, strDate), ZoneId.systemDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemporalAccessor parseTimeSd(String aMask, String strDate) {
        if (strDate == null) {
            return null;
        }
        DateTimeFormatter sd = DateUtils.getCachedDateTimeFormat(aMask);
        if (sd == null) {
            sd = DateTimeFormatter.ofPattern(aMask, Locale.getDefault()).withZone(ZoneId.of(ZONE_STR));
            return sd.parse(strDate);
        }
        DateTimeFormatter dateTimeFormatter = sd;
        synchronized (dateTimeFormatter) {
            return sd.parse(strDate);
        }
    }

    public static Date parseDate(String strDate) {
        try {
            return DateUtils.parse(FORMAT_YYYY_MM_DD, strDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parseDateMonth(String strDate) {
        try {
            return DateUtils.parse(FORMAT_YYYY_MM, strDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parseDateTime(String strDate) {
        try {
            return DateUtils.parse(FORMAT_YYYY_MM_DD_HH_MM_SS, strDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parseDateDay(String strDate) {
        try {
            return DateUtils.parse(FORMAT_YYYYMMDD, strDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parseTime(String timeOnly) {
        timeOnly = DateUtils.formatDate(new Date()) + " " + timeOnly;
        try {
            return DateUtils.parse(FORMAT_YYYY_MM_DD_HH_MM_SS, timeOnly);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String aMask, String strDate) throws ParseException {
        if (strDate == null) {
            return null;
        }
        SimpleDateFormat sd = DateUtils.getCachedDateFormat(aMask);
        if (sd == null) {
            sd = new SimpleDateFormat(aMask);
            return sd.parse(strDate);
        }
        SimpleDateFormat simpleDateFormat = sd;
        synchronized (simpleDateFormat) {
            return sd.parse(strDate);
        }
    }

    public static Date parse(String strDate) throws ParseException {
        if (strDate == null) {
            return null;
        }
        strDate = strDate.replace("-", "").replace(".", "").replace("/", "").replace("\\", "").replace(" ", "").replace(":", "");
        String formate = FORMAT_YYYYMMDDHHMMSS;
        formate = formate.substring(0, strDate.length());
        return new SimpleDateFormat(formate).parse(strDate);
    }

    public static String format(Long timestamp, String pattern) {
        String dateStr = "";
        if (ObjectUtils.isEmpty(timestamp)) {
            return dateStr;
        }
        try {
            Date date = new Date(timestamp);
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.format(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getDateStart(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_YMDHMS);
        String subStr = dateStr.substring(0, 8);
        try {
            return simpleDateFormat.parse(subStr + " " + START_TIME);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getDateEnd(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_YMDHMS);
        String subStr = dateStr.substring(0, 8);
        try {
            return simpleDateFormat.parse(subStr + " " + END_TIME);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentTimestampMs() {
        return System.currentTimeMillis();
    }

    public static Date getCurrentDate() {
        return new Date(DateUtils.getCurrentTimestampMs());
    }

    public static String getTimeInteval(Date date) {
        if (null == date) {
            return "";
        }
        long timeMillSeconds = System.currentTimeMillis() - date.getTime();
        int hours = (int)(timeMillSeconds / 3600000L);
        int minutes = (int)((timeMillSeconds -= (long)hours * 60L * 60L * 1000L) / 60000L);
        int seconds = (int)((timeMillSeconds -= (long)minutes * 60L * 1000L) / 1000L);
        String inteval = hours > 0 ? hours + "\u5c0f\u65f6" + minutes + "\u5206" + seconds + "\u79d2" : (minutes > 0 ? minutes + "\u5206" + seconds + "\u79d2" : seconds + "\u79d2");
        return inteval;
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 6, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static String getTodayString() {
        return DateUtils.format(FORMAT_YYYYMMDD, new Date());
    }

    private static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static String nextDate(String strdate) throws ParseException {
        Date temp = DateUtils.parse(FORMAT_YYYY_MM_DD, strdate);
        Date next = new Date(temp.getTime() + 86400000L);
        return DateUtils.formatDate(next);
    }

    public static int getYear(Long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return cal.get(1);
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static String appendTime(String date) {
        int eight = 8;
        int ten = 10;
        if (date != null && date.length() >= eight && date.length() <= ten && date.indexOf("-") != date.lastIndexOf("-")) {
            date = date + " 23:59:59.999";
        }
        return date;
    }

    public static Date getMorning(Date date) {
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        dateCalendar.set(11, 0);
        dateCalendar.set(12, 0);
        dateCalendar.set(13, 0);
        dateCalendar.set(14, 0);
        return dateCalendar.getTime();
    }

    public static String getMorningStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        return sdf.format(date);
    }

    public static String getNightStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        return sdf.format(date);
    }

    public static Date getNight(Date date) {
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        dateCalendar.set(11, 23);
        dateCalendar.set(12, 59);
        dateCalendar.set(13, 59);
        dateCalendar.set(14, 0);
        return dateCalendar.getTime();
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public static long getDaysBetween(Date beginDate, Date endDate) {
        long daysBetween = (beginDate.getTime() - endDate.getTime() + 1000000L) / 86400000L;
        return daysBetween;
    }

    public static long between(Date end, Date begin, DateUnit unit) {
        long diff = end.getTime() - begin.getTime();
        return diff / unit.getMillis();
    }

    public static int getWeekDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int weekIndex = cal.get(7) - 1;
        if (weekIndex < 0) {
            weekIndex = 0;
        }
        return weekIndex;
    }

    public static DayWeekEnum getWeekDayEnum(Date date) {
        return DayWeekEnum.getNameByCode(DateUtils.getWeekDay(date));
    }

    public static Date setWeekDay(Date date, int weekIndex) {
        int oldWeekIndex = DateUtils.getWeekDay(date);
        if (oldWeekIndex == 0) {
            oldWeekIndex = 7;
        }
        if (weekIndex == 0) {
            weekIndex = 7;
        }
        return DateUtils.addDays(date, weekIndex - oldWeekIndex);
    }

    public static boolean firstDayInMonth() {
        String todayString = DateUtils.getTodayString();
        return todayString.endsWith("01");
    }

    public static boolean isDayOfMonth(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        return dayOfMonth == day;
    }

    public static long getMonthBeginStamp() {
        return DateUtils.getMonthBeginStamp(new Date());
    }

    public static long getMonthEndStamp() {
        return DateUtils.getLastStampOfMonth(new Date());
    }

    public static long getMonthBeginStamp(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static Date getMonthBeginDateTime(Date date) {
        return new Date(DateUtils.getMonthBeginStamp(date));
    }

    public static long getLastStampOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(DateUtils.getMonthBeginStamp(date));
        calendar.set(2, calendar.get(2) + 1);
        calendar.add(13, -1);
        return calendar.getTime().getTime();
    }

    public static Date getLastDateTimeOfMonth(Date date) {
        return new Date(DateUtils.getLastStampOfMonth(date));
    }

    public static int thisYear() {
        return DateUtils.getYear(DateUtils.getCurrentTimestampMs());
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static Date getQuarterStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        if (currentMonth <= 3) {
            c.set(2, 0);
        } else if (currentMonth <= 6) {
            c.set(2, 3);
        } else if (currentMonth <= 9) {
            c.set(2, 6);
        } else if (currentMonth <= 12) {
            c.set(2, 9);
        }
        c.set(5, 1);
        return DateUtils.getMorning(c.getTime());
    }

    public static long getQuarterStartStamp(Date date) {
        return DateUtils.getQuarterStartTime(date).getTime();
    }

    public static Date getQuarterEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        if (currentMonth <= 3) {
            c.set(2, 2);
            c.set(5, 31);
        } else if (currentMonth <= 6) {
            c.set(2, 5);
            c.set(5, 30);
        } else if (currentMonth <= 9) {
            c.set(2, 8);
            c.set(5, 30);
        } else if (currentMonth <= 12) {
            c.set(2, 11);
            c.set(5, 31);
        }
        return DateUtils.getNight(c.getTime());
    }

    public static long getQuarterEndStamp(Date date) {
        return DateUtils.getQuarterEndTime(date).getTime();
    }

    public static Pair<Long, Long> quarterTime(Date date) {
        return Pair.of((Object)DateUtils.getQuarterStartStamp(date), (Object)DateUtils.getQuarterEndStamp(date));
    }

    public static Pair<Long, Long> quarterTime() {
        return Pair.of((Object)DateUtils.getQuarterStartStamp(new Date()), (Object)DateUtils.getQuarterEndStamp(new Date()));
    }

    public static Date getYearStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(2, 0);
        c.set(5, 1);
        return DateUtils.getMorning(c.getTime());
    }

    public static long getYearStartStamp(Date date) {
        return DateUtils.getYearStartTime(date).getTime();
    }

    public static Date getYearEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(2, 11);
        c.set(5, 31);
        return DateUtils.getNight(c.getTime());
    }

    public static long getYearEndStamp(Date date) {
        return DateUtils.getYearEndTime(date).getTime();
    }

    public static Date getWeekDayStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int weekday = c.get(7) - 2;
        c.add(5, -weekday);
        return DateUtils.getMorning(c.getTime());
    }

    public static long getWeekDayStartStamp(Date date) {
        return DateUtils.getWeekDayStartTime(date).getTime();
    }

    public static Date getWeekDayEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int weekday = c.get(7);
        c.add(5, 8 - weekday);
        return DateUtils.getNight(c.getTime());
    }

    public static long getWeekDayEndStamp(Date date) {
        return DateUtils.getWeekDayEndTime(date).getTime();
    }

    public static Date getHalfYearStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        if (currentMonth <= 6) {
            c.set(2, 0);
        } else if (currentMonth <= 12) {
            c.set(2, 6);
        }
        c.set(5, 1);
        return DateUtils.getMorning(c.getTime());
    }

    public static long getHalfYearStartStamp(Date date) {
        return DateUtils.getHalfYearStartTime(date).getTime();
    }

    public static Date getHalfYearEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        if (currentMonth <= 6) {
            c.set(2, 5);
            c.set(5, 30);
        } else if (currentMonth <= 12) {
            c.set(2, 11);
            c.set(5, 31);
        }
        return DateUtils.getNight(c.getTime());
    }

    public static long getHalfYearEndStamp(Date date) {
        return DateUtils.getHalfYearEndTime(date).getTime();
    }

    public static List<Long> getBetweenWithDay(Date startDate, Date endDate) {
        return DateUtils.dateBetween(startDate.getTime(), endDate.getTime(), 86400000L);
    }

    public static List<Long> getBetweenWithWeek(Date startDate, Date endDate) {
        return DateUtils.dateBetween(startDate.getTime(), endDate.getTime(), 604800000L);
    }

    public static List<Long> getBetweenWithMonth(Date startDate, Date endDate) {
        return DateUtils.dateBetween(startDate.getTime(), endDate.getTime(), 2629743000L);
    }

    public static List<Long> getBetweenWithYear(Date startDate, Date endDate) {
        return DateUtils.dateBetween(startDate.getTime(), endDate.getTime(), 31556736000L);
    }

    public static List<Long> dateBetween(Long startDate, Long endDate, Long interval) {
        ArrayList<Long> list = new ArrayList<Long>();
        long oneDay = interval;
        for (long time = startDate.longValue(); time <= endDate; time += oneDay) {
            list.add(time);
        }
        return list;
    }

    public static boolean isOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }

    static {
        SIMPLE_DATE_FORMATERS.put(FORMAT_YYYY_MM_DD, SDF_DATE);
        SIMPLE_DATE_FORMATERS.put(FORMAT_YYYY_MM_DD_HH_MM_SS, SDF_DATETIME);
        SIMPLE_DATE_FORMATERS.put(FORMAT_YYYY_MM_DD_HH_MM, SDF_SHORTDATETIME);
        SIMPLE_DATE_FORMATERS.put(FORMAT_HH_MM_SS, SDF_TIME);
        SIMPLE_DATE_FORMATERS.put(FORMAT_YYYYMMDD, SDF_SIMPLEDATETIME);
        DATE_FORMATERS.put(ISO8601_COMPATIBLE_PATTERN, ISO8601_COMPATIBLE_FORMAT);
        DATE_FORMATERS.put(ISO8601_PATTERN, ISO8601_PATTERN_FORMAT);
        DATE_FORMATERS.put(FORMAT_YYYY_MM_DD_HH_MM_SS, DATETIME);
    }
}

