/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.calendarist.pojo;

import com.luna.common.calendarist.pojo.CalendaristDate;
import com.luna.common.calendarist.utils.CalendaristUtils;

public class LunarDate
extends CalendaristDate {
    private int leapMonth;
    private boolean itsLeapMonth;

    public LunarDate() {
    }

    public LunarDate(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0);
    }

    public LunarDate(int year, int month, int day, int hour, int minute, int second, int millis) {
        this(year, month, day, hour, minute, second, millis, false);
    }

    public LunarDate(int year, int month, int day, int hour, int minute, int second, int millis, boolean itsLeapMonth) {
        super(year, month, day, hour, minute, second, millis);
        this.leapMonth = CalendaristUtils.leapMonth(year);
        this.itsLeapMonth = itsLeapMonth && this.leapMonth != 0 && this.leapMonth == month;
    }

    public int getLeapMonth() {
        return this.leapMonth;
    }

    public void setLeapMonth(int leapMonth) {
        this.leapMonth = leapMonth;
    }

    public boolean isItsLeapMonth() {
        return this.itsLeapMonth;
    }

    public void setItsLeapMonth(boolean itsLeapMonth) {
        this.itsLeapMonth = itsLeapMonth;
    }

    @Override
    public String toString() {
        String sb = "LunarDate{year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", millis=" + this.millis + ", timestamp=" + this.timestamp + ", itsLeapMonth=" + this.itsLeapMonth + ", leapMonth=" + this.leapMonth + '}';
        return sb;
    }
}

