/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.cache;

import com.alibaba.fastjson2.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGuavaCache<K, V> {
    private static final Integer EXPRESS_TIME = 2;
    private static final Long MAXIMUM_SIZE = 200L;
    private LoadingCache<K, V> cache;
    private RemovalListener<K, V> listener;
    private CacheLoader<K, V> loader;

    public SimpleGuavaCache(CacheLoader<K, V> loader) {
        this(loader, new DefaultRemovalListener());
        this.loader = loader;
    }

    public SimpleGuavaCache(CacheLoader<K, V> loader, RemovalListener<K, V> listener) {
        this.cache = CacheBuilder.newBuilder().maximumSize(MAXIMUM_SIZE.longValue()).expireAfterWrite((long)EXPRESS_TIME.intValue(), TimeUnit.MINUTES).removalListener(listener).build(loader);
    }

    public SimpleGuavaCache(RemovalListener<K, V> listener, CacheLoader<K, V> loader, Integer expressTime, Long MAXIMUM_SIZE) {
        this.cache = CacheBuilder.newBuilder().maximumSize(MAXIMUM_SIZE.longValue()).expireAfterWrite((long)expressTime.intValue(), TimeUnit.MINUTES).removalListener(listener).build(loader);
    }

    public void refresh() {
        this.cache = CacheBuilder.newBuilder().maximumSize(MAXIMUM_SIZE.longValue()).expireAfterWrite((long)EXPRESS_TIME.intValue(), TimeUnit.MINUTES).removalListener(this.listener).build(this.loader);
    }

    public V get(K key) {
        return (V)this.cache.get(key);
    }

    public V get(K key, Callable<? extends V> loader) {
        return (V)this.cache.get(key, loader);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @SafeVarargs
    public final void invalidate(K ... key) {
        Arrays.stream(key).forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public Long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.cache.asMap();
    }

    public void refresh(K key) {
        this.cache.refresh(key);
    }

    @SafeVarargs
    public final ImmutableMap<K, V> getAllPresent(K ... keys) {
        return this.cache.getAllPresent((Iterable)Arrays.stream(keys).distinct().collect(Collectors.toList()));
    }

    public ImmutableMap<K, V> method(List<K> keys) {
        return this.cache.getAll(keys);
    }

    public V getUnchecked(K key) {
        return (V)this.cache.getUnchecked(key);
    }

    @Generated
    public LoadingCache<K, V> getCache() {
        return this.cache;
    }

    @Generated
    public RemovalListener<K, V> getListener() {
        return this.listener;
    }

    @Generated
    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    @Generated
    public void setCache(LoadingCache<K, V> cache) {
        this.cache = cache;
    }

    @Generated
    public void setListener(RemovalListener<K, V> listener) {
        this.listener = listener;
    }

    @Generated
    public void setLoader(CacheLoader<K, V> loader) {
        this.loader = loader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleGuavaCache)) {
            return false;
        }
        SimpleGuavaCache other = (SimpleGuavaCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoadingCache<K, V> this$cache = this.getCache();
        LoadingCache<K, V> other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        RemovalListener<K, V> this$listener = this.getListener();
        RemovalListener<K, V> other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        CacheLoader<K, V> this$loader = this.getLoader();
        CacheLoader<K, V> other$loader = other.getLoader();
        return !(this$loader == null ? other$loader != null : !this$loader.equals(other$loader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleGuavaCache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoadingCache<K, V> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        RemovalListener<K, V> $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        CacheLoader<K, V> $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimpleGuavaCache(cache=" + this.getCache() + ", listener=" + this.getListener() + ", loader=" + this.getLoader() + ")";
    }

    @Generated
    public SimpleGuavaCache() {
    }

    static class DefaultRemovalListener<K, V>
    implements RemovalListener<K, V> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(DefaultRemovalListener.class);

        DefaultRemovalListener() {
        }

        public void onRemoval(RemovalNotification<K, V> notification) {
            log.info("onRemoval::notification = {}", (Object)JSON.toJSONString(notification));
        }
    }
}

