/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Recycler<T extends AutoCloseable, E extends Exception>
implements AutoCloseable {
    private final ConcurrentLinkedQueue<T> allocatedInstances = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<T> unusedInstances = new ConcurrentLinkedQueue();

    public T acquire() throws E {
        AutoCloseable instance = (AutoCloseable)this.unusedInstances.poll();
        if (instance != null) {
            return (T)instance;
        }
        T newInstance = this.newInstance();
        if (newInstance != null) {
            this.allocatedInstances.add(newInstance);
            return newInstance;
        }
        throw new RuntimeException("Failed to allocate a new recyclable instance");
    }

    public void release(T instance) {
        if (instance != null) {
            this.unusedInstances.add(instance);
        }
    }

    @Override
    public void close() {
        AutoCloseable instance;
        int unreleasedInstances = this.allocatedInstances.size() - this.unusedInstances.size();
        if (unreleasedInstances != 0) {
            throw new RuntimeException("Unreleased instances: " + unreleasedInstances);
        }
        while ((instance = (AutoCloseable)this.allocatedInstances.poll()) != null) {
            try {
                instance.close();
            }
            catch (Exception exception) {}
        }
        this.unusedInstances.clear();
    }

    public abstract T newInstance() throws E;
}

