/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.player;

import android.content.Context;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;

public class VideoTextureView
extends TextureView {
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private int mVideoRotation = 0;

    public void adjustVideoSize(int videoWidth, int videoHeight, int videoRotation) {
        this.mVideoWidth = videoWidth;
        this.mVideoHeight = videoHeight;
        this.mVideoRotation = videoRotation;
        this.setRotation(this.mVideoRotation);
        this.requestLayout();
    }

    public VideoTextureView(@NonNull Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = VideoTextureView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = VideoTextureView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.mVideoWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
        if ((this.mVideoRotation + 180) % 180 != 0) {
            int[] size = this.scaleSize(widthSpecSize, heightSpecSize, height, width);
            this.setScaleX((float)size[0] / (float)height);
            this.setScaleY((float)size[1] / (float)width);
        }
    }

    private int[] scaleSize(int textureWidth, int textureHeight, int realWidth, int realHeight) {
        int width;
        int height;
        float rate = (float)realWidth / (float)realHeight;
        float deviceRate = (float)textureWidth / (float)textureHeight;
        if (rate < deviceRate) {
            height = textureHeight;
            width = (int)((float)textureHeight * rate);
        } else {
            width = textureWidth;
            height = (int)((float)textureWidth / rate);
        }
        return new int[]{width, height};
    }
}

