/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.player;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.config.SelectorProviders;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.player.AbsController;
import com.luck.picture.lib.player.IMediaPlayer;
import com.luck.picture.lib.utils.DateUtils;

public class AudioController
extends ConstraintLayout
implements AbsController {
    private final SelectorConfig config = SelectorProviders.getInstance().getSelectorConfig();
    private SeekBar seekBar;
    private ImageView ivBack;
    private ImageView ivFast;
    private ImageView ivPlay;
    private TextView tvDuration;
    private TextView tvCurrentDuration;
    private IMediaPlayer mediaPlayer;
    private boolean isPlayed = false;
    private AbsController.OnPlayStateListener playStateListener;
    private SeekBar.OnSeekBarChangeListener seekBarChangeListener;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final TickerRunnable mTickerRunnable = new TickerRunnable();

    public long getBackFastDuration() {
        return 3000L;
    }

    public long getMaxUpdateIntervalDuration() {
        return 1000L;
    }

    public long getMinCurrentPosition() {
        return 1000L;
    }

    public AudioController(@NonNull Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        AudioController.inflate((Context)this.getContext(), (int)R.layout.ps_audio_controller, (ViewGroup)this);
        this.seekBar = (SeekBar)this.findViewById(R.id.seek_bar);
        this.ivBack = (ImageView)this.findViewById(R.id.iv_play_back);
        this.ivFast = (ImageView)this.findViewById(R.id.iv_play_fast);
        this.ivPlay = (ImageView)this.findViewById(R.id.iv_play_audio);
        this.tvDuration = (TextView)this.findViewById(R.id.tv_total_duration);
        this.tvCurrentDuration = (TextView)this.findViewById(R.id.tv_current_time);
        this.tvDuration.setText((CharSequence)"00:00");
        this.tvCurrentDuration.setText((CharSequence)"00:00");
    }

    @Override
    @Nullable
    public ImageView getViewPlay() {
        return this.ivPlay;
    }

    @Override
    @Nullable
    public SeekBar getSeekBar() {
        return this.seekBar;
    }

    @Override
    @Nullable
    public ImageView getFast() {
        return this.ivFast;
    }

    @Override
    @Nullable
    public ImageView getBack() {
        return this.ivBack;
    }

    @Override
    @Nullable
    public TextView getTvDuration() {
        return this.tvDuration;
    }

    @Override
    @Nullable
    public TextView getTvCurrentDuration() {
        return this.tvCurrentDuration;
    }

    @Override
    public void setDataSource(final LocalMedia media) {
        this.tvDuration.setText((CharSequence)DateUtils.formatDurationTime(media.getDuration(), false));
        this.seekBar.setMax((int)media.getDuration());
        this.setBackFastUI(false);
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    seekBar.setProgress(progress);
                    AudioController.this.tvCurrentDuration.setText((CharSequence)DateUtils.formatDurationTime(progress, false));
                    if (AudioController.this.mediaPlayer.isPlaying()) {
                        AudioController.this.mediaPlayer.seekTo(progress);
                    }
                }
                if (AudioController.this.seekBarChangeListener != null) {
                    AudioController.this.seekBarChangeListener.onProgressChanged(seekBar, progress, fromUser);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (AudioController.this.seekBarChangeListener != null) {
                    AudioController.this.seekBarChangeListener.onStartTrackingTouch(seekBar);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (AudioController.this.seekBarChangeListener != null) {
                    AudioController.this.seekBarChangeListener.onStopTrackingTouch(seekBar);
                }
            }
        });
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AudioController.this.onBackAudioPlay();
            }
        });
        this.ivFast.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AudioController.this.onFastAudioPlay();
            }
        });
        this.ivPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AudioController.this.dispatchPlay(media.getAvailablePath());
            }
        });
    }

    public void dispatchPlay(String path) {
        if (this.mediaPlayer.isPlaying()) {
            if (this.playStateListener != null) {
                this.playStateListener.onPlayState(false);
            }
            this.mediaPlayer.pause();
            this.ivPlay.setImageResource(R.drawable.ps_ic_audio_play);
        } else {
            if (this.playStateListener != null) {
                this.playStateListener.onPlayState(true);
            }
            if (this.isPlayed) {
                this.mediaPlayer.resume();
                this.ivPlay.setImageResource(R.drawable.ps_ic_audio_stop);
            } else {
                this.mediaPlayer.setDataSource(this.getContext(), path, this.config.isLoopAutoPlay);
                this.isPlayed = true;
            }
        }
    }

    public void onBackAudioPlay() {
        int progress = (int)((long)this.seekBar.getProgress() - this.getBackFastDuration());
        this.seekBar.setProgress(Math.max(progress, 0));
        this.tvCurrentDuration.setText((CharSequence)DateUtils.formatDurationTime(this.seekBar.getProgress(), false));
        this.mediaPlayer.seekTo(this.seekBar.getProgress());
    }

    public void onFastAudioPlay() {
        int progress = (int)((long)this.seekBar.getProgress() + this.getBackFastDuration());
        this.seekBar.setProgress(Math.min(progress, this.seekBar.getMax()));
        this.tvCurrentDuration.setText((CharSequence)DateUtils.formatDurationTime(this.seekBar.getProgress(), false));
        this.mediaPlayer.seekTo(this.seekBar.getProgress());
    }

    public void setBackFastUI(boolean isEnabled) {
        this.ivBack.setEnabled(isEnabled);
        this.ivFast.setEnabled(isEnabled);
        if (isEnabled) {
            this.ivBack.setAlpha(1.0f);
            this.ivFast.setAlpha(1.0f);
        } else {
            this.ivBack.setAlpha(0.5f);
            this.ivFast.setAlpha(0.5f);
        }
    }

    @Override
    public void setIMediaPlayer(IMediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    @Override
    public void start() {
        this.mHandler.post((Runnable)this.mTickerRunnable);
        this.setBackFastUI(true);
        this.ivPlay.setImageResource(R.drawable.ps_ic_audio_stop);
    }

    @Override
    public void stop(boolean isReset) {
        this.mHandler.removeCallbacks((Runnable)this.mTickerRunnable);
        this.setBackFastUI(false);
        this.ivPlay.setImageResource(R.drawable.ps_ic_audio_play);
        if (isReset) {
            this.tvCurrentDuration.setText((CharSequence)"00:00");
            this.seekBar.setProgress(0);
        }
        this.isPlayed = false;
    }

    @Override
    public void setOnPlayStateListener(AbsController.OnPlayStateListener l) {
        this.playStateListener = l;
    }

    @Override
    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener l) {
        this.seekBarChangeListener = l;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHandler.removeCallbacks((Runnable)this.mTickerRunnable);
    }

    private class TickerRunnable
    implements Runnable {
        private TickerRunnable() {
        }

        @Override
        public void run() {
            long duration = AudioController.this.mediaPlayer.getDuration();
            long currentPosition = AudioController.this.mediaPlayer.getCurrentPosition();
            String time = DateUtils.formatDurationTime(currentPosition, false);
            if (!TextUtils.equals((CharSequence)time, (CharSequence)AudioController.this.tvCurrentDuration.getText())) {
                AudioController.this.tvCurrentDuration.setText((CharSequence)time);
                if (duration - currentPosition > AudioController.this.getMinCurrentPosition()) {
                    AudioController.this.seekBar.setProgress((int)currentPosition);
                } else {
                    AudioController.this.seekBar.setProgress((int)duration);
                }
            }
            AudioController.this.mHandler.postDelayed((Runnable)this, AudioController.this.getMaxUpdateIntervalDuration() - currentPosition % AudioController.this.getMaxUpdateIntervalDuration());
        }
    }
}

