/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.luck.picture.lib.R;
import com.luck.picture.lib.interfaces.OnItemClickListener;
import com.luck.picture.lib.utils.DensityUtil;

public class PhotoItemSelectedDialog
extends DialogFragment
implements View.OnClickListener {
    public static final int IMAGE_CAMERA = 0;
    public static final int VIDEO_CAMERA = 1;
    private boolean isCancel = true;
    private OnItemClickListener onItemClickListener;
    private OnDismissListener onDismissListener;

    public static PhotoItemSelectedDialog newInstance() {
        return new PhotoItemSelectedDialog();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.getDialog() != null) {
            this.getDialog().requestWindowFeature(1);
            if (this.getDialog().getWindow() != null) {
                this.getDialog().getWindow().setBackgroundDrawableResource(17170445);
            }
        }
        return inflater.inflate(R.layout.ps_dialog_camera_selected, container);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        TextView tvPicturePhoto = (TextView)view.findViewById(R.id.ps_tv_photo);
        TextView tvPictureVideo = (TextView)view.findViewById(R.id.ps_tv_video);
        TextView tvPictureCancel = (TextView)view.findViewById(R.id.ps_tv_cancel);
        tvPictureVideo.setOnClickListener((View.OnClickListener)this);
        tvPicturePhoto.setOnClickListener((View.OnClickListener)this);
        tvPictureCancel.setOnClickListener((View.OnClickListener)this);
    }

    public void onStart() {
        super.onStart();
        this.initDialogStyle();
    }

    private void initDialogStyle() {
        Window window;
        Dialog dialog = this.getDialog();
        if (dialog != null && (window = dialog.getWindow()) != null) {
            window.setLayout(DensityUtil.getRealScreenWidth(this.getContext()), -2);
            window.setGravity(80);
            window.setWindowAnimations(R.style.PictureThemeDialogFragmentAnim);
        }
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.onDismissListener = listener;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (this.onItemClickListener != null) {
            if (id2 == R.id.ps_tv_photo) {
                this.onItemClickListener.onItemClick(v, 0);
                this.isCancel = false;
            } else if (id2 == R.id.ps_tv_video) {
                this.onItemClickListener.onItemClick(v, 1);
                this.isCancel = false;
            }
        }
        this.dismissAllowingStateLoss();
    }

    public void show(FragmentManager manager, String tag) {
        FragmentTransaction ft = manager.beginTransaction();
        ft.add((Fragment)this, tag);
        ft.commitAllowingStateLoss();
    }

    public void onDismiss(@NonNull DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(this.isCancel, dialog);
        }
    }

    public static interface OnDismissListener {
        public void onDismiss(boolean var1, DialogInterface var2);
    }
}

