/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.ViewGroup;
import android.widget.ListView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.PictureSelectorPreviewFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.IBridgeViewLifecycle;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.basic.PictureSelectorTransparentActivity;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.config.SelectorProviders;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.engine.MediaPlayerEngine;
import com.luck.picture.lib.engine.VideoPlayerEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnCustomLoadingListener;
import com.luck.picture.lib.interfaces.OnExternalPreviewEventListener;
import com.luck.picture.lib.interfaces.OnInjectActivityPreviewListener;
import com.luck.picture.lib.interfaces.OnInjectLayoutResourceListener;
import com.luck.picture.lib.magical.BuildRecycleItemViewParams;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DoubleUtils;
import java.util.ArrayList;

public final class PictureSelectionPreviewModel {
    private final SelectorConfig selectionConfig;
    private final PictureSelector selector;

    public PictureSelectionPreviewModel(PictureSelector selector) {
        this.selector = selector;
        this.selectionConfig = new SelectorConfig();
        SelectorProviders.getInstance().addSelectorConfigQueue(this.selectionConfig);
        this.selectionConfig.isPreviewZoomEffect = false;
    }

    public PictureSelectionPreviewModel setImageEngine(ImageEngine engine) {
        this.selectionConfig.imageEngine = engine;
        return this;
    }

    @Deprecated
    public PictureSelectionPreviewModel setVideoPlayerEngine(VideoPlayerEngine engine) {
        return this;
    }

    public PictureSelectionPreviewModel setVideoPlayerEngine(MediaPlayerEngine engine) {
        this.selectionConfig.videoPlayerEngine = engine;
        return this;
    }

    public PictureSelectionPreviewModel setAudioPlayerEngine(MediaPlayerEngine engine) {
        this.selectionConfig.audioPlayerEngine = engine;
        return this;
    }

    public PictureSelectionPreviewModel setSelectorUIStyle(PictureSelectorStyle uiStyle) {
        if (uiStyle != null) {
            this.selectionConfig.selectorStyle = uiStyle;
        }
        return this;
    }

    public PictureSelectionPreviewModel setLanguage(int language) {
        this.selectionConfig.language = language;
        return this;
    }

    public PictureSelectionPreviewModel setDefaultLanguage(int defaultLanguage) {
        this.selectionConfig.defaultLanguage = defaultLanguage;
        return this;
    }

    public PictureSelectionPreviewModel setInjectLayoutResourceListener(OnInjectLayoutResourceListener listener) {
        this.selectionConfig.isInjectLayoutResource = listener != null;
        this.selectionConfig.onLayoutResourceListener = listener;
        return this;
    }

    public PictureSelectionPreviewModel setAttachViewLifecycle(IBridgeViewLifecycle viewLifecycle) {
        this.selectionConfig.viewLifecycle = viewLifecycle;
        return this;
    }

    public PictureSelectionPreviewModel isUseSystemVideoPlayer(boolean isUseSystemVideoPlayer) {
        this.selectionConfig.isUseSystemVideoPlayer = isUseSystemVideoPlayer;
        return this;
    }

    public PictureSelectionPreviewModel isPreviewFullScreenMode(boolean isFullScreenModel) {
        this.selectionConfig.isPreviewFullScreenMode = isFullScreenModel;
        return this;
    }

    public PictureSelectionPreviewModel isPreviewZoomEffect(boolean isPreviewZoomEffect, ViewGroup listView) {
        return this.isPreviewZoomEffect(isPreviewZoomEffect, this.selectionConfig.isPreviewFullScreenMode, listView);
    }

    @Deprecated
    public PictureSelectionPreviewModel isEnableVideoSize(boolean isEnableVideoSize) {
        this.selectionConfig.isSyncWidthAndHeight = isEnableVideoSize;
        return this;
    }

    public PictureSelectionPreviewModel isSyncWidthAndHeight(boolean isSyncWidthAndHeight) {
        this.selectionConfig.isSyncWidthAndHeight = isSyncWidthAndHeight;
        return this;
    }

    public PictureSelectionPreviewModel isPreviewZoomEffect(boolean isPreviewZoomEffect, boolean isFullScreenModel, ViewGroup listView) {
        if (listView instanceof RecyclerView || listView instanceof ListView) {
            if (isPreviewZoomEffect) {
                if (isFullScreenModel) {
                    BuildRecycleItemViewParams.generateViewParams(listView, 0);
                } else {
                    BuildRecycleItemViewParams.generateViewParams(listView, DensityUtil.getStatusBarHeight((Context)this.selector.getActivity()));
                }
            }
        } else {
            throw new IllegalArgumentException(listView.getClass().getCanonicalName() + " Must be " + RecyclerView.class + " or " + ListView.class);
        }
        this.selectionConfig.isPreviewZoomEffect = isPreviewZoomEffect;
        return this;
    }

    public PictureSelectionPreviewModel isAutoVideoPlay(boolean isAutoPlay) {
        this.selectionConfig.isAutoVideoPlay = isAutoPlay;
        return this;
    }

    public PictureSelectionPreviewModel isLoopAutoVideoPlay(boolean isLoopAutoPlay) {
        this.selectionConfig.isLoopAutoPlay = isLoopAutoPlay;
        return this;
    }

    public PictureSelectionPreviewModel isVideoPauseResumePlay(boolean isPauseResumePlay) {
        this.selectionConfig.isPauseResumePlay = isPauseResumePlay;
        return this;
    }

    public PictureSelectionPreviewModel setExternalPreviewEventListener(OnExternalPreviewEventListener listener) {
        this.selectionConfig.onExternalPreviewEventListener = listener;
        return this;
    }

    public PictureSelectionPreviewModel setInjectActivityPreviewFragment(OnInjectActivityPreviewListener listener) {
        this.selectionConfig.onInjectActivityPreviewListener = listener;
        return this;
    }

    public PictureSelectionPreviewModel setCustomLoadingListener(OnCustomLoadingListener listener) {
        this.selectionConfig.onCustomLoadingListener = listener;
        return this;
    }

    public PictureSelectionPreviewModel isHidePreviewDownload(boolean isHidePreviewDownload) {
        this.selectionConfig.isHidePreviewDownload = isHidePreviewDownload;
        return this;
    }

    public PictureSelectionPreviewModel isNewKeyBackMode(boolean isNewKeyBackMode) {
        this.selectionConfig.isNewKeyBackMode = isNewKeyBackMode;
        return this;
    }

    public void startFragmentPreview(int currentPosition, boolean isDisplayDelete, ArrayList<LocalMedia> list) {
        this.startFragmentPreview(null, currentPosition, isDisplayDelete, list);
    }

    public void startFragmentPreview(PictureSelectorPreviewFragment previewFragment, int currentPosition, boolean isDisplayDelete, ArrayList<LocalMedia> list) {
        if (!DoubleUtils.isFastDoubleClick()) {
            String fragmentTag;
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (this.selectionConfig.imageEngine == null && this.selectionConfig.chooseMode != SelectMimeType.ofAudio()) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            if (list == null || list.size() == 0) {
                throw new NullPointerException("preview data is null");
            }
            FragmentManager fragmentManager = null;
            if (activity instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            if (previewFragment != null) {
                fragmentTag = previewFragment.getFragmentTag();
            } else {
                fragmentTag = PictureSelectorPreviewFragment.TAG;
                previewFragment = PictureSelectorPreviewFragment.newInstance();
            }
            if (ActivityCompatHelper.checkFragmentNonExits((FragmentActivity)activity, fragmentTag)) {
                ArrayList<LocalMedia> previewData = new ArrayList<LocalMedia>(list);
                previewFragment.setExternalPreviewData(currentPosition, previewData.size(), previewData, isDisplayDelete);
                FragmentInjectManager.injectSystemRoomFragment(fragmentManager, fragmentTag, previewFragment);
            }
        }
    }

    public void startActivityPreview(int currentPosition, boolean isDisplayDelete, ArrayList<LocalMedia> list) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (this.selectionConfig.imageEngine == null && this.selectionConfig.chooseMode != SelectMimeType.ofAudio()) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            if (list == null || list.size() == 0) {
                throw new NullPointerException("preview data is null");
            }
            Intent intent = new Intent((Context)activity, PictureSelectorTransparentActivity.class);
            this.selectionConfig.addSelectedPreviewResult(list);
            intent.putExtra("com.luck.picture.lib.external_preview", true);
            intent.putExtra("com.luck.picture.lib.mode_type_source", 2);
            intent.putExtra("com.luck.picture.lib.current_preview_position", currentPosition);
            intent.putExtra("com.luck.picture.lib.external_preview_display_delete", isDisplayDelete);
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivity(intent);
            } else {
                activity.startActivity(intent);
            }
            if (this.selectionConfig.isPreviewZoomEffect) {
                activity.overridePendingTransition(R.anim.ps_anim_fade_in, R.anim.ps_anim_fade_in);
            } else {
                PictureWindowAnimationStyle windowAnimationStyle = this.selectionConfig.selectorStyle.getWindowAnimationStyle();
                activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.ps_anim_fade_in);
            }
        }
    }
}

