/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.content.Context;
import android.graphics.ColorFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.InjectResourceSource;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.StyleUtils;
import java.util.ArrayList;
import java.util.List;

public class PreviewGalleryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<LocalMedia> mData;
    private final boolean isBottomPreview;
    private final SelectorConfig selectorConfig;
    private OnItemClickListener listener;
    private OnItemLongClickListener mItemLongClickListener;

    public PreviewGalleryAdapter(SelectorConfig config, boolean isBottomPreview) {
        this.selectorConfig = config;
        this.isBottomPreview = isBottomPreview;
        this.mData = new ArrayList<LocalMedia>(this.selectorConfig.getSelectedResult());
        for (int i = 0; i < this.mData.size(); ++i) {
            LocalMedia media = this.mData.get(i);
            media.setGalleryEnabledMask(false);
            media.setChecked(false);
        }
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        int layoutResourceId = InjectResourceSource.getLayoutResource(parent.getContext(), 9);
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(layoutResourceId != 0 ? layoutResourceId : R.layout.ps_preview_gallery_item, parent, false);
        return new ViewHolder(itemView);
    }

    public List<LocalMedia> getData() {
        return this.mData;
    }

    public void clear() {
        this.mData.clear();
    }

    public void addGalleryData(LocalMedia currentMedia) {
        int lastCheckPosition = this.getLastCheckPosition();
        if (lastCheckPosition != -1) {
            LocalMedia lastSelectedMedia = this.mData.get(lastCheckPosition);
            lastSelectedMedia.setChecked(false);
            this.notifyItemChanged(lastCheckPosition);
        }
        if (this.isBottomPreview && this.mData.contains(currentMedia)) {
            int currentPosition = this.getCurrentPosition(currentMedia);
            LocalMedia media = this.mData.get(currentPosition);
            media.setGalleryEnabledMask(false);
            media.setChecked(true);
            this.notifyItemChanged(currentPosition);
        } else {
            currentMedia.setChecked(true);
            this.mData.add(currentMedia);
            this.notifyItemChanged(this.mData.size() - 1);
        }
    }

    public void removeGalleryData(LocalMedia currentMedia) {
        int currentPosition = this.getCurrentPosition(currentMedia);
        if (currentPosition != -1) {
            if (this.isBottomPreview) {
                LocalMedia media = this.mData.get(currentPosition);
                media.setGalleryEnabledMask(true);
                this.notifyItemChanged(currentPosition);
            } else {
                this.mData.remove(currentPosition);
                this.notifyItemRemoved(currentPosition);
            }
        }
    }

    public void isSelectMedia(LocalMedia currentMedia) {
        int currentPosition;
        int lastCheckPosition = this.getLastCheckPosition();
        if (lastCheckPosition != -1) {
            LocalMedia lastSelectedMedia = this.mData.get(lastCheckPosition);
            lastSelectedMedia.setChecked(false);
            this.notifyItemChanged(lastCheckPosition);
        }
        if ((currentPosition = this.getCurrentPosition(currentMedia)) != -1) {
            LocalMedia media = this.mData.get(currentPosition);
            media.setChecked(true);
            this.notifyItemChanged(currentPosition);
        }
    }

    public int getLastCheckPosition() {
        for (int i = 0; i < this.mData.size(); ++i) {
            LocalMedia media = this.mData.get(i);
            if (!media.isChecked()) continue;
            return i;
        }
        return -1;
    }

    private int getCurrentPosition(LocalMedia currentMedia) {
        for (int i = 0; i < this.mData.size(); ++i) {
            LocalMedia media = this.mData.get(i);
            if (!TextUtils.equals((CharSequence)media.getPath(), (CharSequence)currentMedia.getPath()) && media.getId() != currentMedia.getId()) continue;
            return i;
        }
        return -1;
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, int position) {
        final LocalMedia item = this.mData.get(position);
        ColorFilter colorFilter = StyleUtils.getColorFilter(holder.itemView.getContext(), item.isGalleryEnabledMask() ? R.color.ps_color_half_white : R.color.ps_color_transparent);
        if (item.isChecked() && item.isGalleryEnabledMask()) {
            holder.viewBorder.setVisibility(0);
        } else {
            holder.viewBorder.setVisibility(item.isChecked() ? 0 : 8);
        }
        String path = item.getPath();
        if (item.isEditorImage() && !TextUtils.isEmpty((CharSequence)item.getCutPath())) {
            path = item.getCutPath();
            holder.ivEditor.setVisibility(0);
        } else {
            holder.ivEditor.setVisibility(8);
        }
        holder.ivImage.setColorFilter(colorFilter);
        if (this.selectorConfig.imageEngine != null) {
            this.selectorConfig.imageEngine.loadGridImage(holder.itemView.getContext(), path, holder.ivImage);
        }
        holder.ivPlay.setVisibility(PictureMimeType.isHasVideo(item.getMimeType()) ? 0 : 8);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreviewGalleryAdapter.this.listener != null) {
                    PreviewGalleryAdapter.this.listener.onItemClick(holder.getAbsoluteAdapterPosition(), item, view);
                }
            }
        });
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PreviewGalleryAdapter.this.mItemLongClickListener != null) {
                    int adapterPosition = holder.getAbsoluteAdapterPosition();
                    PreviewGalleryAdapter.this.mItemLongClickListener.onItemLongClick(holder, adapterPosition, v);
                }
                return true;
            }
        });
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void setItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public void setItemLongClickListener(OnItemLongClickListener listener) {
        this.mItemLongClickListener = listener;
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(RecyclerView.ViewHolder var1, int var2, View var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, LocalMedia var2, View var3);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivImage;
        ImageView ivPlay;
        ImageView ivEditor;
        View viewBorder;

        public ViewHolder(View itemView) {
            int adapterPreviewGalleryItemSize;
            super(itemView);
            this.ivImage = (ImageView)itemView.findViewById(R.id.ivImage);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivEditor = (ImageView)itemView.findViewById(R.id.ivEditor);
            this.viewBorder = itemView.findViewById(R.id.viewBorder);
            SelectMainStyle selectMainStyle = ((PreviewGalleryAdapter)PreviewGalleryAdapter.this).selectorConfig.selectorStyle.getSelectMainStyle();
            if (StyleUtils.checkStyleValidity(selectMainStyle.getAdapterImageEditorResources())) {
                this.ivEditor.setImageResource(selectMainStyle.getAdapterImageEditorResources());
            }
            if (StyleUtils.checkStyleValidity(selectMainStyle.getAdapterPreviewGalleryFrameResource())) {
                this.viewBorder.setBackgroundResource(selectMainStyle.getAdapterPreviewGalleryFrameResource());
            }
            if (StyleUtils.checkSizeValidity(adapterPreviewGalleryItemSize = selectMainStyle.getAdapterPreviewGalleryItemSize())) {
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(adapterPreviewGalleryItemSize, adapterPreviewGalleryItemSize);
                itemView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }
}

