/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.InjectResourceSource;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnAlbumItemClickListener;
import com.luck.picture.lib.style.AlbumWindowStyle;
import com.luck.picture.lib.style.PictureSelectorStyle;
import java.util.ArrayList;
import java.util.List;

public class PictureAlbumAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<LocalMediaFolder> albumList;
    private final SelectorConfig selectorConfig;
    private OnAlbumItemClickListener onAlbumItemClickListener;

    public PictureAlbumAdapter(SelectorConfig config) {
        this.selectorConfig = config;
    }

    public void bindAlbumData(List<LocalMediaFolder> albumList) {
        this.albumList = new ArrayList<LocalMediaFolder>(albumList);
    }

    public List<LocalMediaFolder> getAlbumList() {
        return this.albumList != null ? this.albumList : new ArrayList<LocalMediaFolder>();
    }

    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        int layoutResourceId = InjectResourceSource.getLayoutResource(parent.getContext(), 6);
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(layoutResourceId != 0 ? layoutResourceId : R.layout.ps_album_folder_item, parent, false);
        return new ViewHolder(itemView);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void onBindViewHolder(ViewHolder holder, final int position) {
        final LocalMediaFolder folder = this.albumList.get(position);
        String name = folder.getFolderName();
        int imageNum = folder.getFolderTotalNum();
        String imagePath = folder.getFirstImagePath();
        holder.tvSelectTag.setVisibility(folder.isSelectTag() ? 0 : 4);
        LocalMediaFolder currentLocalMediaFolder = this.selectorConfig.currentLocalMediaFolder;
        holder.itemView.setSelected(currentLocalMediaFolder != null && folder.getBucketId() == currentLocalMediaFolder.getBucketId());
        String firstMimeType = folder.getFirstMimeType();
        if (PictureMimeType.isHasAudio(firstMimeType)) {
            holder.ivFirstImage.setImageResource(R.drawable.ps_audio_placeholder);
        } else if (this.selectorConfig.imageEngine != null) {
            this.selectorConfig.imageEngine.loadAlbumCover(holder.itemView.getContext(), imagePath, holder.ivFirstImage);
        }
        Context context = holder.itemView.getContext();
        holder.tvFolderName.setText((CharSequence)context.getString(R.string.ps_camera_roll_num, new Object[]{name, imageNum}));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PictureAlbumAdapter.this.onAlbumItemClickListener == null) {
                    return;
                }
                PictureAlbumAdapter.this.onAlbumItemClickListener.onItemClick(position, folder);
            }
        });
    }

    public int getItemCount() {
        return this.albumList.size();
    }

    public void setOnIBridgeAlbumWidget(OnAlbumItemClickListener listener) {
        this.onAlbumItemClickListener = listener;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivFirstImage;
        TextView tvFolderName;
        TextView tvSelectTag;

        public ViewHolder(View itemView) {
            int titleSize;
            int titleColor;
            int itemSelectStyle;
            super(itemView);
            this.ivFirstImage = (ImageView)itemView.findViewById(R.id.first_image);
            this.tvFolderName = (TextView)itemView.findViewById(R.id.tv_folder_name);
            this.tvSelectTag = (TextView)itemView.findViewById(R.id.tv_select_tag);
            PictureSelectorStyle selectorStyle = ((PictureAlbumAdapter)PictureAlbumAdapter.this).selectorConfig.selectorStyle;
            AlbumWindowStyle albumWindowStyle = selectorStyle.getAlbumWindowStyle();
            int itemBackground = albumWindowStyle.getAlbumAdapterItemBackground();
            if (itemBackground != 0) {
                itemView.setBackgroundResource(itemBackground);
            }
            if ((itemSelectStyle = albumWindowStyle.getAlbumAdapterItemSelectStyle()) != 0) {
                this.tvSelectTag.setBackgroundResource(itemSelectStyle);
            }
            if ((titleColor = albumWindowStyle.getAlbumAdapterItemTitleColor()) != 0) {
                this.tvFolderName.setTextColor(titleColor);
            }
            if ((titleSize = albumWindowStyle.getAlbumAdapterItemTitleSize()) > 0) {
                this.tvFolderName.setTextSize((float)titleSize);
            }
        }
    }
}

