/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.interfaces.OnRecyclerViewPreloadMoreListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewScrollListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewScrollStateListener;

public class RecyclerPreloadView
extends RecyclerView {
    private static final String TAG = RecyclerPreloadView.class.getSimpleName();
    private static final int BOTTOM_DEFAULT = 1;
    public static final int BOTTOM_PRELOAD = 2;
    private static final int LIMIT = 150;
    private boolean isInTheBottom = false;
    private boolean isEnabledLoadMore = false;
    private int mFirstVisiblePosition;
    private int mLastVisiblePosition;
    private int reachBottomRow = 1;
    private OnRecyclerViewPreloadMoreListener onRecyclerViewPreloadListener;
    private OnRecyclerViewScrollStateListener onRecyclerViewScrollStateListener;
    private OnRecyclerViewScrollListener onRecyclerViewScrollListener;

    public RecyclerPreloadView(@NonNull Context context) {
        super(context);
    }

    public RecyclerPreloadView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public RecyclerPreloadView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setReachBottomRow(int reachBottomRow) {
        if (reachBottomRow < 1) {
            reachBottomRow = 1;
        }
        this.reachBottomRow = reachBottomRow;
    }

    public void setEnabledLoadMore(boolean isEnabledLoadMore) {
        this.isEnabledLoadMore = isEnabledLoadMore;
    }

    public boolean isEnabledLoadMore() {
        return this.isEnabledLoadMore;
    }

    public int getFirstVisiblePosition() {
        return this.mFirstVisiblePosition;
    }

    public int getLastVisiblePosition() {
        return this.mLastVisiblePosition;
    }

    public void setLastVisiblePosition(int position) {
        this.mLastVisiblePosition = position;
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null) {
            throw new RuntimeException("LayoutManager is null,Please check it!");
        }
        this.setLayoutManagerPosition(layoutManager);
        if (this.onRecyclerViewPreloadListener != null && this.isEnabledLoadMore) {
            RecyclerView.Adapter adapter = this.getAdapter();
            if (adapter == null) {
                throw new RuntimeException("Adapter is null,Please check it!");
            }
            boolean isReachBottom = false;
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                int rowCount = adapter.getItemCount() / gridLayoutManager.getSpanCount();
                int lastVisibleRowPosition = gridLayoutManager.findLastVisibleItemPosition() / gridLayoutManager.getSpanCount();
                boolean bl = isReachBottom = lastVisibleRowPosition >= rowCount - this.reachBottomRow;
            }
            if (!isReachBottom) {
                this.isInTheBottom = false;
            } else if (!this.isInTheBottom) {
                this.onRecyclerViewPreloadListener.onRecyclerViewPreloadMore();
                if (dy > 0) {
                    this.isInTheBottom = true;
                }
            } else if (dy == 0) {
                this.isInTheBottom = false;
            }
        }
        if (this.onRecyclerViewScrollListener != null) {
            this.onRecyclerViewScrollListener.onScrolled(dx, dy);
        }
        if (this.onRecyclerViewScrollStateListener != null) {
            if (Math.abs(dy) < 150) {
                this.onRecyclerViewScrollStateListener.onScrollSlow();
            } else {
                this.onRecyclerViewScrollStateListener.onScrollFast();
            }
        }
    }

    private void setLayoutManagerPosition(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            this.mFirstVisiblePosition = gridLayoutManager.findFirstVisibleItemPosition();
            this.mLastVisiblePosition = gridLayoutManager.findLastVisibleItemPosition();
        } else if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            this.mFirstVisiblePosition = linearLayoutManager.findFirstVisibleItemPosition();
            this.mLastVisiblePosition = linearLayoutManager.findLastVisibleItemPosition();
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0 || state == 1) {
            this.setLayoutManagerPosition(this.getLayoutManager());
        }
        if (this.onRecyclerViewScrollListener != null) {
            this.onRecyclerViewScrollListener.onScrollStateChanged(state);
        }
        if (state == 0 && this.onRecyclerViewScrollStateListener != null) {
            this.onRecyclerViewScrollStateListener.onScrollSlow();
        }
    }

    public void setOnRecyclerViewPreloadListener(OnRecyclerViewPreloadMoreListener listener) {
        this.onRecyclerViewPreloadListener = listener;
    }

    public void setOnRecyclerViewScrollStateListener(OnRecyclerViewScrollStateListener listener) {
        this.onRecyclerViewScrollStateListener = listener;
    }

    public void setOnRecyclerViewScrollListener(OnRecyclerViewScrollListener listener) {
        this.onRecyclerViewScrollListener = listener;
    }
}

