/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.PreviewAudioHolder;
import com.luck.picture.lib.adapter.holder.PreviewImageHolder;
import com.luck.picture.lib.adapter.holder.PreviewVideoHolder;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.utils.BitmapUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.MediaUtils;

public class BasePreviewHolder
extends RecyclerView.ViewHolder {
    public static final int ADAPTER_TYPE_IMAGE = 1;
    public static final int ADAPTER_TYPE_VIDEO = 2;
    public static final int ADAPTER_TYPE_AUDIO = 3;
    protected final int screenWidth;
    protected final int screenHeight;
    protected final int screenAppInHeight;
    protected LocalMedia media;
    protected final PictureSelectionConfig config = PictureSelectionConfig.getInstance();
    public PhotoView coverImageView;
    protected OnPreviewEventListener mPreviewEventListener;

    public static BasePreviewHolder generate(ViewGroup parent, int viewType, int resource) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(resource, parent, false);
        if (viewType == 2) {
            return new PreviewVideoHolder(itemView);
        }
        if (viewType == 3) {
            return new PreviewAudioHolder(itemView);
        }
        return new PreviewImageHolder(itemView);
    }

    public BasePreviewHolder(@NonNull View itemView) {
        super(itemView);
        this.screenWidth = DensityUtil.getRealScreenWidth(itemView.getContext());
        this.screenHeight = DensityUtil.getScreenHeight(itemView.getContext());
        this.screenAppInHeight = DensityUtil.getRealScreenHeight(itemView.getContext());
        this.findViews(itemView);
    }

    protected void findViews(View itemView) {
        this.coverImageView = (PhotoView)itemView.findViewById(R.id.preview_image);
    }

    public void bindData(LocalMedia media, int position) {
        this.media = media;
        int[] size = this.getSize(media);
        int[] maxImageSize = BitmapUtils.getMaxImageSize(size[0], size[1]);
        this.loadImageBitmap(media, maxImageSize[0], maxImageSize[1]);
        this.setScaleDisplaySize(media);
        this.setOnClickEventListener();
        this.setOnLongClickEventListener();
    }

    protected void setOnClickEventListener() {
        this.coverImageView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (BasePreviewHolder.this.mPreviewEventListener != null) {
                    BasePreviewHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    protected void setOnLongClickEventListener() {
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (BasePreviewHolder.this.mPreviewEventListener != null) {
                    BasePreviewHolder.this.mPreviewEventListener.onLongPressDownload(BasePreviewHolder.this.media);
                }
                return false;
            }
        });
    }

    protected void loadImageBitmap(final LocalMedia media, int maxWidth, int maxHeight) {
        if (PictureSelectionConfig.imageEngine != null) {
            PictureSelectionConfig.imageEngine.loadImageBitmap(this.itemView.getContext(), media.getAvailablePath(), maxWidth, maxHeight, new OnCallbackListener<Bitmap>(){

                @Override
                public void onCall(Bitmap bitmap) {
                    BasePreviewHolder.this.loadBitmapCallback(media, bitmap);
                }
            });
        }
    }

    protected void loadBitmapCallback(LocalMedia media, Bitmap bitmap) {
        String path = media.getAvailablePath();
        if (bitmap == null) {
            this.mPreviewEventListener.onLoadError();
        } else {
            int height;
            int width;
            ImageView.ScaleType scaleType;
            if (PictureMimeType.isHasWebp(media.getMimeType()) || PictureMimeType.isUrlHasWebp(path) || PictureMimeType.isUrlHasGif(path) || PictureMimeType.isHasGif(media.getMimeType())) {
                if (PictureSelectionConfig.imageEngine != null) {
                    this.coverImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    PictureSelectionConfig.imageEngine.loadImage(this.itemView.getContext(), path, (ImageView)this.coverImageView);
                }
            } else {
                this.setImageViewBitmap(bitmap);
            }
            if (media.getWidth() <= 0) {
                media.setWidth(bitmap.getWidth());
            }
            if (media.getHeight() <= 0) {
                media.setHeight(bitmap.getHeight());
            }
            if (MediaUtils.isLongImage(bitmap.getWidth(), bitmap.getHeight())) {
                scaleType = ImageView.ScaleType.CENTER_CROP;
                width = this.screenWidth;
                height = this.screenHeight;
            } else {
                scaleType = ImageView.ScaleType.FIT_CENTER;
                int[] size = this.getSize(media);
                boolean isHaveSize = bitmap.getWidth() > 0 && bitmap.getHeight() > 0;
                width = isHaveSize ? bitmap.getWidth() : size[0];
                height = isHaveSize ? bitmap.getHeight() : size[1];
            }
            this.mPreviewEventListener.onLoadComplete(width, height, new OnCallbackListener<Boolean>(){

                @Override
                public void onCall(Boolean isBeginEffect) {
                    BasePreviewHolder.this.coverImageView.setScaleType(isBeginEffect != false ? ImageView.ScaleType.CENTER_CROP : scaleType);
                }
            });
        }
    }

    protected void setImageViewBitmap(Bitmap bitmap) {
        this.coverImageView.setImageBitmap(bitmap);
    }

    protected int[] getSize(LocalMedia media) {
        if (media.isCut() && media.getCropImageWidth() > 0 && media.getCropImageHeight() > 0) {
            return new int[]{media.getCropImageWidth(), media.getCropImageHeight()};
        }
        return new int[]{media.getWidth(), media.getHeight()};
    }

    protected void setScaleDisplaySize(LocalMedia media) {
        if (!this.config.isPreviewZoomEffect && this.screenWidth < this.screenHeight && media.getWidth() > 0 && media.getHeight() > 0) {
            float ratio = (float)media.getWidth() / (float)media.getHeight();
            int displayHeight = (int)((float)this.screenWidth / ratio);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.coverImageView.getLayoutParams();
            layoutParams.width = this.screenWidth;
            layoutParams.height = displayHeight > this.screenHeight ? this.screenAppInHeight : this.screenHeight;
            layoutParams.gravity = 17;
        }
    }

    public void onViewAttachedToWindow() {
    }

    public void onViewDetachedFromWindow() {
    }

    public void setOnPreviewEventListener(OnPreviewEventListener listener) {
        this.mPreviewEventListener = listener;
    }

    public static interface OnPreviewEventListener {
        public void onLoadComplete(int var1, int var2, OnCallbackListener<Boolean> var3);

        public void onLoadError();

        public void onBackPressed();

        public void onPreviewVideoTitle(String var1);

        public void onLongPressDownload(LocalMedia var1);
    }
}

