/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import com.luck.picture.lib.R;

public class PictureCommonDialog
extends Dialog
implements View.OnClickListener {
    private OnDialogEventListener eventListener;

    public static PictureCommonDialog showDialog(Context context, String title, String content) {
        PictureCommonDialog dialog = new PictureCommonDialog(context, title, content);
        dialog.show();
        return dialog;
    }

    public PictureCommonDialog(Context context, String title, String content) {
        super(context, R.style.Picture_Theme_Dialog);
        this.setContentView(R.layout.ps_common_dialog);
        Button btnCancel = (Button)this.findViewById(R.id.btn_cancel);
        Button btnCommit = (Button)this.findViewById(R.id.btn_commit);
        TextView tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        TextView tv_content = (TextView)this.findViewById(R.id.tv_content);
        tvTitle.setText((CharSequence)title);
        tv_content.setText((CharSequence)content);
        btnCancel.setOnClickListener((View.OnClickListener)this);
        btnCommit.setOnClickListener((View.OnClickListener)this);
        this.setDialogSize();
    }

    private void setDialogSize() {
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.width = -2;
        params.height = -2;
        params.gravity = 17;
        this.getWindow().setWindowAnimations(R.style.PictureThemeDialogWindowStyle);
        this.getWindow().setAttributes(params);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.btn_cancel) {
            this.dismiss();
        } else if (id2 == R.id.btn_commit) {
            this.dismiss();
            if (this.eventListener != null) {
                this.eventListener.onConfirm();
            }
        }
    }

    public void setOnDialogEventListener(OnDialogEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public static interface OnDialogEventListener {
        public void onConfirm();
    }
}

