/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.style.BottomNavBarStyle;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.widget.BottomNavBar;

public class PreviewBottomNavBar
extends BottomNavBar {
    public PreviewBottomNavBar(Context context) {
        super(context);
    }

    public PreviewBottomNavBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PreviewBottomNavBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        super.init();
        this.tvPreview.setVisibility(8);
        this.tvImageEditor.setOnClickListener((View.OnClickListener)this);
        this.tvImageEditor.setVisibility(PictureSelectionConfig.editMediaEventListener != null ? 0 : 8);
    }

    public void isDisplayEditor(boolean isHasVideo) {
        this.tvImageEditor.setVisibility(PictureSelectionConfig.editMediaEventListener != null && !isHasVideo ? 0 : 8);
    }

    @Override
    public void setBottomNavBarStyle() {
        super.setBottomNavBarStyle();
        BottomNavBarStyle bottomBarStyle = PictureSelectionConfig.selectorStyle.getBottomBarStyle();
        int backgroundColor = bottomBarStyle.getBottomPreviewNarBarBackgroundColor();
        if (StyleUtils.checkStyleValidity(backgroundColor)) {
            this.setBackgroundColor(backgroundColor);
        }
    }

    @Override
    public void onClick(View view) {
        super.onClick(view);
        if (view.getId() == R.id.ps_tv_editor && this.bottomNavBarListener != null) {
            this.bottomNavBarListener.onEditImage();
        }
    }
}

