/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.PictureOnlyCameraFragment;
import com.luck.picture.lib.PictureSelectorPreviewFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.basic.PictureSelectorSupporterActivity;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.engine.CompressEngine;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.ExtendLoaderEngine;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.engine.OriginalFileEngine;
import com.luck.picture.lib.engine.SandboxFileEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnCameraInterceptListener;
import com.luck.picture.lib.interfaces.OnExternalPreviewEventListener;
import com.luck.picture.lib.interfaces.OnMediaEditInterceptListener;
import com.luck.picture.lib.interfaces.OnPermissionsInterceptListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PictureSelectionModel {
    private final PictureSelectionConfig selectionConfig;
    private final PictureSelector selector;

    public PictureSelectionModel(PictureSelector selector) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
    }

    public PictureSelectionModel(PictureSelector selector, int chooseMode) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.chooseMode = chooseMode;
    }

    public PictureSelectionModel(PictureSelector selector, int chooseMode, boolean isOnlyCamera) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.isOnlyCamera = isOnlyCamera;
        this.selectionConfig.chooseMode = chooseMode;
    }

    public PictureSelectionModel setSelectorUIStyle(PictureSelectorStyle uiStyle) {
        if (uiStyle != null) {
            PictureSelectionConfig.selectorStyle = uiStyle;
        }
        return this;
    }

    public PictureSelectionModel setLanguage(int language) {
        this.selectionConfig.language = language;
        return this;
    }

    public PictureSelectionModel setImageEngine(ImageEngine engine) {
        if (PictureSelectionConfig.imageEngine != engine) {
            PictureSelectionConfig.imageEngine = engine;
        }
        return this;
    }

    public PictureSelectionModel setCompressEngine(CompressEngine engine) {
        if (PictureSelectionConfig.compressEngine != engine) {
            PictureSelectionConfig.compressEngine = engine;
            this.selectionConfig.isCompressEngine = true;
        } else {
            this.selectionConfig.isCompressEngine = false;
        }
        return this;
    }

    public PictureSelectionModel setCropEngine(CropEngine engine) {
        if (PictureSelectionConfig.cropEngine != engine) {
            PictureSelectionConfig.cropEngine = engine;
        }
        return this;
    }

    public PictureSelectionModel setSandboxFileEngine(SandboxFileEngine engine) {
        if (SdkVersionUtils.isQ() && PictureSelectionConfig.sandboxFileEngine != engine) {
            PictureSelectionConfig.sandboxFileEngine = engine;
            this.selectionConfig.isSandboxFileEngine = true;
        } else {
            this.selectionConfig.isSandboxFileEngine = false;
        }
        return this;
    }

    public PictureSelectionModel setOriginalFileEngine(OriginalFileEngine engine) {
        if (SdkVersionUtils.isQ() && PictureSelectionConfig.originalFileEngine != engine) {
            PictureSelectionConfig.originalFileEngine = engine;
            this.selectionConfig.isOriginalFileEngine = true;
        } else {
            this.selectionConfig.isOriginalFileEngine = false;
        }
        return this;
    }

    public PictureSelectionModel setExtendLoaderEngine(ExtendLoaderEngine engine) {
        if (PictureSelectionConfig.loaderDataEngine != engine) {
            PictureSelectionConfig.loaderDataEngine = engine;
            this.selectionConfig.isLoaderDataEngine = true;
        } else {
            this.selectionConfig.isLoaderDataEngine = false;
        }
        return this;
    }

    public PictureSelectionModel setCameraInterceptListener(OnCameraInterceptListener listener) {
        PictureSelectionConfig.interceptCameraListener = listener;
        return this;
    }

    public PictureSelectionModel setEditMediaInterceptListener(OnMediaEditInterceptListener listener) {
        PictureSelectionConfig.editMediaEventListener = listener;
        return this;
    }

    public PictureSelectionModel setPermissionsInterceptListener(OnPermissionsInterceptListener listener) {
        PictureSelectionConfig.permissionsEventListener = listener;
        return this;
    }

    public PictureSelectionModel setCameraForegroundService(boolean isForeground) {
        this.selectionConfig.isCameraForegroundService = isForeground;
        return this;
    }

    public PictureSelectionModel isUseIOBufferPool(boolean isUseBufferPool) {
        this.selectionConfig.isUseBufferPool = isUseBufferPool;
        return this;
    }

    public PictureSelectionModel setRequestedOrientation(int requestedOrientation) {
        this.selectionConfig.requestedOrientation = requestedOrientation;
        return this;
    }

    public PictureSelectionModel selectionMode(int selectionMode) {
        this.selectionConfig.selectionMode = selectionMode;
        this.selectionConfig.maxSelectNum = this.selectionConfig.selectionMode == 1 ? 1 : this.selectionConfig.maxSelectNum;
        return this;
    }

    public PictureSelectionModel isWithSelectVideoImage(boolean isWithVideoImage) {
        this.selectionConfig.isWithVideoImage = this.selectionConfig.selectionMode != 1 && this.selectionConfig.chooseMode == SelectMimeType.ofAll() && isWithVideoImage;
        return this;
    }

    public PictureSelectionModel setOfAllCameraType(int ofAllCameraType) {
        this.selectionConfig.ofAllCameraType = ofAllCameraType;
        return this;
    }

    public PictureSelectionModel isMaxSelectEnabledMask(boolean isMaxSelectEnabledMask) {
        this.selectionConfig.isMaxSelectEnabledMask = isMaxSelectEnabledMask;
        return this;
    }

    public PictureSelectionModel isSyncCover(boolean isSyncCover) {
        this.selectionConfig.isSyncCover = isSyncCover;
        return this;
    }

    public PictureSelectionModel setMaxSelectNum(int maxSelectNum) {
        this.selectionConfig.maxSelectNum = this.selectionConfig.selectionMode == 1 ? 1 : maxSelectNum;
        return this;
    }

    public PictureSelectionModel setMinSelectNum(int minSelectNum) {
        this.selectionConfig.minSelectNum = minSelectNum;
        return this;
    }

    public PictureSelectionModel setMaxVideoSelectNum(int maxVideoSelectNum) {
        this.selectionConfig.maxVideoSelectNum = this.selectionConfig.chooseMode == SelectMimeType.ofVideo() ? 0 : maxVideoSelectNum;
        return this;
    }

    public PictureSelectionModel setMinVideoSelectNum(int minVideoSelectNum) {
        this.selectionConfig.minVideoSelectNum = minVideoSelectNum;
        return this;
    }

    public PictureSelectionModel isAutomaticTitleRecyclerTop(boolean isAutomaticTitleRecyclerTop) {
        this.selectionConfig.isAutomaticTitleRecyclerTop = isAutomaticTitleRecyclerTop;
        return this;
    }

    public PictureSelectionModel isDirectReturnSingle(boolean isDirectReturn) {
        this.selectionConfig.isDirectReturnSingle = this.selectionConfig.selectionMode == 1 && isDirectReturn;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, int pageSize) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, boolean isFilterInvalidFile) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.isFilterInvalidFile = isFilterInvalidFile;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, int pageSize, boolean isFilterInvalidFile) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        this.selectionConfig.isFilterInvalidFile = isFilterInvalidFile;
        return this;
    }

    public PictureSelectionModel setVideoQuality(int videoQuality) {
        this.selectionConfig.videoQuality = videoQuality;
        return this;
    }

    public PictureSelectionModel setCameraImageFormat(String imageFormat) {
        this.selectionConfig.cameraImageFormat = imageFormat;
        return this;
    }

    public PictureSelectionModel setCameraImageFormatForQ(String imageFormat) {
        this.selectionConfig.cameraImageFormatForQ = imageFormat;
        return this;
    }

    public PictureSelectionModel setCameraVideoFormat(String videoFormat) {
        this.selectionConfig.cameraVideoFormat = videoFormat;
        return this;
    }

    public PictureSelectionModel setCameraVideoFormatForQ(String videoFormat) {
        this.selectionConfig.cameraVideoFormatForQ = videoFormat;
        return this;
    }

    public PictureSelectionModel setCameraAudioFormat(String audioFormat) {
        this.selectionConfig.cameraAudioFormat = audioFormat;
        return this;
    }

    public PictureSelectionModel setCameraAudioFormatForQ(String audioFormat) {
        this.selectionConfig.cameraAudioFormatForQ = audioFormat;
        return this;
    }

    public PictureSelectionModel setVideoMaxSecond(int videoMaxSecond) {
        this.selectionConfig.videoMaxSecond = videoMaxSecond * 1000;
        return this;
    }

    public PictureSelectionModel setVideoMinSecond(int videoMinSecond) {
        this.selectionConfig.videoMinSecond = videoMinSecond * 1000;
        return this;
    }

    public PictureSelectionModel setRecordVideoMaxSecond(int maxSecond) {
        this.selectionConfig.recordVideoMaxSecond = maxSecond;
        return this;
    }

    public PictureSelectionModel setRecordVideoMinSecond(int minSecond) {
        this.selectionConfig.recordVideoMinSecond = minSecond;
        return this;
    }

    public PictureSelectionModel setImageSpanCount(int imageSpanCount) {
        this.selectionConfig.imageSpanCount = imageSpanCount;
        return this;
    }

    public PictureSelectionModel isEmptyResultReturn(boolean isEmptyReturn) {
        this.selectionConfig.isEmptyResultReturn = isEmptyReturn;
        return this;
    }

    public PictureSelectionModel isQuickCapture(boolean isQuickCapture) {
        this.selectionConfig.isQuickCapture = isQuickCapture;
        return this;
    }

    public PictureSelectionModel isZoomAnim(boolean zoomAnim) {
        this.selectionConfig.zoomAnim = zoomAnim;
        return this;
    }

    public PictureSelectionModel isAutoScalePreviewImage(boolean isAutoScalePreviewImage) {
        this.selectionConfig.isAutoScalePreviewImage = isAutoScalePreviewImage;
        return this;
    }

    public PictureSelectionModel isDisplayCamera(boolean isDisplayCamera) {
        this.selectionConfig.isDisplayCamera = isDisplayCamera;
        return this;
    }

    public PictureSelectionModel setOutputCameraDir(String outPutCameraDir) {
        this.selectionConfig.outPutCameraDir = outPutCameraDir;
        return this;
    }

    public PictureSelectionModel setOutputCameraImageFileName(String fileName) {
        this.selectionConfig.outPutCameraImageFileName = fileName;
        return this;
    }

    public PictureSelectionModel setOutputCameraVideoFileName(String fileName) {
        this.selectionConfig.outPutCameraVideoFileName = fileName;
        return this;
    }

    public PictureSelectionModel setQuerySandboxDir(String dir) {
        this.selectionConfig.sandboxDir = dir;
        return this;
    }

    public PictureSelectionModel isOnlyObtainSandboxDir(boolean isOnlySandboxDir) {
        this.selectionConfig.isOnlySandboxDir = isOnlySandboxDir;
        return this;
    }

    public PictureSelectionModel filterMaxFileSize(long fileKbSize) {
        this.selectionConfig.filterMaxFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionModel filterMinFileSize(long fileKbSize) {
        this.selectionConfig.filterMinFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionModel queryOnlyMimeType(String ... mimeTypes) {
        if (mimeTypes != null && mimeTypes.length > 0) {
            this.selectionConfig.queryOnlyList.addAll(Arrays.asList(mimeTypes));
        }
        return this;
    }

    public PictureSelectionModel isGif(boolean isGif) {
        this.selectionConfig.isGif = isGif;
        return this;
    }

    public PictureSelectionModel isWebp(boolean isWebp) {
        this.selectionConfig.isWebp = isWebp;
        return this;
    }

    public PictureSelectionModel isBmp(boolean isBmp) {
        this.selectionConfig.isBmp = isBmp;
        return this;
    }

    public PictureSelectionModel isPreviewAudio(boolean enablePreviewAudio) {
        this.selectionConfig.isEnablePreviewAudio = enablePreviewAudio;
        return this;
    }

    public PictureSelectionModel isPreviewImage(boolean enablePreview) {
        this.selectionConfig.isEnablePreview = enablePreview;
        return this;
    }

    public PictureSelectionModel isPreviewVideo(boolean enPreviewVideo) {
        this.selectionConfig.isEnPreviewVideo = enPreviewVideo;
        return this;
    }

    public PictureSelectionModel isHidePreviewDownload(boolean isHidePreviewDownload) {
        this.selectionConfig.isHidePreviewDownload = isHidePreviewDownload;
        return this;
    }

    public PictureSelectionModel isOpenClickSound(boolean isClickSound) {
        this.selectionConfig.isOpenClickSound = !this.selectionConfig.isOnlyCamera && isClickSound;
        return this;
    }

    public PictureSelectionModel isCameraAroundState(boolean isCameraAroundState) {
        this.selectionConfig.isCameraAroundState = isCameraAroundState;
        return this;
    }

    public PictureSelectionModel isCameraRotateImage(boolean isCameraRotateImage) {
        this.selectionConfig.isCameraRotateImage = isCameraRotateImage;
        return this;
    }

    public PictureSelectionModel selectedData(List<LocalMedia> selectedList) {
        if (selectedList == null) {
            return this;
        }
        if (this.selectionConfig.selectionMode == 1 && this.selectionConfig.isDirectReturnSingle) {
            SelectedManager.clear();
        } else {
            SelectedManager.getSelectedResult().addAll(new ArrayList<LocalMedia>(selectedList));
        }
        return this;
    }

    public PictureSelectionModel setRecyclerAnimationMode(int animationMode) {
        this.selectionConfig.animationMode = animationMode;
        return this;
    }

    public void startFragmentPreview(int position, List<LocalMedia> list, boolean isDisplayDelete, OnExternalPreviewEventListener listener) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("getActivity is null");
            }
            if (PictureSelectionConfig.imageEngine == null) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            if (list == null || list.size() == 0) {
                throw new NullPointerException("preview data is null");
            }
            PictureSelectionConfig.previewEventListener = listener;
            FragmentManager fragmentManager = null;
            if (activity instanceof AppCompatActivity) {
                fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
            } else if (activity instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException(" FragmentManager is empty ");
            }
            if (ActivityCompatHelper.checkFragmentNonExits((FragmentActivity)activity, PictureSelectorPreviewFragment.TAG)) {
                PictureSelectorPreviewFragment fragment = PictureSelectorPreviewFragment.newInstance();
                ArrayList<LocalMedia> previewData = new ArrayList<LocalMedia>(list);
                PictureSelectionConfig.selectorStyle.getSelectMainStyle().setPreviewDisplaySelectGallery(false);
                fragment.setExternalPreviewData(position, previewData.size(), previewData, isDisplayDelete);
                FragmentInjectManager.injectSystemRoomFragment(fragmentManager, PictureSelectorPreviewFragment.TAG, fragment);
            }
        }
    }

    public void startActivityPreview(int position, ArrayList<LocalMedia> list, boolean isDisplayDelete, OnExternalPreviewEventListener listener) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("getActivity is null");
            }
            if (PictureSelectionConfig.imageEngine == null) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            if (list == null || list.size() == 0) {
                throw new NullPointerException("preview data is null");
            }
            PictureSelectionConfig.previewEventListener = listener;
            Intent intent = new Intent((Context)activity, PictureSelectorSupporterActivity.class);
            SelectedManager.addSelectedPreviewResult(list);
            intent.putExtra("com.luck.picture.lib.external_preview", true);
            intent.putExtra("com.luck.picture.lib.current_preview_position", position);
            intent.putExtra("com.luck.picture.lib.external_preview_display_delete", isDisplayDelete);
            activity.startActivity(intent);
            PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
            activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.ps_anim_fade_in);
        }
    }

    public void forResult(OnResultCallbackListener<LocalMedia> call) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("getActivity is null");
            }
            if (call == null) {
                throw new NullPointerException("OnResultCallbackListener is null");
            }
            if (PictureSelectionConfig.imageEngine == null) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            this.selectionConfig.isResultBack = true;
            this.selectionConfig.isActivityResultBack = false;
            PictureSelectionConfig.resultCallListener = call;
            if (this.selectionConfig.isOnlyCamera) {
                FragmentManager fragmentManager = null;
                if (activity instanceof AppCompatActivity) {
                    fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
                } else if (activity instanceof FragmentActivity) {
                    fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
                }
                if (fragmentManager == null) {
                    throw new NullPointerException(" FragmentManager is empty ");
                }
                if (ActivityCompatHelper.checkFragmentNonExits((FragmentActivity)activity, PictureOnlyCameraFragment.TAG)) {
                    FragmentInjectManager.injectSystemRoomFragment(fragmentManager, PictureOnlyCameraFragment.TAG, PictureOnlyCameraFragment.newInstance());
                }
            } else {
                Intent intent = new Intent((Context)activity, PictureSelectorSupporterActivity.class);
                activity.startActivity(intent);
                PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
                activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.ps_anim_fade_in);
            }
        }
    }

    public void forResult(int requestCode) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("getActivity is null");
            }
            if (PictureSelectionConfig.imageEngine == null) {
                throw new NullPointerException("imageEngine is null,Please implement ImageEngine");
            }
            this.selectionConfig.isResultBack = false;
            this.selectionConfig.isActivityResultBack = true;
            if (this.selectionConfig.isOnlyCamera) {
                FragmentManager fragmentManager = null;
                if (activity instanceof AppCompatActivity) {
                    fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
                } else if (activity instanceof FragmentActivity) {
                    fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
                }
                if (fragmentManager == null) {
                    throw new NullPointerException(" FragmentManager is empty ");
                }
                if (ActivityCompatHelper.checkFragmentNonExits((FragmentActivity)activity, PictureOnlyCameraFragment.TAG)) {
                    FragmentInjectManager.injectSystemRoomFragment(fragmentManager, PictureOnlyCameraFragment.TAG, PictureOnlyCameraFragment.newInstance());
                }
            } else {
                Intent intent = new Intent((Context)activity, PictureSelectorSupporterActivity.class);
                activity.startActivityForResult(intent, requestCode);
                PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
                activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.ps_anim_fade_in);
            }
        }
    }
}

