/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PicturePreviewAdapter;
import com.luck.picture.lib.adapter.holder.PreviewGalleryAdapter;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.basic.PictureSelectorSupporterActivity;
import com.luck.picture.lib.config.Crop;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.decoration.ViewPage2ItemDecoration;
import com.luck.picture.lib.decoration.WrapContentLinearLayoutManager;
import com.luck.picture.lib.dialog.PictureCommonDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.loader.LocalMediaLoader;
import com.luck.picture.lib.loader.LocalMediaPageLoader;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.style.TitleBarStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DownloadFileUtils;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.utils.ValueOf;
import com.luck.picture.lib.widget.BottomNavBar;
import com.luck.picture.lib.widget.CompleteSelectView;
import com.luck.picture.lib.widget.PreviewBottomNavBar;
import com.luck.picture.lib.widget.PreviewTitleBar;
import com.luck.picture.lib.widget.TitleBar;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PictureSelectorPreviewFragment
extends PictureCommonFragment {
    public static final String TAG = PictureSelectorPreviewFragment.class.getSimpleName();
    private ArrayList<LocalMedia> mData = new ArrayList();
    private PreviewTitleBar titleBar;
    private PreviewBottomNavBar bottomNarBar;
    private ViewPager2 viewPager;
    private PicturePreviewAdapter viewPageAdapter;
    protected boolean isHasMore = true;
    private int curPosition;
    private boolean isBottomPreview;
    private String currentAlbum;
    private boolean isShowCamera;
    private boolean isExternalPreview;
    private boolean isDisplayDelete;
    private int totalNum;
    private int screenWidth;
    private boolean isTransformPage = false;
    private long mBucketId = -1L;
    private TextView tvSelected;
    private TextView tvSelectedWord;
    private View selectClickArea;
    private CompleteSelectView completeSelectView;
    private RecyclerView mGalleryRecycle;
    private PreviewGalleryAdapter mGalleryAdapter;
    private final ViewPager2.OnPageChangeCallback pageChangeCallback = new ViewPager2.OnPageChangeCallback(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            LocalMedia currentMedia = positionOffsetPixels < PictureSelectorPreviewFragment.this.screenWidth / 2 ? (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(position) : (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(position + 1);
            PictureSelectorPreviewFragment.this.tvSelected.setSelected(PictureSelectorPreviewFragment.this.isSelected(currentMedia));
            PictureSelectorPreviewFragment.this.notifySelectNumberStyle(currentMedia);
        }

        public void onPageSelected(int position) {
            PictureSelectorPreviewFragment.this.curPosition = position;
            PictureSelectorPreviewFragment.this.titleBar.setTitle(PictureSelectorPreviewFragment.this.curPosition + 1 + "/" + PictureSelectorPreviewFragment.this.totalNum);
            LocalMedia currentMedia = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(position);
            PictureSelectorPreviewFragment.this.notifySelectNumberStyle(currentMedia);
            if (PictureSelectorPreviewFragment.this.mGalleryAdapter != null) {
                PictureSelectorPreviewFragment.this.mGalleryAdapter.isSelectMedia(currentMedia);
            }
            PictureSelectorPreviewFragment.this.bottomNarBar.isDisplayEditor(PictureMimeType.isHasVideo(currentMedia.getMimeType()));
            if (!(PictureSelectorPreviewFragment.this.isExternalPreview || PictureSelectorPreviewFragment.this.isBottomPreview || ((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isOnlySandboxDir || !((PictureSelectorPreviewFragment)PictureSelectorPreviewFragment.this).config.isPageStrategy || !PictureSelectorPreviewFragment.this.isHasMore || position != PictureSelectorPreviewFragment.this.viewPageAdapter.getItemCount() - 1 - 10 && position != PictureSelectorPreviewFragment.this.viewPageAdapter.getItemCount() - 1)) {
                PictureSelectorPreviewFragment.this.loadMoreData();
            }
        }
    };

    public static PictureSelectorPreviewFragment newInstance() {
        PictureSelectorPreviewFragment fragment = new PictureSelectorPreviewFragment();
        fragment.setArguments(new Bundle());
        return fragment;
    }

    public void setInternalPreviewData(boolean isBottomPreview, String currentAlbum, boolean isShowCamera, int position, int totalNum, int page, long currentBucketId, ArrayList<LocalMedia> data) {
        this.mPage = page;
        this.mBucketId = currentBucketId;
        this.mData = data;
        this.totalNum = totalNum;
        this.curPosition = position;
        this.currentAlbum = currentAlbum;
        this.isShowCamera = isShowCamera;
        this.isBottomPreview = isBottomPreview;
    }

    public void setExternalPreviewData(int position, int totalNum, ArrayList<LocalMedia> data, boolean isDisplayDelete) {
        this.mData = data;
        this.totalNum = totalNum;
        this.curPosition = position;
        this.isDisplayDelete = isDisplayDelete;
        this.isExternalPreview = true;
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_fragment_preview;
    }

    @Override
    public void onSelectedChange(boolean isAddRemove, LocalMedia currentMedia) {
        this.tvSelected.setSelected(SelectedManager.getSelectedResult().contains(currentMedia));
        this.bottomNarBar.setSelectedChange();
        this.completeSelectView.setSelectedChange(true);
        this.notifySelectNumberStyle(currentMedia);
        this.notifyPreviewGalleryData(isAddRemove, currentMedia);
    }

    @Override
    public void onCheckOriginalChange() {
        this.bottomNarBar.setOriginalCheck();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            this.mPage = savedInstanceState.getInt("com.luck.picture.lib.current_page", 1);
            this.mBucketId = savedInstanceState.getLong("com.luck.picture.lib.current_bucketId", -1L);
            this.curPosition = savedInstanceState.getInt("com.luck.picture.lib.current_preview_position", this.curPosition);
            this.isShowCamera = savedInstanceState.getBoolean("com.luck.picture.lib.display_camera", this.isShowCamera);
            this.totalNum = savedInstanceState.getInt("com.luck.picture.lib.current_album_total", this.totalNum);
            this.isExternalPreview = savedInstanceState.getBoolean("com.luck.picture.lib.external_preview", this.isExternalPreview);
            this.isDisplayDelete = savedInstanceState.getBoolean("com.luck.picture.lib.external_preview_display_delete", this.isDisplayDelete);
            this.isBottomPreview = savedInstanceState.getBoolean("com.luck.picture.lib.bottom_preview", this.isBottomPreview);
        }
        this.screenWidth = DensityUtil.getScreenWidth(this.getContext());
        this.titleBar = (PreviewTitleBar)view.findViewById(R.id.title_bar);
        this.tvSelected = (TextView)view.findViewById(R.id.ps_tv_selected);
        this.tvSelectedWord = (TextView)view.findViewById(R.id.ps_tv_selected_word);
        this.selectClickArea = view.findViewById(R.id.select_click_area);
        this.completeSelectView = (CompleteSelectView)view.findViewById(R.id.ps_complete_select);
        this.viewPager = (ViewPager2)view.findViewById(R.id.preview_pager);
        this.bottomNarBar = (PreviewBottomNavBar)view.findViewById(R.id.bottom_nar_bar);
        this.initTitleBar();
        if (this.isExternalPreview) {
            if (savedInstanceState != null || this.mData.size() == 0) {
                this.mData = new ArrayList<LocalMedia>(SelectedManager.getSelectedPreviewResult());
            }
            SelectedManager.clearExternalPreviewData();
            this.initViewPagerData();
            this.externalPreviewStyle();
            this.initViewPagerData();
        } else {
            this.initLoader();
            this.initBottomNavBar();
            this.initPreviewSelectGallery(view);
            this.initComplete();
            if (savedInstanceState != null && this.mData.size() == 0) {
                if (this.isBottomPreview) {
                    this.mData = new ArrayList<LocalMedia>(SelectedManager.getSelectedResult());
                    this.initViewPagerData();
                } else if (this.config.isPageStrategy) {
                    this.loadData(this.mPage * this.config.pageSize);
                } else {
                    this.mLoader = new LocalMediaPageLoader(this.getContext(), this.config);
                    this.loadData(this.totalNum);
                }
            } else {
                this.initViewPagerData();
            }
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("com.luck.picture.lib.current_page", this.mPage);
        outState.putLong("com.luck.picture.lib.current_bucketId", this.mBucketId);
        outState.putInt("com.luck.picture.lib.current_preview_position", this.curPosition);
        outState.putInt("com.luck.picture.lib.current_album_total", this.totalNum);
        outState.putBoolean("com.luck.picture.lib.external_preview", this.isExternalPreview);
        outState.putBoolean("com.luck.picture.lib.external_preview_display_delete", this.isDisplayDelete);
        outState.putBoolean("com.luck.picture.lib.display_camera", this.isShowCamera);
        outState.putBoolean("com.luck.picture.lib.bottom_preview", this.isBottomPreview);
        if (this.isExternalPreview) {
            SelectedManager.addSelectedPreviewResult(this.mData);
        }
    }

    @Override
    public void subSelectPosition(boolean isRefreshAdapter) {
        if (PictureSelectionConfig.selectorStyle.getSelectMainStyle().isPreviewSelectNumberStyle() && PictureSelectionConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            for (int index = 0; index < SelectedManager.getCount(); ++index) {
                LocalMedia media = SelectedManager.getSelectedResult().get(index);
                media.setNum(index + 1);
            }
        }
    }

    protected void initLoader() {
        this.mLoader = this.config.isPageStrategy ? new LocalMediaPageLoader(this.getContext(), this.config) : new LocalMediaLoader(this.getContext(), this.config);
    }

    private void loadData(int pageSize) {
        if (this.config.isOnlySandboxDir) {
            if (PictureSelectionConfig.loaderDataEngine != null) {
                PictureSelectionConfig.loaderDataEngine.loadOnlyInAppDirAllMediaData(this.getContext(), new OnQueryAlbumListener<LocalMediaFolder>(){

                    @Override
                    public void onComplete(LocalMediaFolder folder) {
                        PictureSelectorPreviewFragment.this.handleLoadData(folder.getData());
                    }
                });
            } else {
                this.mLoader.loadOnlyInAppDirAllMedia(new OnQueryAlbumListener<LocalMediaFolder>(){

                    @Override
                    public void onComplete(LocalMediaFolder folder) {
                        PictureSelectorPreviewFragment.this.handleLoadData(folder.getData());
                    }
                });
            }
        } else if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadFirstPageMediaData(this.getContext(), this.mBucketId, 1, pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleLoadData(result);
                }
            });
        } else {
            this.mLoader.loadFirstPageMedia(this.mBucketId, pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleLoadData(result);
                }
            });
        }
    }

    private void handleLoadData(ArrayList<LocalMedia> result) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.mData = result;
        if (this.mData.size() == 0) {
            this.iBridgePictureBehavior.onSelectFinish(false, null);
            return;
        }
        int position = this.isShowCamera ? 0 : -1;
        for (int i = 0; i < this.mData.size(); ++i) {
            this.mData.get(i).setPosition(++position);
        }
        this.initViewPagerData();
    }

    private void loadMoreData() {
        ++this.mPage;
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadMoreMediaData(this.getContext(), this.mBucketId, this.mPage, this.config.pageSize, this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleMoreData(result, isHasMore);
                }
            });
        } else {
            this.mLoader.loadPageMediaData(this.mBucketId, this.mPage, this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorPreviewFragment.this.handleMoreData(result, isHasMore);
                }
            });
        }
    }

    private void handleMoreData(List<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.isHasMore = isHasMore;
        if (isHasMore) {
            if (result.size() > 0) {
                int oldStartPosition = this.mData.size();
                this.mData.addAll(result);
                int itemCount = this.mData.size();
                this.viewPageAdapter.notifyItemRangeChanged(oldStartPosition, itemCount);
            } else {
                this.loadMoreData();
            }
        }
    }

    private void initComplete() {
        final SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
        if (StyleUtils.checkStyleValidity(selectMainStyle.getPreviewSelectBackground())) {
            this.tvSelected.setBackgroundResource(selectMainStyle.getPreviewSelectBackground());
        } else if (StyleUtils.checkStyleValidity(selectMainStyle.getSelectBackground())) {
            this.tvSelected.setBackgroundResource(selectMainStyle.getSelectBackground());
        }
        if (StyleUtils.checkTextValidity(selectMainStyle.getPreviewSelectText())) {
            this.tvSelectedWord.setText((CharSequence)selectMainStyle.getPreviewSelectText());
        } else {
            this.tvSelectedWord.setText((CharSequence)"");
        }
        if (StyleUtils.checkSizeValidity(selectMainStyle.getPreviewSelectTextSize())) {
            this.tvSelectedWord.setTextSize((float)selectMainStyle.getPreviewSelectTextSize());
        }
        if (StyleUtils.checkStyleValidity(selectMainStyle.getPreviewSelectTextColor())) {
            this.tvSelectedWord.setTextColor(selectMainStyle.getPreviewSelectTextColor());
        }
        if (StyleUtils.checkSizeValidity(selectMainStyle.getPreviewSelectMarginRight())) {
            ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams();
            layoutParams.rightMargin = selectMainStyle.getPreviewSelectMarginRight();
        }
        this.completeSelectView.setCompleteSelectViewStyle();
        if (selectMainStyle.isCompleteSelectRelativeTop()) {
            ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topToTop = R.id.title_bar;
            ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).bottomToBottom = R.id.title_bar;
        }
        if (selectMainStyle.isPreviewSelectRelativeBottom()) {
            ((ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
            ((ConstraintLayout.LayoutParams)this.tvSelected.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
            ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
            ((ConstraintLayout.LayoutParams)this.tvSelectedWord.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
            ((ConstraintLayout.LayoutParams)this.selectClickArea.getLayoutParams()).topToTop = R.id.bottom_nar_bar;
            ((ConstraintLayout.LayoutParams)this.selectClickArea.getLayoutParams()).bottomToBottom = R.id.bottom_nar_bar;
        }
        this.completeSelectView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isComplete = true;
                if (selectMainStyle.isCompleteSelectRelativeTop() && SelectedManager.getCount() == 0) {
                    boolean bl = isComplete = PictureSelectorPreviewFragment.this.confirmSelect((LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem()), false) == 0;
                }
                if (isComplete) {
                    PictureSelectorPreviewFragment.this.dispatchTransformResult();
                }
            }
        });
    }

    private void initTitleBar() {
        if (PictureSelectionConfig.selectorStyle.getTitleBarStyle().isHideTitleBar()) {
            this.titleBar.setVisibility(8);
        }
        this.titleBar.setTitleBarStyle();
        this.titleBar.setOnTitleBarListener(new TitleBar.OnTitleBarListener(){

            @Override
            public void onBackPressed() {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    PictureSelectorPreviewFragment.this.handleExternalPreviewBack();
                } else {
                    PictureSelectorPreviewFragment.this.iBridgePictureBehavior.onSelectFinish(false, null);
                }
            }
        });
        this.titleBar.setTitle(this.curPosition + 1 + "/" + this.totalNum);
        this.selectClickArea.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    PictureSelectorPreviewFragment.this.deletePreview();
                } else {
                    LocalMedia currentMedia = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                    int selectResultCode = PictureSelectorPreviewFragment.this.confirmSelect(currentMedia, PictureSelectorPreviewFragment.this.tvSelected.isSelected());
                    if (selectResultCode == 0) {
                        PictureSelectorPreviewFragment.this.tvSelected.startAnimation(AnimationUtils.loadAnimation((Context)PictureSelectorPreviewFragment.this.getContext(), (int)R.anim.ps_anim_modal_in));
                    }
                }
            }
        });
        this.tvSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PictureSelectorPreviewFragment.this.selectClickArea.performClick();
            }
        });
    }

    private void initPreviewSelectGallery(View group) {
        SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
        if (selectMainStyle.isPreviewDisplaySelectGallery() && group instanceof ConstraintLayout) {
            this.mGalleryRecycle = new RecyclerView(this.getContext());
            if (StyleUtils.checkStyleValidity(selectMainStyle.getAdapterPreviewGalleryBackgroundResource())) {
                this.mGalleryRecycle.setBackgroundResource(selectMainStyle.getAdapterPreviewGalleryBackgroundResource());
            } else {
                this.mGalleryRecycle.setBackgroundResource(R.drawable.ps_preview_gallery_bg);
            }
            ((ConstraintLayout)group).addView((View)this.mGalleryRecycle);
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.mGalleryRecycle.getLayoutParams();
            params.width = -1;
            params.height = -2;
            params.bottomToTop = R.id.bottom_nar_bar;
            params.startToStart = 0;
            params.endToEnd = 0;
            WrapContentLinearLayoutManager layoutManager = new WrapContentLinearLayoutManager(this.getContext());
            layoutManager.setOrientation(0);
            this.mGalleryRecycle.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            this.mGalleryRecycle.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(Integer.MAX_VALUE, DensityUtil.dip2px(this.getContext(), 6.0f), true));
            this.mGalleryAdapter = new PreviewGalleryAdapter(SelectedManager.getSelectedResult());
            this.mGalleryAdapter.isSelectMedia(this.mData.get(this.curPosition));
            this.mGalleryRecycle.setAdapter((RecyclerView.Adapter)this.mGalleryAdapter);
            this.mGalleryAdapter.setItemClickListener(new PreviewGalleryAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position, LocalMedia media, View v) {
                    if (PictureSelectorPreviewFragment.this.isBottomPreview || TextUtils.equals((CharSequence)PictureSelectorPreviewFragment.this.currentAlbum, (CharSequence)PictureSelectorPreviewFragment.this.getString(R.string.ps_camera_roll)) || TextUtils.equals((CharSequence)media.getParentFolderName(), (CharSequence)PictureSelectorPreviewFragment.this.currentAlbum)) {
                        int newPosition = PictureSelectorPreviewFragment.this.isBottomPreview ? position : (PictureSelectorPreviewFragment.this.isShowCamera ? media.position - 1 : media.position);
                        PictureSelectorPreviewFragment.this.viewPager.setCurrentItem(newPosition, false);
                    }
                }
            });
            if (SelectedManager.getCount() > 0) {
                this.mGalleryRecycle.setVisibility(0);
            } else {
                this.mGalleryRecycle.setVisibility(4);
            }
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void deletePreview() {
        if (PictureSelectionConfig.previewEventListener != null) {
            PictureSelectionConfig.previewEventListener.onPreviewDelete(this.viewPager.getCurrentItem());
            int currentItem = this.viewPager.getCurrentItem();
            this.mData.remove(currentItem);
            if (this.mData.size() == 0) {
                this.handleExternalPreviewBack();
                return;
            }
            this.titleBar.setTitle(this.getString(R.string.ps_preview_image_num, new Object[]{this.curPosition + 1, this.mData.size()}));
            this.totalNum = this.mData.size();
            this.curPosition = currentItem;
            this.viewPager.setCurrentItem(this.curPosition, false);
            this.isTransformPage = true;
            this.viewPager.setPageTransformer(new ViewPager2.PageTransformer(){

                public void transformPage(@NonNull View page, float position) {
                    if (PictureSelectorPreviewFragment.this.isTransformPage) {
                        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)page, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
                        animator.setDuration(450L);
                        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                        animator.start();
                        PictureSelectorPreviewFragment.this.isTransformPage = false;
                    }
                }
            });
            this.viewPageAdapter.notifyDataSetChanged();
        }
    }

    private void handleExternalPreviewBack() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (this.getActivity() instanceof PictureSelectorSupporterActivity) {
                this.iBridgePictureBehavior.onSelectFinish(false, null);
            } else {
                this.getActivity().getSupportFragmentManager().popBackStack();
            }
        }
    }

    private void initBottomNavBar() {
        this.bottomNarBar.setBottomNavBarStyle();
        this.bottomNarBar.setSelectedChange();
        this.bottomNarBar.setOnBottomNavBarListener(new BottomNavBar.OnBottomNavBarListener(){

            @Override
            public void onEditImage() {
                if (PictureSelectionConfig.editMediaEventListener != null) {
                    LocalMedia media = (LocalMedia)PictureSelectorPreviewFragment.this.mData.get(PictureSelectorPreviewFragment.this.viewPager.getCurrentItem());
                    PictureSelectionConfig.editMediaEventListener.onStartMediaEdit(PictureSelectorPreviewFragment.this, media, 696);
                }
            }

            @Override
            public void onCheckOriginalChange() {
                PictureSelectorPreviewFragment.this.sendSelectedOriginalChangeEvent();
            }
        });
    }

    private void externalPreviewStyle() {
        TitleBarStyle titleBarStyle = PictureSelectionConfig.selectorStyle.getTitleBarStyle();
        int deleteBackgroundResource = titleBarStyle.getPreviewDeleteBackgroundResource();
        if (StyleUtils.checkStyleValidity(deleteBackgroundResource)) {
            this.tvSelected.setBackgroundResource(deleteBackgroundResource);
        } else {
            this.tvSelected.setBackgroundResource(R.drawable.ps_ic_delete);
        }
        this.tvSelected.setVisibility(this.isDisplayDelete ? 0 : 8);
        this.tvSelected.setVisibility(this.isDisplayDelete ? 0 : 8);
        this.bottomNarBar.setVisibility(8);
        this.completeSelectView.setVisibility(8);
    }

    private void initViewPagerData() {
        this.viewPageAdapter = new PicturePreviewAdapter(this.getContext(), this.mData, this.config);
        this.viewPageAdapter.setOnPreviewEventListener(new PicturePreviewAdapter.OnPreviewEventListener(){

            @Override
            public void onBackPressed() {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    PictureSelectorPreviewFragment.this.handleExternalPreviewBack();
                } else {
                    PictureSelectorPreviewFragment.this.iBridgePictureBehavior.onSelectFinish(false, null);
                }
            }

            @Override
            public void onPreviewVideoTitle(String videoName) {
                if (TextUtils.isEmpty((CharSequence)videoName)) {
                    PictureSelectorPreviewFragment.this.titleBar.setTitle(PictureSelectorPreviewFragment.this.curPosition + 1 + "/" + PictureSelectorPreviewFragment.this.totalNum);
                } else {
                    PictureSelectorPreviewFragment.this.titleBar.setTitle(videoName);
                }
            }

            @Override
            public void onLongPressDownload(LocalMedia media) {
                if (PictureSelectorPreviewFragment.this.isExternalPreview) {
                    PictureSelectorPreviewFragment.this.onExternalLongPressDownload(media);
                }
            }
        });
        this.viewPager.setOrientation(0);
        this.viewPager.addItemDecoration((RecyclerView.ItemDecoration)new ViewPage2ItemDecoration(1, DensityUtil.dip2px((Context)Objects.requireNonNull(this.getActivity()), 1.0f)));
        this.viewPager.setAdapter((RecyclerView.Adapter)this.viewPageAdapter);
        this.viewPager.setCurrentItem(this.curPosition, false);
        this.tvSelected.setSelected(SelectedManager.getSelectedResult().contains(this.mData.get(this.viewPager.getCurrentItem())));
        this.completeSelectView.setSelectedChange(true);
        this.viewPager.registerOnPageChangeCallback(this.pageChangeCallback);
        this.subSelectPosition(false);
        this.notifySelectNumberStyle(this.mData.get(this.curPosition));
    }

    private void onExternalLongPressDownload(final LocalMedia media) {
        if (PictureSelectionConfig.previewEventListener != null && !PictureSelectionConfig.previewEventListener.onLongPressDownload(media)) {
            PictureCommonDialog dialog = PictureCommonDialog.showDialog(this.getContext(), this.getContext().getString(R.string.ps_prompt), this.getContext().getString(R.string.ps_prompt_content));
            dialog.setOnDialogEventListener(new PictureCommonDialog.OnDialogEventListener(){

                @Override
                public void onConfirm() {
                    String path = TextUtils.isEmpty((CharSequence)media.getSandboxPath()) ? media.getPath() : media.getSandboxPath();
                    if (PictureMimeType.isHasHttp(path)) {
                        PictureSelectorPreviewFragment.this.showLoading();
                    }
                    DownloadFileUtils.saveLocalFile(PictureSelectorPreviewFragment.this.getContext(), path, media.getFileName(), media.getMimeType(), new OnCallbackListener<String>(){

                        @Override
                        public void onCall(String realPath) {
                            PictureSelectorPreviewFragment.this.dismissLoading();
                            if (TextUtils.isEmpty((CharSequence)realPath)) {
                                String errorMsg = PictureMimeType.isHasVideo(media.getMimeType()) ? PictureSelectorPreviewFragment.this.getString(R.string.ps_save_video_error) : PictureSelectorPreviewFragment.this.getString(R.string.ps_save_image_error);
                                Toast.makeText((Context)PictureSelectorPreviewFragment.this.getContext(), (CharSequence)errorMsg, (int)1).show();
                            } else {
                                Toast.makeText((Context)PictureSelectorPreviewFragment.this.getContext(), (CharSequence)(PictureSelectorPreviewFragment.this.getString(R.string.ps_save_success) + "\n" + realPath), (int)1).show();
                            }
                        }
                    });
                }
            });
        }
    }

    private void notifyPreviewGalleryData(boolean isAddRemove, LocalMedia currentMedia) {
        if (this.mGalleryAdapter != null && PictureSelectionConfig.selectorStyle.getSelectMainStyle().isPreviewDisplaySelectGallery()) {
            if (this.mGalleryRecycle.getVisibility() == 4) {
                this.mGalleryRecycle.setVisibility(0);
            }
            if (isAddRemove) {
                if (this.config.selectionMode == 1) {
                    this.mGalleryAdapter.clear();
                }
                this.mGalleryAdapter.addGalleryData(this.isBottomPreview, currentMedia);
            } else {
                this.mGalleryAdapter.removeGalleryData(this.isBottomPreview && this.totalNum > 1, currentMedia);
                if (this.mGalleryAdapter.getItemCount() == 0) {
                    this.mGalleryRecycle.setVisibility(4);
                }
            }
        }
    }

    public void notifySelectNumberStyle(LocalMedia currentMedia) {
        if (PictureSelectionConfig.selectorStyle.getSelectMainStyle().isPreviewSelectNumberStyle() && PictureSelectionConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            this.tvSelected.setText((CharSequence)"");
            for (int i = 0; i < SelectedManager.getCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!TextUtils.equals((CharSequence)media.getPath(), (CharSequence)currentMedia.getPath()) && media.getId() != currentMedia.getId()) continue;
                currentMedia.setNum(media.getNum());
                media.setPosition(currentMedia.getPosition());
                this.tvSelected.setText((CharSequence)ValueOf.toString(currentMedia.getNum()));
            }
        }
    }

    protected boolean isSelected(LocalMedia media) {
        return SelectedManager.getSelectedResult().contains(media);
    }

    @Override
    public void onEditMedia(Intent data) {
        LocalMedia media = this.mData.get(this.viewPager.getCurrentItem());
        Uri output = Crop.getOutput(data);
        media.setCutPath(output != null ? output.getPath() : "");
        media.setCropImageWidth(Crop.getOutputImageWidth(data));
        media.setCropImageHeight(Crop.getOutputImageHeight(data));
        media.setCropOffsetX(Crop.getOutputImageOffsetX(data));
        media.setCropOffsetY(Crop.getOutputImageOffsetY(data));
        media.setCropResultAspectRatio(Crop.getOutputCropAspectRatio(data));
        media.setCut(!TextUtils.isEmpty((CharSequence)media.getCutPath()));
        media.setCustomData(Crop.getOutputCustomExtraData(data));
        media.setEditorImage(media.isCut());
        media.setSandboxPath(media.getCutPath());
        if (!SelectedManager.getSelectedResult().contains(media)) {
            this.confirmSelect(media, false);
        }
        this.viewPageAdapter.notifyItemChanged(this.viewPager.getCurrentItem());
    }

    @Override
    public void onDestroy() {
        this.viewPageAdapter.destroyCurrentVideoHolder();
        this.viewPager.unregisterOnPageChangeCallback(this.pageChangeCallback);
        if (this.isExternalPreview) {
            PictureSelectionConfig.destroy();
        }
        super.onDestroy();
    }
}

