/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.CountDownTimer;
import android.view.MotionEvent;
import android.view.View;
import com.luck.lib.camerax.listener.CaptureListener;
import com.luck.lib.camerax.permissions.PermissionChecker;
import com.luck.lib.camerax.permissions.PermissionResultCallback;
import com.luck.lib.camerax.permissions.PermissionUtil;
import com.luck.lib.camerax.utils.DoubleUtils;

public class CaptureButton
extends View {
    private int state;
    private int buttonState;
    public static final int STATE_IDLE = 1;
    public static final int STATE_PRESS = 2;
    public static final int STATE_LONG_PRESS = 3;
    public static final int STATE_RECORDER_ING = 4;
    public static final int STATE_BAN = 5;
    private float event_Y;
    private Paint mPaint;
    private float strokeWidth;
    private int outside_add_size;
    private int inside_reduce_size;
    private float center_X;
    private float center_Y;
    private float button_radius;
    private float button_outside_radius;
    private float button_inside_radius;
    private int button_size;
    private float progress;
    private int maxDuration;
    private int minDuration;
    private int currentRecordedTime;
    private RectF rectF;
    private LongPressRunnable longPressRunnable;
    private CaptureListener captureListener;
    private RecordCountDownTimer timer;
    private boolean isTakeCamera = true;

    public CaptureButton(Context context) {
        super(context);
    }

    public CaptureButton(Context context, int size) {
        super(context);
        this.button_size = size;
        this.button_outside_radius = this.button_radius = (float)size / 2.0f;
        this.button_inside_radius = this.button_radius * 0.75f;
        this.strokeWidth = size / 15;
        this.outside_add_size = size / 8;
        this.inside_reduce_size = size / 8;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.progress = 0.0f;
        this.longPressRunnable = new LongPressRunnable();
        this.state = 1;
        this.buttonState = 0;
        this.maxDuration = 10000;
        this.minDuration = 1500;
        this.center_X = (this.button_size + this.outside_add_size * 2) / 2;
        this.center_Y = (this.button_size + this.outside_add_size * 2) / 2;
        this.rectF = new RectF(this.center_X - (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f), this.center_Y - (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f), this.center_X + (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f), this.center_Y + (this.button_radius + (float)this.outside_add_size - this.strokeWidth / 2.0f));
        this.timer = new RecordCountDownTimer(this.maxDuration, this.maxDuration / 360);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.button_size + this.outside_add_size * 2, this.button_size + this.outside_add_size * 2);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setStyle(Paint.Style.FILL);
        int outside_color = -287515428;
        this.mPaint.setColor(outside_color);
        canvas.drawCircle(this.center_X, this.center_Y, this.button_outside_radius, this.mPaint);
        int inside_color = -1;
        this.mPaint.setColor(inside_color);
        canvas.drawCircle(this.center_X, this.center_Y, this.button_inside_radius, this.mPaint);
        if (this.state == 4) {
            int progress_color = -300503530;
            this.mPaint.setColor(progress_color);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.strokeWidth);
            canvas.drawArc(this.rectF, -90.0f, this.progress, false, this.mPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isTakeCamera) {
            switch (event.getAction()) {
                case 0: {
                    if (event.getPointerCount() > 1 || this.state != 1) break;
                    this.event_Y = event.getY();
                    this.state = 2;
                    if (this.buttonState != 2 && this.buttonState != 0) break;
                    PermissionChecker.getInstance().requestPermissions((Activity)this.getContext(), new String[]{"android.permission.RECORD_AUDIO"}, new PermissionResultCallback(){

                        @Override
                        public void onGranted() {
                            CaptureButton.this.postDelayed(CaptureButton.this.longPressRunnable, 500L);
                        }

                        @Override
                        public void onDenied() {
                            PermissionUtil.goIntentSetting((Activity)CaptureButton.this.getContext(), 1103);
                        }
                    });
                    break;
                }
                case 2: {
                    if (this.captureListener == null || this.state != 4 || this.buttonState != 2 && this.buttonState != 0) break;
                    this.captureListener.recordZoom(this.event_Y - event.getY());
                    break;
                }
                case 1: {
                    this.handlerPressByState();
                }
            }
        }
        return true;
    }

    private void handlerPressByState() {
        this.removeCallbacks(this.longPressRunnable);
        switch (this.state) {
            case 2: {
                if (this.captureListener != null && (this.buttonState == 1 || this.buttonState == 0)) {
                    this.startCaptureAnimation(this.button_inside_radius);
                    break;
                }
                this.state = 1;
                break;
            }
            case 3: 
            case 4: {
                this.timer.cancel();
                this.recordEnd();
            }
        }
        this.state = 1;
    }

    public void recordEnd() {
        if (this.captureListener != null) {
            if (this.currentRecordedTime < this.minDuration) {
                this.captureListener.recordShort(this.currentRecordedTime);
            } else {
                this.captureListener.recordEnd(this.currentRecordedTime);
            }
        }
        this.resetRecordAnim();
    }

    private void resetRecordAnim() {
        this.state = 5;
        this.progress = 0.0f;
        this.invalidate();
        this.startRecordAnimation(this.button_outside_radius, this.button_radius, this.button_inside_radius, this.button_radius * 0.75f);
    }

    private void startCaptureAnimation(float inside_start) {
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_start * 0.75f, inside_start});
        inside_anim.addUpdateListener(animation -> {
            this.button_inside_radius = ((Float)animation.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        inside_anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (CaptureButton.this.captureListener != null) {
                    CaptureButton.this.captureListener.takePictures();
                }
                CaptureButton.this.state = 5;
            }
        });
        inside_anim.setDuration(50L);
        inside_anim.start();
    }

    private void startRecordAnimation(float outside_start, float outside_end, float inside_start, float inside_end) {
        ValueAnimator outside_anim = ValueAnimator.ofFloat((float[])new float[]{outside_start, outside_end});
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_end});
        outside_anim.addUpdateListener(animation -> {
            this.button_outside_radius = ((Float)animation.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        inside_anim.addUpdateListener(animation -> {
            this.button_inside_radius = ((Float)animation.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        AnimatorSet set = new AnimatorSet();
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (DoubleUtils.isFastDoubleClick()) {
                    return;
                }
                if (CaptureButton.this.state == 3) {
                    if (CaptureButton.this.captureListener != null) {
                        CaptureButton.this.captureListener.recordStart();
                    }
                    CaptureButton.this.state = 4;
                    CaptureButton.this.timer.start();
                } else {
                    CaptureButton.this.state = 1;
                }
            }
        });
        set.playTogether(new Animator[]{outside_anim, inside_anim});
        set.setDuration(100L);
        set.start();
    }

    private void updateProgress(long millisUntilFinished) {
        this.currentRecordedTime = (int)((long)this.maxDuration - millisUntilFinished);
        this.progress = 360.0f - (float)millisUntilFinished / (float)this.maxDuration * 360.0f;
        this.invalidate();
    }

    public void setMaxDuration(int duration) {
        this.maxDuration = duration;
        this.timer = new RecordCountDownTimer(duration, duration / 360);
    }

    public void setMinDuration(int duration) {
        this.minDuration = duration;
    }

    public void setCaptureListener(CaptureListener captureListener) {
        this.captureListener = captureListener;
    }

    public void setButtonFeatures(int state) {
        this.buttonState = state;
    }

    public int getButtonFeatures() {
        return this.buttonState;
    }

    public boolean isIdle() {
        return this.state == 1;
    }

    public void setButtonCaptureEnabled(boolean enabled) {
        this.isTakeCamera = enabled;
    }

    public void resetState() {
        this.state = 1;
    }

    private class LongPressRunnable
    implements Runnable {
        private LongPressRunnable() {
        }

        @Override
        public void run() {
            CaptureButton.this.state = 3;
            CaptureButton.this.startRecordAnimation(CaptureButton.this.button_outside_radius, CaptureButton.this.button_outside_radius + (float)CaptureButton.this.outside_add_size, CaptureButton.this.button_inside_radius, CaptureButton.this.button_inside_radius - (float)CaptureButton.this.inside_reduce_size);
        }
    }

    private class RecordCountDownTimer
    extends CountDownTimer {
        RecordCountDownTimer(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);
        }

        public void onTick(long millisUntilFinished) {
            CaptureButton.this.updateProgress(millisUntilFinished);
        }

        public void onFinish() {
            CaptureButton.this.recordEnd();
        }
    }
}

