/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.Objects;

public class PictureFileUtils {
    private static final int BYTE_SIZE = 8192;
    public static final String POSTFIX = ".jpeg";
    public static final String POST_VIDEO = ".mp4";
    public static final String POST_AUDIO = ".amr";
    static final String TAG = "PictureFileUtils";
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;

    public static File createCameraFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        return PictureFileUtils.createMediaFile(context, chooseMode, fileName, format, outCameraDirectory);
    }

    private static File createMediaFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        return PictureFileUtils.createOutFile(context, chooseMode, fileName, format, outCameraDirectory);
    }

    private static File createOutFile(Context ctx, int chooseMode, String fileName, String format, String outCameraDirectory) {
        File folderDir;
        Context context = ctx.getApplicationContext();
        if (TextUtils.isEmpty((CharSequence)outCameraDirectory)) {
            File rootDir;
            if (TextUtils.equals((CharSequence)"mounted", (CharSequence)Environment.getExternalStorageState())) {
                rootDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
                folderDir = new File(rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator);
            } else {
                rootDir = PictureFileUtils.getRootDirFile(context, chooseMode);
                folderDir = new File(rootDir.getAbsolutePath() + File.separator);
            }
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
        } else {
            folderDir = new File(outCameraDirectory);
            if (!Objects.requireNonNull(folderDir.getParentFile()).exists()) {
                folderDir.getParentFile().mkdirs();
            }
        }
        if (!folderDir.exists()) {
            folderDir.mkdirs();
        }
        boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)fileName);
        switch (chooseMode) {
            case 2: {
                String newFileVideoName = isOutFileNameEmpty ? DateUtils.getCreateFileName("VID_") + POST_VIDEO : fileName;
                return new File(folderDir, newFileVideoName);
            }
            case 3: {
                String newFileAudioName = isOutFileNameEmpty ? DateUtils.getCreateFileName("AUD_") + POST_AUDIO : fileName;
                return new File(folderDir, newFileAudioName);
            }
        }
        String suffix = TextUtils.isEmpty((CharSequence)format) ? POSTFIX : format;
        String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("IMG_") + suffix : fileName;
        return new File(folderDir, newFileImageName);
    }

    private static File getRootDirFile(Context context, int type) {
        switch (type) {
            case 2: {
                return context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            }
            case 3: {
                return context.getExternalFilesDir(Environment.DIRECTORY_MUSIC);
            }
        }
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    private PictureFileUtils() {
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (IllegalArgumentException ex) {
            Log.i((String)TAG, (String)String.format(Locale.getDefault(), "getDataColumn: _data - [%s]", ex.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return "";
    }

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context ctx, Uri uri) {
        boolean isKitKat;
        Context context = ctx.getApplicationContext();
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (PictureFileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    if (SdkVersionUtils.checkedAndroid_Q()) {
                        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + "/" + split[1];
                    }
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (PictureFileUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)ValueOf.toLong(id2));
                    return PictureFileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (PictureFileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return PictureFileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (PictureFileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return PictureFileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@NonNull String pathFrom, @NonNull String pathTo) {
        block6: {
            if (pathFrom.equalsIgnoreCase(pathTo)) {
                return;
            }
            FileChannel outputChannel = null;
            FileChannel inputChannel = null;
            try {
                inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
                outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
                inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
                PictureFileUtils.close(inputChannel);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                PictureFileUtils.close(inputChannel);
                PictureFileUtils.close(outputChannel);
            }
            PictureFileUtils.close(outputChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(FileInputStream fileInputStream, String outFilePath) {
        boolean bl;
        if (fileInputStream == null) {
            return false;
        }
        FileChannel inputChannel = null;
        FileChannel outputChannel = null;
        try {
            inputChannel = fileInputStream.getChannel();
            outputChannel = new FileOutputStream(new File(outFilePath)).getChannel();
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
            bl = true;
            PictureFileUtils.close(fileInputStream);
        }
        catch (Exception e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            PictureFileUtils.close(fileInputStream);
            PictureFileUtils.close(inputChannel);
            PictureFileUtils.close(outputChannel);
        }
        PictureFileUtils.close(inputChannel);
        PictureFileUtils.close(outputChannel);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(InputStream is, OutputStream os) {
        boolean bl;
        BufferedOutputStream osBuffer = null;
        BufferedInputStream isBuffer = null;
        try {
            int len;
            isBuffer = new BufferedInputStream(is);
            osBuffer = new BufferedOutputStream(os);
            byte[] data = new byte[8192];
            while ((len = isBuffer.read(data)) != -1) {
                os.write(data, 0, len);
            }
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                PictureFileUtils.close(isBuffer);
                PictureFileUtils.close(osBuffer);
                throw throwable;
            }
            PictureFileUtils.close(isBuffer);
            PictureFileUtils.close(osBuffer);
            return bl2;
        }
        PictureFileUtils.close(isBuffer);
        PictureFileUtils.close(osBuffer);
        return bl;
    }

    public static String rename(String fileName) {
        String temp = fileName.substring(0, fileName.lastIndexOf("."));
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        return temp + "_" + DateUtils.getCreateFileName() + suffix;
    }

    public static String getDCIMCameraPath() {
        String absolutePath;
        try {
            absolutePath = "%" + Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/Camera";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return absolutePath;
    }

    @Deprecated
    public static void deleteCacheDirFile(Context mContext, int type) {
        File[] files;
        File cutDir = mContext.getExternalFilesDir(type == PictureMimeType.ofImage() ? Environment.DIRECTORY_PICTURES : Environment.DIRECTORY_MOVIES);
        if (cutDir != null && (files = cutDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    @Deprecated
    public static void deleteAllCacheDirFile(Context context) {
        File[] files;
        File dirMusic;
        File[] files2;
        File dirMovies;
        File[] files3;
        File dirPictures = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (dirPictures != null && (files3 = dirPictures.listFiles()) != null) {
            for (File file : files3) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if ((dirMovies = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES)) != null && (files2 = dirMovies.listFiles()) != null) {
            for (File file : files2) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        if ((dirMusic = context.getExternalFilesDir(Environment.DIRECTORY_MUSIC)) != null && (files = dirMusic.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public static String getDiskCacheDir(Context ctx) {
        File filesDir = ctx.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (filesDir == null) {
            return "";
        }
        return filesDir.getPath();
    }

    public static String getVideoDiskCacheDir(Context ctx) {
        File filesDir = ctx.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
        if (filesDir == null) {
            return "";
        }
        return filesDir.getPath();
    }

    public static String getAudioDiskCacheDir(Context ctx) {
        File filesDir = ctx.getExternalFilesDir(Environment.DIRECTORY_MUSIC);
        if (filesDir == null) {
            return "";
        }
        return filesDir.getPath();
    }

    public static Uri parUri(Context context, File cameraFile) {
        String authority = context.getPackageName() + ".luckProvider";
        Uri imageUri = Build.VERSION.SDK_INT > 23 ? FileProvider.getUriForFile((Context)context, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
        return imageUri;
    }

    public static String createFilePath(Context context, String md5, String mineType, String customFileName) {
        String suffix = PictureMimeType.getLastImgSuffix(mineType);
        if (PictureMimeType.isHasVideo(mineType)) {
            String filesDir = PictureFileUtils.getVideoDiskCacheDir(context) + File.separator;
            if (TextUtils.isEmpty((CharSequence)md5)) {
                String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("VID_") + suffix : customFileName;
                return filesDir + fileName;
            }
            String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? "VID_" + md5.toUpperCase() + suffix : customFileName;
            return filesDir + fileName;
        }
        if (PictureMimeType.isHasAudio(mineType)) {
            String filesDir = PictureFileUtils.getAudioDiskCacheDir(context) + File.separator;
            if (TextUtils.isEmpty((CharSequence)md5)) {
                String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("AUD_") + suffix : customFileName;
                return filesDir + fileName;
            }
            String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? "AUD_" + md5.toUpperCase() + suffix : customFileName;
            return filesDir + fileName;
        }
        String filesDir = PictureFileUtils.getDiskCacheDir(context) + File.separator;
        if (TextUtils.isEmpty((CharSequence)md5)) {
            String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("IMG_") + suffix : customFileName;
            return filesDir + fileName;
        }
        String fileName = TextUtils.isEmpty((CharSequence)customFileName) ? "IMG_" + md5.toUpperCase() + suffix : customFileName;
        return filesDir + fileName;
    }

    public static boolean isFileExists(String path) {
        return TextUtils.isEmpty((CharSequence)path) || new File(path).exists();
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String formatFileSize(long byteSize, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision shouldn't be less than zero!");
        }
        if (byteSize < 0L) {
            throw new IllegalArgumentException("byteSize shouldn't be less than zero!");
        }
        if (byteSize < 1024L) {
            return String.format("%." + precision + "fB", byteSize);
        }
        if (byteSize < 0x100000L) {
            return String.format("%." + precision + "fKB", (double)byteSize / 1024.0);
        }
        if (byteSize < 0x40000000L) {
            return String.format("%." + precision + "fMB", (double)byteSize / 1048576.0);
        }
        return String.format("%." + precision + "fGB", (double)byteSize / 1.073741824E9);
    }

    public static void close(@Nullable Closeable c) {
        if (c instanceof Closeable) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

