/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.util;

import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;

public class SelectedStateListDrawable
extends StateListDrawable {
    private final int mSelectionColor;

    public SelectedStateListDrawable(Drawable drawable2, int selectionColor) {
        this.mSelectionColor = selectionColor;
        this.addState(new int[]{0x10100A1}, drawable2);
        this.addState(new int[0], drawable2);
    }

    protected boolean onStateChange(int[] states) {
        boolean isStatePressedInArray = false;
        for (int state : states) {
            if (state != 0x10100A1) continue;
            isStatePressedInArray = true;
        }
        if (isStatePressedInArray) {
            ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)this.mSelectionColor, (BlendModeCompat)BlendModeCompat.SRC_ATOP);
            super.setColorFilter(colorFilter);
        } else {
            super.clearColorFilter();
        }
        return super.onStateChange(states);
    }

    public boolean isStateful() {
        return true;
    }
}

