/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.view.CameraController;
import androidx.camera.view.LifecycleCameraController;
import androidx.camera.view.PreviewView;
import androidx.camera.view.video.OnVideoSavedCallback;
import androidx.camera.view.video.OutputFileOptions;
import androidx.camera.view.video.OutputFileResults;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.R;
import com.luck.picture.lib.camera.listener.CameraListener;
import com.luck.picture.lib.camera.listener.CaptureListener;
import com.luck.picture.lib.camera.listener.ClickListener;
import com.luck.picture.lib.camera.listener.ImageCallbackListener;
import com.luck.picture.lib.camera.listener.TypeListener;
import com.luck.picture.lib.camera.view.CaptureLayout;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class CustomCameraView
extends RelativeLayout {
    public static final int DEFAULT_MIN_RECORD_VIDEO = 1500;
    public static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    public static final int BUTTON_STATE_ONLY_RECORDER = 258;
    public static final int BUTTON_STATE_BOTH = 259;
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int type_flash = 35;
    private PictureSelectionConfig mConfig;
    private PreviewView mCameraPreviewView;
    private LifecycleCameraController mCameraController;
    private CameraListener mCameraListener;
    private ClickListener mOnClickListener;
    private ImageCallbackListener mImageCallbackListener;
    private ImageView mImagePreview;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private CaptureLayout mCaptureLayout;
    private MediaPlayer mMediaPlayer;
    private TextureView mTextureView;
    private long recordTime = 0L;
    private File mOutMediaFile;
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            CustomCameraView.this.startVideoPlay(CustomCameraView.this.mOutMediaFile);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };

    public CustomCameraView(Context context) {
        super(context);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void initView() {
        CustomCameraView.inflate((Context)this.getContext(), (int)R.layout.picture_camera_view, (ViewGroup)this);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_black));
        this.mCameraPreviewView = (PreviewView)this.findViewById(R.id.cameraPreviewView);
        this.mTextureView = (TextureView)this.findViewById(R.id.video_play_preview);
        this.mImagePreview = (ImageView)this.findViewById(R.id.image_preview);
        this.mSwitchCamera = (ImageView)this.findViewById(R.id.image_switch);
        this.mFlashLamp = (ImageView)this.findViewById(R.id.image_flash);
        this.mCaptureLayout = (CaptureLayout)this.findViewById(R.id.capture_layout);
        this.mSwitchCamera.setImageResource(R.drawable.picture_ic_camera);
        this.mFlashLamp.setOnClickListener(v -> {
            ++this.type_flash;
            if (this.type_flash > 35) {
                this.type_flash = 33;
            }
            this.setFlashRes();
        });
        this.mCaptureLayout.setDuration(15000);
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCameraView.this.toggleCamera();
            }
        });
        this.mCaptureLayout.setCaptureListener(new CaptureListener(){

            @Override
            public void takePictures() {
                CustomCameraView.this.mOutMediaFile = CustomCameraView.this.createImageFile();
                CustomCameraView.this.mCaptureLayout.setButtonCaptureEnabled(false);
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                CustomCameraView.this.mCameraController.setEnabledUseCases(1);
                ImageCapture.OutputFileOptions fileOptions = new ImageCapture.OutputFileOptions.Builder(CustomCameraView.this.mOutMediaFile).build();
                CustomCameraView.this.mCameraController.takePicture(fileOptions, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), (ImageCapture.OnImageSavedCallback)new MyImageResultCallback(CustomCameraView.this.mOutMediaFile, CustomCameraView.this.mImagePreview, CustomCameraView.this.mCaptureLayout, CustomCameraView.this.mImageCallbackListener, CustomCameraView.this.mCameraListener));
            }

            @Override
            @SuppressLint(value={"UnsafeOptInUsageError"})
            public void recordStart() {
                CustomCameraView.this.mOutMediaFile = CustomCameraView.this.createVideoFile();
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                CustomCameraView.this.mCameraController.setEnabledUseCases(4);
                OutputFileOptions fileOptions = OutputFileOptions.builder((File)CustomCameraView.this.mOutMediaFile).build();
                CustomCameraView.this.mCameraController.startRecording(fileOptions, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), new OnVideoSavedCallback(){

                    public void onVideoSaved(@NonNull OutputFileResults outputFileResults) {
                        long minSecond;
                        long l = minSecond = ((CustomCameraView)CustomCameraView.this).mConfig.recordVideoMinSecond <= 0 ? 1500L : (long)(((CustomCameraView)CustomCameraView.this).mConfig.recordVideoMinSecond * 1000);
                        if (CustomCameraView.this.recordTime < minSecond && CustomCameraView.this.mOutMediaFile.exists() && CustomCameraView.this.mOutMediaFile.delete()) {
                            return;
                        }
                        CustomCameraView.this.mTextureView.setVisibility(0);
                        CustomCameraView.this.mCameraPreviewView.setVisibility(4);
                        if (CustomCameraView.this.mTextureView.isAvailable()) {
                            CustomCameraView.this.startVideoPlay(CustomCameraView.this.mOutMediaFile);
                        } else {
                            CustomCameraView.this.mTextureView.setSurfaceTextureListener(CustomCameraView.this.surfaceTextureListener);
                        }
                    }

                    public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                        if (CustomCameraView.this.mCameraListener != null) {
                            CustomCameraView.this.mCameraListener.onError(videoCaptureError, message, cause);
                        }
                    }
                });
            }

            @Override
            @SuppressLint(value={"UnsafeOptInUsageError"})
            public void recordShort(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mSwitchCamera.setVisibility(0);
                CustomCameraView.this.mFlashLamp.setVisibility(0);
                CustomCameraView.this.mCaptureLayout.resetCaptureLayout();
                CustomCameraView.this.mCaptureLayout.setTextWithAnimation(CustomCameraView.this.getContext().getString(R.string.picture_recording_time_is_short));
                CustomCameraView.this.mCameraController.stopRecording();
            }

            @Override
            @SuppressLint(value={"UnsafeOptInUsageError"})
            public void recordEnd(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mCameraController.stopRecording();
            }

            @Override
            public void recordZoom(float zoom) {
            }

            @Override
            public void recordError() {
                if (CustomCameraView.this.mCameraListener != null) {
                    CustomCameraView.this.mCameraListener.onError(0, "An unknown error", null);
                }
            }
        });
        this.mCaptureLayout.setTypeListener(new TypeListener(){

            @Override
            public void cancel() {
                CustomCameraView.this.stopVideoPlay();
                CustomCameraView.this.resetState();
            }

            @Override
            public void confirm() {
                if (CustomCameraView.this.mOutMediaFile == null || !CustomCameraView.this.mOutMediaFile.exists()) {
                    return;
                }
                if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(((CustomCameraView)CustomCameraView.this).mConfig.cameraPath)) {
                    PictureThreadUtils.executeBySingle(new PictureThreadUtils.SimpleTask<Boolean>(){

                        @Override
                        public Boolean doInBackground() {
                            return AndroidQTransformUtils.copyPathToDCIM(CustomCameraView.this.getContext(), CustomCameraView.this.mOutMediaFile, Uri.parse((String)((CustomCameraView)CustomCameraView.this).mConfig.cameraPath));
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                            if (CustomCameraView.this.mCameraController.isImageCaptureEnabled()) {
                                CustomCameraView.this.mImagePreview.setVisibility(4);
                                if (CustomCameraView.this.mCameraListener != null) {
                                    CustomCameraView.this.mCameraListener.onPictureSuccess(CustomCameraView.this.mOutMediaFile);
                                }
                            } else {
                                CustomCameraView.this.stopVideoPlay();
                                if (CustomCameraView.this.mCameraListener != null || !CustomCameraView.this.mOutMediaFile.exists()) {
                                    CustomCameraView.this.mCameraListener.onRecordSuccess(CustomCameraView.this.mOutMediaFile);
                                }
                            }
                        }
                    });
                } else if (CustomCameraView.this.mCameraController.isImageCaptureEnabled()) {
                    CustomCameraView.this.mImagePreview.setVisibility(4);
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onPictureSuccess(CustomCameraView.this.mOutMediaFile);
                    }
                } else {
                    CustomCameraView.this.stopVideoPlay();
                    if (CustomCameraView.this.mCameraListener != null || !CustomCameraView.this.mOutMediaFile.exists()) {
                        CustomCameraView.this.mCameraListener.onRecordSuccess(CustomCameraView.this.mOutMediaFile);
                    }
                }
            }
        });
        this.mCaptureLayout.setLeftClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (CustomCameraView.this.mOnClickListener != null) {
                    CustomCameraView.this.mOnClickListener.onClick();
                }
            }
        });
    }

    public void initCamera(PictureSelectionConfig config) {
        this.mConfig = config;
        if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") == 0) {
            this.mCameraController = new LifecycleCameraController(this.getContext());
            this.mCameraController.bindToLifecycle((LifecycleOwner)this.getContext());
            this.mCameraController.setCameraSelector(this.mConfig.isCameraAroundState ? CameraSelector.DEFAULT_FRONT_CAMERA : CameraSelector.DEFAULT_BACK_CAMERA);
            this.mCameraPreviewView.setController((CameraController)this.mCameraController);
        }
        this.setFlashRes();
    }

    public File createImageFile() {
        if (SdkVersionUtils.checkedAndroid_Q()) {
            String diskCacheDir = PictureFileUtils.getDiskCacheDir(this.getContext());
            File rootDir = new File(diskCacheDir);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
            boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName);
            String imageFormat = TextUtils.isEmpty((CharSequence)this.mConfig.cameraImageFormat) ? (this.mConfig.suffixType.startsWith("image/") ? this.mConfig.suffixType.replaceAll("image/", ".") : ".jpg") : (this.mConfig.cameraImageFormat.startsWith("image/") ? this.mConfig.cameraImageFormat.replaceAll("image/", ".") : this.mConfig.cameraImageFormat);
            String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("IMG_") + imageFormat : this.mConfig.cameraFileName;
            File cameraFile = new File(rootDir, newFileImageName);
            Uri outUri = this.getOutUri(PictureMimeType.ofImage());
            if (outUri != null) {
                this.mConfig.cameraPath = outUri.toString();
            }
            return cameraFile;
        }
        String cameraFileName = "";
        if (!TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName)) {
            boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.mConfig.cameraFileName);
            this.mConfig.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(this.mConfig.cameraFileName, ".jpg") : this.mConfig.cameraFileName;
            cameraFileName = this.mConfig.camera ? this.mConfig.cameraFileName : StringUtils.rename(this.mConfig.cameraFileName);
        }
        String imageFormat = TextUtils.isEmpty((CharSequence)this.mConfig.cameraImageFormat) ? this.mConfig.suffixType : this.mConfig.cameraImageFormat;
        File cameraFile = PictureFileUtils.createCameraFile(this.getContext(), PictureMimeType.ofImage(), cameraFileName, imageFormat, this.mConfig.outPutCameraPath);
        this.mConfig.cameraPath = cameraFile.getAbsolutePath();
        return cameraFile;
    }

    public File createVideoFile() {
        if (SdkVersionUtils.checkedAndroid_Q()) {
            String diskCacheDir = PictureFileUtils.getVideoDiskCacheDir(this.getContext());
            File rootDir = new File(diskCacheDir);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
            boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName);
            String imageFormat = TextUtils.isEmpty((CharSequence)this.mConfig.cameraVideoFormat) ? (this.mConfig.suffixType.startsWith("video/") ? this.mConfig.suffixType.replaceAll("video/", ".") : ".mp4") : (this.mConfig.cameraVideoFormat.startsWith("video/") ? this.mConfig.cameraVideoFormat.replaceAll("video/", ".") : this.mConfig.cameraVideoFormat);
            String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("VID_") + imageFormat : this.mConfig.cameraFileName;
            File cameraFile = new File(rootDir, newFileImageName);
            Uri outUri = this.getOutUri(PictureMimeType.ofVideo());
            if (outUri != null) {
                this.mConfig.cameraPath = outUri.toString();
            }
            return cameraFile;
        }
        String cameraFileName = "";
        if (!TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName)) {
            boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.mConfig.cameraFileName);
            this.mConfig.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(this.mConfig.cameraFileName, ".mp4") : this.mConfig.cameraFileName;
            cameraFileName = this.mConfig.camera ? this.mConfig.cameraFileName : StringUtils.rename(this.mConfig.cameraFileName);
        }
        String videoFormat = TextUtils.isEmpty((CharSequence)this.mConfig.cameraVideoFormat) ? this.mConfig.suffixType : this.mConfig.cameraVideoFormat;
        File cameraFile = PictureFileUtils.createCameraFile(this.getContext(), PictureMimeType.ofVideo(), cameraFileName, videoFormat, this.mConfig.outPutCameraPath);
        this.mConfig.cameraPath = cameraFile.getAbsolutePath();
        return cameraFile;
    }

    private Uri getOutUri(int type) {
        boolean isHasVideo;
        boolean bl = isHasVideo = type == PictureMimeType.ofVideo();
        if (isHasVideo) {
            return MediaUtils.createVideoUri(this.getContext(), this.mConfig.cameraFileName, TextUtils.isEmpty((CharSequence)this.mConfig.cameraVideoFormat) ? this.mConfig.suffixType : this.mConfig.cameraVideoFormat);
        }
        return MediaUtils.createImageUri(this.getContext(), this.mConfig.cameraFileName, TextUtils.isEmpty((CharSequence)this.mConfig.cameraImageFormat) ? this.mConfig.suffixType : this.mConfig.cameraImageFormat);
    }

    public void setCameraListener(CameraListener cameraListener) {
        this.mCameraListener = cameraListener;
    }

    public void setRecordVideoMaxTime(int maxDurationTime) {
        this.mCaptureLayout.setDuration(maxDurationTime * 1000);
    }

    public void setRecordVideoMinTime(int minDurationTime) {
        this.mCaptureLayout.setMinDuration(minDurationTime * 1000);
    }

    public void setCaptureLoadingColor(int color2) {
        this.mCaptureLayout.setCaptureLoadingColor(color2);
    }

    public void toggleCamera() {
        if (this.mCameraController.getCameraSelector() == CameraSelector.DEFAULT_BACK_CAMERA && this.mCameraController.hasCamera(CameraSelector.DEFAULT_FRONT_CAMERA)) {
            this.mCameraController.setCameraSelector(CameraSelector.DEFAULT_FRONT_CAMERA);
        } else if (this.mCameraController.getCameraSelector() == CameraSelector.DEFAULT_FRONT_CAMERA && this.mCameraController.hasCamera(CameraSelector.DEFAULT_BACK_CAMERA)) {
            this.mCameraController.setCameraSelector(CameraSelector.DEFAULT_BACK_CAMERA);
        }
    }

    public void setOnClickListener(ClickListener clickListener) {
        this.mOnClickListener = clickListener;
    }

    public void setImageCallbackListener(ImageCallbackListener mImageCallbackListener) {
        this.mImageCallbackListener = mImageCallbackListener;
    }

    private void setFlashRes() {
        switch (this.type_flash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_auto);
                this.mCameraController.setImageCaptureFlashMode(0);
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_on);
                this.mCameraController.setImageCaptureFlashMode(1);
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_off);
                this.mCameraController.setImageCaptureFlashMode(2);
            }
        }
    }

    public CaptureLayout getCaptureLayout() {
        return this.mCaptureLayout;
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    private void resetState() {
        if (this.mCameraController.isImageCaptureEnabled()) {
            this.mImagePreview.setVisibility(4);
        } else if (this.mCameraController.isRecording()) {
            this.mCameraController.stopRecording();
        }
        if (this.mOutMediaFile != null && this.mOutMediaFile.exists()) {
            this.mOutMediaFile.delete();
            if (SdkVersionUtils.checkedAndroid_Q()) {
                MediaUtils.deleteCamera(this.getContext(), this.mConfig.cameraPath);
            } else {
                new PictureMediaScannerConnection(this.getContext(), this.mOutMediaFile.getAbsolutePath());
            }
        }
        this.mSwitchCamera.setVisibility(0);
        this.mFlashLamp.setVisibility(0);
        this.mCameraPreviewView.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    private void startVideoPlay(File videoFile) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            }
            this.mMediaPlayer.setDataSource(videoFile.getAbsolutePath());
            this.mMediaPlayer.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.setOnPreparedListener(mp -> {
                mp.start();
                float ratio = (float)mp.getVideoWidth() * 1.0f / (float)mp.getVideoHeight();
                int width1 = this.mTextureView.getWidth();
                ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
                layoutParams.height = (int)((float)width1 / ratio);
                this.mTextureView.setLayoutParams(layoutParams);
            });
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopVideoPlay() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mTextureView.setVisibility(8);
    }

    public void unbindCameraController() {
        if (this.mCameraController != null) {
            this.mCameraController.unbind();
        }
    }

    private static class MyImageResultCallback
    implements ImageCapture.OnImageSavedCallback {
        private final WeakReference<File> mFileReference;
        private final WeakReference<ImageView> mImagePreviewReference;
        private final WeakReference<CaptureLayout> mCaptureLayoutReference;
        private final WeakReference<ImageCallbackListener> mImageCallbackListenerReference;
        private final WeakReference<CameraListener> mCameraListenerReference;

        public MyImageResultCallback(File imageOutFile, ImageView imagePreview, CaptureLayout captureLayout, ImageCallbackListener imageCallbackListener, CameraListener cameraListener) {
            this.mFileReference = new WeakReference<File>(imageOutFile);
            this.mImagePreviewReference = new WeakReference<ImageView>(imagePreview);
            this.mCaptureLayoutReference = new WeakReference<CaptureLayout>(captureLayout);
            this.mImageCallbackListenerReference = new WeakReference<ImageCallbackListener>(imageCallbackListener);
            this.mCameraListenerReference = new WeakReference<CameraListener>(cameraListener);
        }

        public void onImageSaved(@NonNull ImageCapture.OutputFileResults outputFileResults) {
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).setButtonCaptureEnabled(true);
            }
            if (this.mImageCallbackListenerReference.get() != null && this.mFileReference.get() != null && this.mImagePreviewReference.get() != null) {
                ((ImageCallbackListener)this.mImageCallbackListenerReference.get()).onLoadImage((File)this.mFileReference.get(), (ImageView)this.mImagePreviewReference.get());
            }
            if (this.mImagePreviewReference.get() != null) {
                ((ImageView)this.mImagePreviewReference.get()).setVisibility(0);
            }
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).startTypeBtnAnimator();
            }
        }

        public void onError(@NonNull ImageCaptureException exception) {
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).setButtonCaptureEnabled(true);
            }
            if (this.mCameraListenerReference.get() != null) {
                ((CameraListener)this.mCameraListenerReference.get()).onError(exception.getImageCaptureError(), exception.getMessage(), exception.getCause());
            }
        }
    }
}

