/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import androidx.core.content.ContextCompat;

public class AttrsUtils {
    public static float getTypeValueSize(Context context, int attr2) {
        float textSize = 0.0f;
        try {
            TypedValue typedValue = new TypedValue();
            int[] attribute = new int[]{attr2};
            TypedArray array = context.obtainStyledAttributes(typedValue.resourceId, attribute);
            textSize = array.getDimensionPixelSize(0, 0);
            array.recycle();
            return textSize;
        }
        catch (Exception e) {
            e.printStackTrace();
            return textSize;
        }
    }

    public static int getTypeValueSizeForInt(Context context, int attr2) {
        int textSize = 0;
        try {
            TypedValue typedValue = new TypedValue();
            int[] attribute = new int[]{attr2};
            TypedArray array = context.obtainStyledAttributes(typedValue.resourceId, attribute);
            textSize = array.getDimensionPixelSize(0, 0);
            array.recycle();
            return textSize;
        }
        catch (Exception e) {
            e.printStackTrace();
            return textSize;
        }
    }

    public static int getTypeValueColor(Context context, int attr2) {
        int color2 = 0;
        try {
            TypedValue typedValue = new TypedValue();
            int[] attribute = new int[]{attr2};
            TypedArray array = context.obtainStyledAttributes(typedValue.resourceId, attribute);
            color2 = array.getColor(0, 0);
            array.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return color2;
    }

    public static ColorStateList getTypeValueColorStateList(Context context, int attr2) {
        ColorStateList colorStateList = null;
        try {
            TypedValue typedValue = new TypedValue();
            int[] attribute = new int[]{attr2};
            TypedArray array = context.obtainStyledAttributes(typedValue.resourceId, attribute);
            colorStateList = array.getColorStateList(0);
            array.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colorStateList;
    }

    public static boolean getTypeValueBoolean(Context context, int attr2) {
        boolean flag = false;
        try {
            TypedValue typedValue = new TypedValue();
            int[] attribute = new int[]{attr2};
            TypedArray array = context.obtainStyledAttributes(typedValue.resourceId, attribute);
            flag = array.getBoolean(0, false);
            array.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static Drawable getTypeValueDrawable(Context context, int attr2, int defaultResId) {
        Drawable drawable2 = null;
        try {
            TypedValue typedValue = new TypedValue();
            int[] attribute = new int[]{attr2};
            TypedArray array = context.obtainStyledAttributes(typedValue.resourceId, attribute);
            drawable2 = array.getDrawable(0);
            array.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return drawable2 == null ? ContextCompat.getDrawable((Context)context, (int)defaultResId) : drawable2;
    }

    public static ColorStateList getColorStateList(int[] colors) {
        try {
            if (colors.length == 2) {
                int[][] states = new int[][]{{-16842913}, {0x10100A1}};
                return new ColorStateList((int[][])states, colors);
            }
            return ColorStateList.valueOf((int)colors[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

