/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.PictureExternalPreviewActivity;
import com.luck.picture.lib.PicturePlayAudioActivity;
import com.luck.picture.lib.PictureSelectionModel;
import com.luck.picture.lib.PictureVideoPlayActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.style.PictureParameterStyle;
import com.luck.picture.lib.tools.DoubleUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public final class PictureSelector {
    private final WeakReference<Activity> mActivity;
    private final WeakReference<Fragment> mFragment;

    private PictureSelector(Activity activity) {
        this(activity, null);
    }

    private PictureSelector(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    private PictureSelector(Activity activity, Fragment fragment) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.mFragment = new WeakReference<Fragment>(fragment);
    }

    public static PictureSelector create(Activity activity) {
        return new PictureSelector(activity);
    }

    public static PictureSelector create(Fragment fragment) {
        return new PictureSelector(fragment);
    }

    public PictureSelectionModel openGallery(int chooseMode) {
        return new PictureSelectionModel(this, chooseMode);
    }

    public PictureSelectionModel openCamera(int chooseMode) {
        return new PictureSelectionModel(this, chooseMode, true);
    }

    public PictureSelectionModel themeStyle(int themeStyle) {
        return new PictureSelectionModel(this, PictureMimeType.ofImage()).theme(themeStyle);
    }

    public PictureSelectionModel setPictureStyle(PictureParameterStyle style2) {
        return new PictureSelectionModel(this, PictureMimeType.ofImage()).setPictureStyle(style2);
    }

    public static List<LocalMedia> obtainMultipleResult(Intent data) {
        if (data != null) {
            ArrayList result = data.getParcelableArrayListExtra("extra_result_media");
            return result == null ? new ArrayList() : result;
        }
        return new ArrayList<LocalMedia>();
    }

    public static Intent putIntentResult(List<LocalMedia> data) {
        return new Intent().putParcelableArrayListExtra("extra_result_media", (ArrayList)data);
    }

    public static List<LocalMedia> obtainSelectorList(Bundle bundle) {
        if (bundle != null) {
            return bundle.getParcelableArrayList("selectList");
        }
        return null;
    }

    public static void saveSelectorList(Bundle outState, List<LocalMedia> selectedImages) {
        outState.putParcelableArrayList("selectList", (ArrayList)selectedImages);
    }

    public void externalPicturePreview(int position, List<LocalMedia> medias, int enterAnimation) {
        if (!DoubleUtils.isFastDoubleClick()) {
            if (this.getActivity() != null) {
                Intent intent = new Intent((Context)this.getActivity(), PictureExternalPreviewActivity.class);
                intent.putParcelableArrayListExtra("previewSelectList", (ArrayList)medias);
                intent.putExtra("position", position);
                this.getActivity().startActivity(intent);
                this.getActivity().overridePendingTransition(enterAnimation != 0 ? enterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
            } else {
                throw new NullPointerException("Starting the PictureSelector Activity cannot be empty ");
            }
        }
    }

    public void externalPicturePreview(int position, String directory_path, List<LocalMedia> medias, int enterAnimation) {
        if (!DoubleUtils.isFastDoubleClick()) {
            if (this.getActivity() != null) {
                Intent intent = new Intent((Context)this.getActivity(), PictureExternalPreviewActivity.class);
                intent.putParcelableArrayListExtra("previewSelectList", (ArrayList)medias);
                intent.putExtra("position", position);
                intent.putExtra("directory_path", directory_path);
                this.getActivity().startActivity(intent);
                this.getActivity().overridePendingTransition(enterAnimation != 0 ? enterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
            } else {
                throw new NullPointerException("Starting the PictureSelector Activity cannot be empty ");
            }
        }
    }

    public void externalPictureVideo(String path) {
        if (!DoubleUtils.isFastDoubleClick()) {
            if (this.getActivity() != null) {
                Intent intent = new Intent((Context)this.getActivity(), PictureVideoPlayActivity.class);
                intent.putExtra("videoPath", path);
                intent.putExtra("isExternalPreviewVideo", true);
                this.getActivity().startActivity(intent);
            } else {
                throw new NullPointerException("Starting the PictureSelector Activity cannot be empty ");
            }
        }
    }

    public void externalPictureAudio(String path) {
        if (!DoubleUtils.isFastDoubleClick()) {
            if (this.getActivity() != null) {
                Intent intent = new Intent((Context)this.getActivity(), PicturePlayAudioActivity.class);
                intent.putExtra("audioPath", path);
                this.getActivity().startActivity(intent);
                this.getActivity().overridePendingTransition(R.anim.picture_anim_enter, 0);
            } else {
                throw new NullPointerException("Starting the PictureSelector Activity cannot be empty ");
            }
        }
    }

    @Nullable
    Activity getActivity() {
        return (Activity)this.mActivity.get();
    }

    @Nullable
    Fragment getFragment() {
        return this.mFragment != null ? (Fragment)this.mFragment.get() : null;
    }
}

