/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureSimpleFragmentAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.manager.UCropManager;
import com.luck.picture.lib.model.LocalMediaPageLoader;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.tools.VoiceUtils;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PicturePreviewActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureSimpleFragmentAdapter.OnCallBackActivity {
    private static final String TAG = PicturePreviewActivity.class.getSimpleName();
    protected ViewGroup mTitleBar;
    protected ImageView pictureLeftBack;
    protected TextView mTvPictureRight;
    protected TextView tvMediaNum;
    protected TextView tvTitle;
    protected TextView mTvPictureOk;
    protected ImageView mIvArrow;
    protected PreviewViewPager viewPager;
    protected View mPicturePreview;
    protected int position;
    protected boolean isBottomPreview;
    private int totalNumber;
    protected List<LocalMedia> selectData = new ArrayList<LocalMedia>();
    protected PictureSimpleFragmentAdapter adapter;
    protected Animation animation;
    protected TextView check;
    protected View btnCheck;
    protected boolean refresh;
    protected int index;
    protected int screenWidth;
    protected Handler mHandler;
    protected RelativeLayout selectBarLayout;
    protected CheckBox mCbOriginal;
    protected boolean isShowCamera;
    protected String currentDirectory;
    protected boolean isCompleteOrSelected;
    protected boolean isChangeSelectedData;
    private int mPage = 0;

    @Override
    public int getResourceId() {
        return R.layout.picture_preview;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            List<LocalMedia> cacheData = PictureSelector.obtainSelectorList(savedInstanceState);
            this.selectData = cacheData != null ? cacheData : this.selectData;
            this.isCompleteOrSelected = savedInstanceState.getBoolean("isCompleteOrSelected", false);
            this.isChangeSelectedData = savedInstanceState.getBoolean("isChangeSelectedData", false);
            this.onImageChecked(this.position);
            this.onSelectNumChange(false);
        }
    }

    @Override
    protected void initWidgets() {
        ArrayList<LocalMedia> data;
        super.initWidgets();
        this.mHandler = new Handler(this.getMainLooper());
        this.mTitleBar = (ViewGroup)this.findViewById(R.id.titleBar);
        this.screenWidth = ScreenUtils.getScreenWidth((Context)this);
        this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
        this.pictureLeftBack = (ImageView)this.findViewById(R.id.pictureLeftBack);
        this.mTvPictureRight = (TextView)this.findViewById(R.id.picture_right);
        this.mIvArrow = (ImageView)this.findViewById(R.id.ivArrow);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.mPicturePreview = this.findViewById(R.id.picture_id_preview);
        this.btnCheck = this.findViewById(R.id.btnCheck);
        this.check = (TextView)this.findViewById(R.id.check);
        this.pictureLeftBack.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.picture_tv_ok);
        this.mCbOriginal = (CheckBox)this.findViewById(R.id.cb_original);
        this.tvMediaNum = (TextView)this.findViewById(R.id.tv_media_num);
        this.selectBarLayout = (RelativeLayout)this.findViewById(R.id.select_bar_layout);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.tvMediaNum.setOnClickListener((View.OnClickListener)this);
        this.tvTitle = (TextView)this.findViewById(R.id.picture_title);
        this.mPicturePreview.setVisibility(8);
        this.mIvArrow.setVisibility(8);
        this.mTvPictureRight.setVisibility(8);
        this.check.setVisibility(0);
        this.btnCheck.setVisibility(0);
        this.position = this.getIntent().getIntExtra("position", 0);
        if (this.numComplete) {
            this.initCompleteText(0);
        }
        this.tvMediaNum.setSelected(this.config.checkNumMode);
        this.btnCheck.setOnClickListener((View.OnClickListener)this);
        if (this.getIntent().getParcelableArrayListExtra("selectList") != null) {
            this.selectData = this.getIntent().getParcelableArrayListExtra("selectList");
        }
        this.isBottomPreview = this.getIntent().getBooleanExtra("bottom_preview", false);
        this.isShowCamera = this.getIntent().getBooleanExtra("isShowCamera", this.config.isCamera);
        this.currentDirectory = this.getIntent().getStringExtra("currentDirectory");
        if (this.isBottomPreview) {
            data = this.getIntent().getParcelableArrayListExtra("previewSelectList");
            this.initViewPageAdapterData(data);
        } else {
            data = new ArrayList<LocalMedia>(ImagesObservable.getInstance().readPreviewMediaData());
            boolean isEmpty = data.size() == 0;
            this.totalNumber = this.getIntent().getIntExtra("count", 0);
            if (this.config.isPageStrategy) {
                if (isEmpty) {
                    this.setNewTitle();
                } else {
                    this.mPage = this.getIntent().getIntExtra("page", 0);
                }
                this.initViewPageAdapterData(data);
                this.loadData();
                this.setTitle();
            } else {
                this.initViewPageAdapterData(data);
                if (isEmpty) {
                    this.config.isPageStrategy = true;
                    this.setNewTitle();
                    this.loadData();
                }
            }
        }
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                PicturePreviewActivity.this.isPreviewEggs(PicturePreviewActivity.this.config.previewEggs, position, positionOffsetPixels);
            }

            public void onPageSelected(int i) {
                PicturePreviewActivity.this.position = i;
                PicturePreviewActivity.this.setTitle();
                LocalMedia media = PicturePreviewActivity.this.adapter.getItem(PicturePreviewActivity.this.position);
                if (media == null) {
                    return;
                }
                PicturePreviewActivity.this.index = media.getPosition();
                if (!PicturePreviewActivity.this.config.previewEggs) {
                    if (PicturePreviewActivity.this.config.checkNumMode) {
                        PicturePreviewActivity.this.check.setText((CharSequence)ValueOf.toString(media.getNum()));
                        PicturePreviewActivity.this.notifyCheckChanged(media);
                    }
                    PicturePreviewActivity.this.onImageChecked(PicturePreviewActivity.this.position);
                }
                if (PicturePreviewActivity.this.config.isOriginalControl) {
                    boolean isHasVideo = PictureMimeType.isHasVideo(media.getMimeType());
                    PicturePreviewActivity.this.mCbOriginal.setVisibility(isHasVideo ? 8 : 0);
                    PicturePreviewActivity.this.mCbOriginal.setChecked(PicturePreviewActivity.this.config.isCheckOriginalImage);
                }
                PicturePreviewActivity.this.onPageSelectedChange(media);
                if (PicturePreviewActivity.this.config.isPageStrategy && !PicturePreviewActivity.this.isBottomPreview && PicturePreviewActivity.this.isHasMore && (PicturePreviewActivity.this.position == PicturePreviewActivity.this.adapter.getSize() - 1 - 10 || PicturePreviewActivity.this.position == PicturePreviewActivity.this.adapter.getSize() - 1)) {
                    PicturePreviewActivity.this.loadMoreData();
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        if (this.config.isOriginalControl) {
            boolean isCheckOriginal = this.getIntent().getBooleanExtra("isOriginal", this.config.isCheckOriginalImage);
            this.mCbOriginal.setVisibility(0);
            this.config.isCheckOriginalImage = isCheckOriginal;
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
            this.mCbOriginal.setOnCheckedChangeListener((buttonView, isChecked) -> {
                this.config.isCheckOriginalImage = isChecked;
                if (this.selectData.size() == 0 && isChecked) {
                    this.onCheckedComplete();
                }
            });
        }
    }

    private void loadData() {
        long bucketId = this.getIntent().getLongExtra("bucket_id", -1L);
        ++this.mPage;
        LocalMediaPageLoader.getInstance(this.getContext()).loadPageMediaData(bucketId, this.mPage, this.config.pageSize, (result, currentPage, isHasMore) -> {
            if (!this.isFinishing()) {
                this.isHasMore = isHasMore;
                if (isHasMore) {
                    int size = result.size();
                    if (size > 0 && this.adapter != null) {
                        this.adapter.getData().addAll(result);
                        this.adapter.notifyDataSetChanged();
                    } else {
                        this.loadMoreData();
                    }
                }
            }
        });
    }

    private void loadMoreData() {
        long bucketId = this.getIntent().getLongExtra("bucket_id", -1L);
        ++this.mPage;
        LocalMediaPageLoader.getInstance(this.getContext()).loadPageMediaData(bucketId, this.mPage, this.config.pageSize, (result, currentPage, isHasMore) -> {
            if (!this.isFinishing()) {
                this.isHasMore = isHasMore;
                if (isHasMore) {
                    int size = result.size();
                    if (size > 0 && this.adapter != null) {
                        this.adapter.getData().addAll(result);
                        this.adapter.notifyDataSetChanged();
                    } else {
                        this.loadMoreData();
                    }
                }
            }
        });
    }

    @Override
    protected void initCompleteText(int startCount) {
        if (this.config.selectionMode == 1) {
            if (startCount <= 0) {
                if (PictureSelectionConfig.uiStyle != null) {
                    this.mTvPictureOk.setText((CharSequence)(PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText != 0 ? this.getString(PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText) : this.getString(R.string.picture_please_select)));
                } else if (PictureSelectionConfig.style != null) {
                    this.mTvPictureOk.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_please_select)));
                }
            } else if (PictureSelectionConfig.uiStyle != null) {
                if (PictureSelectionConfig.uiStyle.isCompleteReplaceNum && PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText != 0) {
                    this.mTvPictureOk.setText((CharSequence)String.format(this.getString(PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText), startCount, 1));
                } else {
                    this.mTvPictureOk.setText((CharSequence)(PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText != 0 ? this.getString(PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText) : this.getString(R.string.picture_done)));
                }
            } else if (PictureSelectionConfig.style != null) {
                if (PictureSelectionConfig.style.isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, startCount, 1));
                } else {
                    this.mTvPictureOk.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText) ? PictureSelectionConfig.style.pictureCompleteText : this.getString(R.string.picture_done)));
                }
            }
        } else if (startCount <= 0) {
            if (PictureSelectionConfig.uiStyle != null) {
                this.mTvPictureOk.setText((CharSequence)(PictureSelectionConfig.uiStyle.isCompleteReplaceNum && PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText != 0 ? String.format(this.getString(PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText), startCount, this.config.maxSelectNum) : this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxSelectNum})));
            } else if (PictureSelectionConfig.style != null) {
                this.mTvPictureOk.setText((CharSequence)(PictureSelectionConfig.style.isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxSelectNum})));
            }
        } else if (PictureSelectionConfig.uiStyle != null) {
            if (PictureSelectionConfig.uiStyle.isCompleteReplaceNum && PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText != 0) {
                this.mTvPictureOk.setText((CharSequence)String.format(this.getString(PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText), startCount, this.config.maxSelectNum));
            } else {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxSelectNum}));
            }
        } else if (PictureSelectionConfig.style != null) {
            if (PictureSelectionConfig.style.isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, startCount, this.config.maxSelectNum));
            } else {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxSelectNum}));
            }
        }
    }

    protected void onPageSelectedChange(LocalMedia media) {
    }

    @Override
    public void initPictureSelectorStyle() {
        if (PictureSelectionConfig.uiStyle != null) {
            ViewGroup.LayoutParams params;
            ColorStateList colorStateList;
            if (PictureSelectionConfig.uiStyle.picture_top_titleTextColor != 0) {
                this.tvTitle.setTextColor(PictureSelectionConfig.uiStyle.picture_top_titleTextColor);
            }
            if (PictureSelectionConfig.uiStyle.picture_top_titleTextSize != 0) {
                this.tvTitle.setTextSize((float)PictureSelectionConfig.uiStyle.picture_top_titleTextSize);
            }
            if (PictureSelectionConfig.uiStyle.picture_top_leftBack != 0) {
                this.pictureLeftBack.setImageResource(PictureSelectionConfig.uiStyle.picture_top_leftBack);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_barBackgroundColor != 0) {
                this.selectBarLayout.setBackgroundColor(PictureSelectionConfig.uiStyle.picture_bottom_barBackgroundColor);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_completeRedDotBackground != 0) {
                this.tvMediaNum.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_bottom_completeRedDotBackground);
            }
            if (PictureSelectionConfig.uiStyle.picture_check_style != 0) {
                this.check.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_check_style);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_completeTextColor.length > 0 && (colorStateList = AttrsUtils.getColorStateList(PictureSelectionConfig.uiStyle.picture_bottom_completeTextColor)) != null) {
                this.mTvPictureOk.setTextColor(colorStateList);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText != 0) {
                this.mTvPictureOk.setText(PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText);
            }
            if (PictureSelectionConfig.uiStyle.picture_top_titleBarHeight > 0) {
                params = this.mTitleBar.getLayoutParams();
                params.height = PictureSelectionConfig.uiStyle.picture_top_titleBarHeight;
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_barHeight > 0) {
                params = this.selectBarLayout.getLayoutParams();
                params.height = PictureSelectionConfig.uiStyle.picture_bottom_barHeight;
            }
            if (this.config.isOriginalControl) {
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureCheckStyle != 0) {
                    this.mCbOriginal.setButtonDrawable(PictureSelectionConfig.uiStyle.picture_bottom_originalPictureCheckStyle);
                } else {
                    this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextColor != 0) {
                    this.mCbOriginal.setTextColor(PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextColor);
                } else {
                    this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextSize != 0) {
                    this.mCbOriginal.setTextSize((float)PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextSize);
                }
            } else {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
            }
        } else if (PictureSelectionConfig.style != null) {
            if (PictureSelectionConfig.style.pictureTitleTextColor != 0) {
                this.tvTitle.setTextColor(PictureSelectionConfig.style.pictureTitleTextColor);
            }
            if (PictureSelectionConfig.style.pictureTitleTextSize != 0) {
                this.tvTitle.setTextSize((float)PictureSelectionConfig.style.pictureTitleTextSize);
            }
            if (PictureSelectionConfig.style.pictureLeftBackIcon != 0) {
                this.pictureLeftBack.setImageResource(PictureSelectionConfig.style.pictureLeftBackIcon);
            }
            if (PictureSelectionConfig.style.picturePreviewBottomBgColor != 0) {
                this.selectBarLayout.setBackgroundColor(PictureSelectionConfig.style.picturePreviewBottomBgColor);
            }
            if (PictureSelectionConfig.style.pictureCheckNumBgStyle != 0) {
                this.tvMediaNum.setBackgroundResource(PictureSelectionConfig.style.pictureCheckNumBgStyle);
            }
            if (PictureSelectionConfig.style.pictureCheckedStyle != 0) {
                this.check.setBackgroundResource(PictureSelectionConfig.style.pictureCheckedStyle);
            }
            if (PictureSelectionConfig.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(PictureSelectionConfig.style.pictureUnCompleteTextColor);
            }
            if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText);
            }
            if (PictureSelectionConfig.style.pictureTitleBarHeight > 0) {
                ViewGroup.LayoutParams params = this.mTitleBar.getLayoutParams();
                params.height = PictureSelectionConfig.style.pictureTitleBarHeight;
            }
            if (this.config.isOriginalControl) {
                if (PictureSelectionConfig.style.pictureOriginalControlStyle != 0) {
                    this.mCbOriginal.setButtonDrawable(PictureSelectionConfig.style.pictureOriginalControlStyle);
                } else {
                    this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                }
                if (PictureSelectionConfig.style.pictureOriginalFontColor != 0) {
                    this.mCbOriginal.setTextColor(PictureSelectionConfig.style.pictureOriginalFontColor);
                } else {
                    this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
                }
                if (PictureSelectionConfig.style.pictureOriginalTextSize != 0) {
                    this.mCbOriginal.setTextSize((float)PictureSelectionConfig.style.pictureOriginalTextSize);
                }
            } else {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
            }
        } else {
            int titleBarHeight;
            Drawable pictureCheckedStyle = AttrsUtils.getTypeValueDrawable(this.getContext(), R.attr.picture_checked_style, R.drawable.picture_checkbox_selector);
            this.check.setBackground(pictureCheckedStyle);
            ColorStateList completeColorStateList = AttrsUtils.getTypeValueColorStateList(this.getContext(), R.attr.picture_ac_preview_complete_textColor);
            if (completeColorStateList != null) {
                this.mTvPictureOk.setTextColor(completeColorStateList);
            }
            Drawable leftDrawable = AttrsUtils.getTypeValueDrawable(this.getContext(), R.attr.picture_preview_leftBack_icon, R.drawable.picture_icon_back);
            this.pictureLeftBack.setImageDrawable(leftDrawable);
            int titleColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_ac_preview_title_textColor);
            if (titleColor != 0) {
                this.tvTitle.setTextColor(titleColor);
            }
            Drawable ovalBgDrawable = AttrsUtils.getTypeValueDrawable(this.getContext(), R.attr.picture_num_style, R.drawable.picture_num_oval);
            this.tvMediaNum.setBackground(ovalBgDrawable);
            int previewBottomBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_ac_preview_bottom_bg);
            if (previewBottomBgColor != 0) {
                this.selectBarLayout.setBackgroundColor(previewBottomBgColor);
            }
            if ((titleBarHeight = AttrsUtils.getTypeValueSizeForInt(this.getContext(), R.attr.picture_titleBar_height)) > 0) {
                ViewGroup.LayoutParams params = this.mTitleBar.getLayoutParams();
                params.height = titleBarHeight;
            }
            if (this.config.isOriginalControl) {
                Drawable originalDrawable = AttrsUtils.getTypeValueDrawable(this.getContext(), R.attr.picture_original_check_style, R.drawable.picture_original_wechat_checkbox);
                this.mCbOriginal.setButtonDrawable(originalDrawable);
                int originalTextColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_original_text_color);
                if (originalTextColor != 0) {
                    this.mCbOriginal.setTextColor(originalTextColor);
                }
            }
        }
        this.mTitleBar.setBackgroundColor(this.colorPrimary);
        this.onSelectNumChange(false);
    }

    private void isPreviewEggs(boolean previewEggs, int position, int positionOffsetPixels) {
        if (previewEggs && this.adapter.getSize() > 0) {
            if (positionOffsetPixels < this.screenWidth / 2) {
                LocalMedia media = this.adapter.getItem(position);
                if (media != null) {
                    this.check.setSelected(this.isSelected(media));
                    if (this.config.isWeChatStyle) {
                        this.onUpdateSelectedChange(media);
                    } else if (this.config.checkNumMode) {
                        int num = media.getNum();
                        this.check.setText((CharSequence)ValueOf.toString(num));
                        this.notifyCheckChanged(media);
                        this.onImageChecked(position);
                    }
                }
            } else {
                LocalMedia media = this.adapter.getItem(position + 1);
                if (media != null) {
                    this.check.setSelected(this.isSelected(media));
                    if (this.config.isWeChatStyle) {
                        this.onUpdateSelectedChange(media);
                    } else if (this.config.checkNumMode) {
                        int num = media.getNum();
                        this.check.setText((CharSequence)ValueOf.toString(num));
                        this.notifyCheckChanged(media);
                        this.onImageChecked(position + 1);
                    }
                }
            }
        }
    }

    private void initViewPageAdapterData(List<LocalMedia> list) {
        this.adapter = new PictureSimpleFragmentAdapter(this.config, this);
        this.adapter.bindData(list);
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.setTitle();
        this.onImageChecked(this.position);
        LocalMedia media = this.adapter.getItem(this.position);
        if (media != null) {
            this.index = media.getPosition();
            if (this.config.checkNumMode) {
                this.tvMediaNum.setSelected(true);
                this.check.setText((CharSequence)ValueOf.toString(media.getNum()));
                this.notifyCheckChanged(media);
            }
        }
    }

    private void setNewTitle() {
        this.mPage = 0;
        this.position = 0;
        this.setTitle();
    }

    private void setTitle() {
        if (this.config.isPageStrategy && !this.isBottomPreview) {
            this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.totalNumber}));
        } else {
            this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.adapter.getSize()}));
        }
    }

    private void notifyCheckChanged(LocalMedia imageBean) {
        if (this.config.checkNumMode) {
            this.check.setText((CharSequence)"");
            int size = this.selectData.size();
            for (int i = 0; i < size; ++i) {
                LocalMedia media = this.selectData.get(i);
                if (!media.getPath().equals(imageBean.getPath()) && media.getId() != imageBean.getId()) continue;
                imageBean.setNum(media.getNum());
                this.check.setText((CharSequence)ValueOf.toString(imageBean.getNum()));
            }
        }
    }

    private void subSelectPosition() {
        int len = this.selectData.size();
        for (int index = 0; index < len; ++index) {
            LocalMedia media = this.selectData.get(index);
            media.setNum(index + 1);
        }
    }

    public void onImageChecked(int position) {
        if (this.adapter.getSize() > 0) {
            LocalMedia media = this.adapter.getItem(position);
            if (media != null) {
                this.check.setSelected(this.isSelected(media));
            }
        } else {
            this.check.setSelected(false);
        }
    }

    protected boolean isSelected(LocalMedia image) {
        int size = this.selectData.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = this.selectData.get(i);
            if (!media.getPath().equals(image.getPath()) && media.getId() != image.getId()) continue;
            return true;
        }
        return false;
    }

    protected void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        this.refresh = isRefresh;
        boolean bl = enable = this.selectData.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            if (PictureSelectionConfig.style != null) {
                if (PictureSelectionConfig.style.pictureCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(PictureSelectionConfig.style.pictureCompleteTextColor);
                } else {
                    this.mTvPictureOk.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_fa632d));
                }
            }
            if (this.numComplete) {
                this.initCompleteText(this.selectData.size());
            } else {
                if (this.refresh) {
                    this.tvMediaNum.startAnimation(this.animation);
                }
                this.tvMediaNum.setVisibility(0);
                this.tvMediaNum.setText((CharSequence)ValueOf.toString(this.selectData.size()));
                if (PictureSelectionConfig.uiStyle != null) {
                    if (PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText != 0) {
                        this.mTvPictureOk.setText(PictureSelectionConfig.uiStyle.picture_bottom_completeNormalText);
                    }
                } else if (PictureSelectionConfig.style != null) {
                    if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                        this.mTvPictureOk.setText((CharSequence)PictureSelectionConfig.style.pictureCompleteText);
                    }
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
                }
            }
        } else {
            this.mTvPictureOk.setEnabled(false);
            this.mTvPictureOk.setSelected(false);
            if (PictureSelectionConfig.style != null) {
                if (PictureSelectionConfig.style.pictureUnCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(PictureSelectionConfig.style.pictureUnCompleteTextColor);
                } else {
                    this.mTvPictureOk.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_9b));
                }
            }
            if (this.numComplete) {
                this.initCompleteText(0);
            } else {
                this.tvMediaNum.setVisibility(4);
                if (PictureSelectionConfig.uiStyle != null) {
                    if (PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText != 0) {
                        this.mTvPictureOk.setText(PictureSelectionConfig.uiStyle.picture_bottom_completeDefaultText);
                    }
                } else if (PictureSelectionConfig.style != null) {
                    if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText)) {
                        this.mTvPictureOk.setText((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText);
                    }
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
                }
            }
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.pictureLeftBack) {
            this.onBackPressed();
        } else if (id2 == R.id.picture_tv_ok || id2 == R.id.tv_media_num) {
            this.onComplete();
        } else if (id2 == R.id.btnCheck) {
            this.onCheckedComplete();
        }
    }

    protected void onCheckedComplete() {
        block26: {
            block28: {
                LocalMedia image;
                block27: {
                    boolean isChecked;
                    if (this.adapter.getSize() <= 0) break block26;
                    image = this.adapter.getItem(this.viewPager.getCurrentItem());
                    String newPath = image.getRealPath();
                    if (!TextUtils.isEmpty((CharSequence)newPath) && !new File(newPath).exists()) {
                        ToastUtils.s(this.getContext(), PictureMimeType.s(this.getContext(), image.getMimeType()));
                        return;
                    }
                    String mimeType = this.selectData.size() > 0 ? this.selectData.get(0).getMimeType() : "";
                    int currentSize = this.selectData.size();
                    if (this.config.isWithVideoImage) {
                        int videoSize = 0;
                        for (int i = 0; i < currentSize; ++i) {
                            LocalMedia media = this.selectData.get(i);
                            if (!PictureMimeType.isHasVideo(media.getMimeType())) continue;
                            ++videoSize;
                        }
                        if (PictureMimeType.isHasVideo(image.getMimeType())) {
                            if (this.config.maxVideoSelectNum <= 0) {
                                this.showPromptDialog(this.getString(R.string.picture_rule));
                                return;
                            }
                            if (currentSize >= this.config.maxSelectNum && !this.check.isSelected()) {
                                this.showPromptDialog(this.getString(R.string.picture_message_max_num, new Object[]{this.config.maxSelectNum}));
                                return;
                            }
                            if (videoSize >= this.config.maxVideoSelectNum && !this.check.isSelected()) {
                                this.showPromptDialog(StringUtils.getMsg(this.getContext(), image.getMimeType(), this.config.maxVideoSelectNum));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                                this.showPromptDialog(this.getContext().getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                                this.showPromptDialog(this.getContext().getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                                return;
                            }
                        } else if (currentSize >= this.config.maxSelectNum && !this.check.isSelected()) {
                            this.showPromptDialog(this.getString(R.string.picture_message_max_num, new Object[]{this.config.maxSelectNum}));
                            return;
                        }
                    } else {
                        boolean mimeTypeSame;
                        if (!TextUtils.isEmpty((CharSequence)mimeType) && !(mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, image.getMimeType()))) {
                            this.showPromptDialog(this.getString(R.string.picture_rule));
                            return;
                        }
                        if (PictureMimeType.isHasVideo(mimeType) && this.config.maxVideoSelectNum > 0) {
                            if (currentSize >= this.config.maxVideoSelectNum && !this.check.isSelected()) {
                                this.showPromptDialog(StringUtils.getMsg(this.getContext(), mimeType, this.config.maxVideoSelectNum));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                                this.showPromptDialog(this.getContext().getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                                this.showPromptDialog(this.getContext().getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                                return;
                            }
                        } else {
                            if (currentSize >= this.config.maxSelectNum && !this.check.isSelected()) {
                                this.showPromptDialog(StringUtils.getMsg(this.getContext(), mimeType, this.config.maxSelectNum));
                                return;
                            }
                            if (PictureMimeType.isHasVideo(image.getMimeType())) {
                                if (!this.check.isSelected() && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                                    this.showPromptDialog(this.getContext().getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                                    return;
                                }
                                if (!this.check.isSelected() && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                                    this.showPromptDialog(this.getContext().getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                                    return;
                                }
                            }
                        }
                    }
                    if (!this.check.isSelected()) {
                        isChecked = true;
                        this.check.setSelected(true);
                        this.check.startAnimation(this.animation);
                    } else {
                        isChecked = false;
                        this.check.setSelected(false);
                    }
                    this.isChangeSelectedData = true;
                    if (!isChecked) break block27;
                    VoiceUtils.getInstance().play();
                    if (this.config.selectionMode == 1) {
                        this.selectData.clear();
                    }
                    this.selectData.add(image);
                    this.onSelectedChange(true, image);
                    image.setNum(this.selectData.size());
                    if (!this.config.checkNumMode) break block28;
                    this.check.setText((CharSequence)ValueOf.toString(image.getNum()));
                    break block28;
                }
                int size = this.selectData.size();
                for (int i = 0; i < size; ++i) {
                    LocalMedia media = this.selectData.get(i);
                    if (!media.getPath().equals(image.getPath()) && media.getId() != image.getId()) continue;
                    this.selectData.remove(media);
                    this.onSelectedChange(false, image);
                    this.subSelectPosition();
                    this.notifyCheckChanged(media);
                    break;
                }
            }
            this.onSelectNumChange(true);
        }
    }

    protected void onSelectedChange(boolean isAddRemove, LocalMedia media) {
    }

    protected void onUpdateSelectedChange(LocalMedia media) {
    }

    protected void onComplete() {
        String mimeType;
        int size = this.selectData.size();
        LocalMedia image = this.selectData.size() > 0 ? this.selectData.get(0) : null;
        String string2 = mimeType = image != null ? image.getMimeType() : "";
        if (this.config.isWithVideoImage) {
            int videoSize = 0;
            int imageSize = 0;
            int currentSize = this.selectData.size();
            for (int i = 0; i < currentSize; ++i) {
                LocalMedia media = this.selectData.get(i);
                if (PictureMimeType.isHasVideo(media.getMimeType())) {
                    ++videoSize;
                    continue;
                }
                ++imageSize;
            }
            if (this.config.selectionMode == 2) {
                if (this.config.minSelectNum > 0 && imageSize < this.config.minSelectNum) {
                    this.showPromptDialog(this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}));
                    return;
                }
                if (this.config.minVideoSelectNum > 0 && videoSize < this.config.minVideoSelectNum) {
                    this.showPromptDialog(this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum}));
                    return;
                }
            }
        } else if (this.config.selectionMode == 2) {
            if (PictureMimeType.isHasImage(mimeType) && this.config.minSelectNum > 0 && size < this.config.minSelectNum) {
                String str = this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum});
                this.showPromptDialog(str);
                return;
            }
            if (PictureMimeType.isHasVideo(mimeType) && this.config.minVideoSelectNum > 0 && size < this.config.minVideoSelectNum) {
                String str = this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum});
                this.showPromptDialog(str);
                return;
            }
        }
        this.isCompleteOrSelected = true;
        this.isChangeSelectedData = true;
        if (this.config.chooseMode == PictureMimeType.ofAll() && this.config.isWithVideoImage) {
            this.bothMimeTypeWith(mimeType, image);
        } else {
            this.separateMimeTypeWith(mimeType, image);
        }
    }

    private void bothMimeTypeWith(String mimeType, LocalMedia image) {
        if (this.config.enableCrop && !this.config.isCheckOriginalImage) {
            this.isCompleteOrSelected = false;
            boolean isHasImage = PictureMimeType.isHasImage(mimeType);
            if (this.config.selectionMode == 1 && isHasImage) {
                this.config.originalPath = image.getPath();
                UCropManager.ofCrop((Activity)this, this.config.originalPath, image.getMimeType());
            } else {
                int imageNum = 0;
                int count = this.selectData.size();
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = this.selectData.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath()) || !PictureMimeType.isHasImage(media.getMimeType())) continue;
                    ++imageNum;
                }
                if (imageNum <= 0) {
                    this.isCompleteOrSelected = true;
                    this.onBackPressed();
                } else {
                    UCropManager.ofCrop((Activity)this, (ArrayList)this.selectData);
                }
            }
        } else {
            this.onBackPressed();
        }
    }

    private void separateMimeTypeWith(String mimeType, LocalMedia image) {
        if (this.config.enableCrop && !this.config.isCheckOriginalImage && PictureMimeType.isHasImage(mimeType)) {
            this.isCompleteOrSelected = false;
            if (this.config.selectionMode == 1) {
                this.config.originalPath = image.getPath();
                UCropManager.ofCrop((Activity)this, this.config.originalPath, image.getMimeType());
            } else {
                UCropManager.ofCrop((Activity)this, (ArrayList)this.selectData);
            }
        } else {
            this.onBackPressed();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Throwable throwable;
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 609: {
                    ArrayList<LocalMedia> list = UCrop.getMultipleOutput(data);
                    data.putParcelableArrayListExtra("com.yalantis.ucrop.OutputUriList", list);
                    data.putParcelableArrayListExtra("selectList", (ArrayList)this.selectData);
                    this.setResult(-1, data);
                    this.finish();
                    break;
                }
                case 69: {
                    if (data != null) {
                        data.putParcelableArrayListExtra("selectList", (ArrayList)this.selectData);
                        this.setResult(-1, data);
                    }
                    this.finish();
                }
            }
        } else if (resultCode == 96 && (throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error")) != null) {
            ToastUtils.s(this.getContext(), throwable.getMessage());
        }
    }

    public void onBackPressed() {
        this.updateResult();
        this.finish();
        this.overridePendingTransition(0, PictureSelectionConfig.windowAnimationStyle.activityPreviewExitAnimation);
    }

    private void updateResult() {
        Intent intent = new Intent();
        if (this.isChangeSelectedData) {
            intent.putExtra("isCompleteOrSelected", this.isCompleteOrSelected);
            intent.putParcelableArrayListExtra("selectList", (ArrayList)this.selectData);
        }
        if (this.config.isOriginalControl) {
            intent.putExtra("isOriginal", this.config.isCheckOriginalImage);
        }
        this.setResult(0, intent);
    }

    @Override
    protected void onSaveInstanceState(@NotNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isCompleteOrSelected", this.isCompleteOrSelected);
        outState.putBoolean("isChangeSelectedData", this.isChangeSelectedData);
        PictureSelector.saveSelectorList(outState, this.selectData);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (!this.isOnSaveInstanceState) {
            ImagesObservable.getInstance().clearPreviewMediaData();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.adapter != null) {
            this.adapter.clear();
        }
    }

    @Override
    public void onActivityBackPressed() {
        this.onBackPressed();
    }
}

