/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.PicturePreviewActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureWeChatPreviewGalleryAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.decoration.WrapContentLinearLayoutManager;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.ScreenUtils;

public class PictureSelectorPreviewWeChatStyleActivity
extends PicturePreviewActivity {
    private static final int ALPHA_DURATION = 300;
    private RecyclerView mRvGallery;
    private View bottomLine;
    private TextView mTvSelected;
    private PictureWeChatPreviewGalleryAdapter mGalleryAdapter;

    @Override
    public int getResourceId() {
        return R.layout.picture_wechat_style_preview;
    }

    private void goneParent() {
        if (this.tvMediaNum.getVisibility() == 0) {
            this.tvMediaNum.setVisibility(8);
        }
        if (this.mTvPictureOk.getVisibility() == 0) {
            this.mTvPictureOk.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.check.getText())) {
            this.check.setText((CharSequence)"");
        }
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.goneParent();
        this.mRvGallery = (RecyclerView)this.findViewById(R.id.rv_gallery);
        this.bottomLine = this.findViewById(R.id.bottomLine);
        this.mTvPictureRight.setVisibility(0);
        this.mTvPictureRight.setText((CharSequence)this.getString(R.string.picture_send));
        this.mCbOriginal.setTextSize(16.0f);
        this.mTvSelected = (TextView)this.findViewById(R.id.tv_selected);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        this.mGalleryAdapter = new PictureWeChatPreviewGalleryAdapter(this.config);
        WrapContentLinearLayoutManager layoutManager = new WrapContentLinearLayoutManager(this.getContext());
        layoutManager.setOrientation(0);
        this.mRvGallery.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvGallery.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(Integer.MAX_VALUE, ScreenUtils.dip2px((Context)this, 8.0f), false));
        this.mRvGallery.setAdapter((RecyclerView.Adapter)this.mGalleryAdapter);
        this.mGalleryAdapter.setItemClickListener((position, media, v) -> {
            if (this.viewPager != null && media != null && this.isEqualsDirectory(media.getParentFolderName(), this.currentDirectory)) {
                int newPosition = this.isBottomPreview ? position : (this.isShowCamera ? media.position - 1 : media.position);
                this.viewPager.setCurrentItem(newPosition);
            }
        });
        if (this.isBottomPreview) {
            if (this.selectData.size() > this.position) {
                int size = this.selectData.size();
                for (int i = 0; i < size; ++i) {
                    LocalMedia media2 = (LocalMedia)this.selectData.get(i);
                    media2.setChecked(false);
                }
                LocalMedia media3 = (LocalMedia)this.selectData.get(this.position);
                media3.setChecked(true);
            }
        } else {
            int size = this.selectData.size();
            for (int i = 0; i < size; ++i) {
                LocalMedia media4 = (LocalMedia)this.selectData.get(i);
                if (!this.isEqualsDirectory(media4.getParentFolderName(), this.currentDirectory)) continue;
                media4.setChecked(this.isShowCamera ? media4.position - 1 == this.position : media4.position == this.position);
            }
        }
    }

    private boolean isEqualsDirectory(String parentFolderName, String currentDirectory) {
        return this.isBottomPreview || TextUtils.isEmpty((CharSequence)parentFolderName) || TextUtils.isEmpty((CharSequence)currentDirectory) || currentDirectory.equals(this.getString(R.string.picture_camera_roll)) || parentFolderName.equals(currentDirectory);
    }

    @Override
    public void initPictureSelectorStyle() {
        super.initPictureSelectorStyle();
        if (PictureSelectionConfig.uiStyle != null) {
            if (PictureSelectionConfig.uiStyle.picture_top_titleRightDefaultText != 0) {
                this.mTvPictureRight.setText((CharSequence)this.getString(PictureSelectionConfig.uiStyle.picture_top_titleRightDefaultText));
            }
            if (PictureSelectionConfig.uiStyle.picture_top_titleRightTextNormalBackground != 0) {
                this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_top_titleRightTextNormalBackground);
            } else {
                this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_bg);
            }
            if (PictureSelectionConfig.uiStyle.picture_top_titleRightTextSize != 0) {
                this.mTvPictureRight.setTextSize((float)PictureSelectionConfig.uiStyle.picture_top_titleRightTextSize);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_selectedText != 0) {
                this.mTvSelected.setText((CharSequence)this.getString(PictureSelectionConfig.uiStyle.picture_bottom_selectedText));
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_selectedTextSize != 0) {
                this.mTvSelected.setTextSize((float)PictureSelectionConfig.uiStyle.picture_bottom_selectedTextSize);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_selectedTextColor != 0) {
                this.mTvSelected.setTextColor(PictureSelectionConfig.uiStyle.picture_bottom_selectedTextColor);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_barBackgroundColor != 0) {
                this.selectBarLayout.setBackgroundColor(PictureSelectionConfig.uiStyle.picture_bottom_barBackgroundColor);
            } else {
                this.selectBarLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_half_grey));
            }
            this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
            if (PictureSelectionConfig.uiStyle.picture_bottom_selectedCheckStyle != 0) {
                this.check.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_bottom_selectedCheckStyle);
            } else {
                this.check.setBackgroundResource(R.drawable.picture_wechat_select_cb);
            }
            if (PictureSelectionConfig.uiStyle.picture_top_leftBack != 0) {
                this.pictureLeftBack.setImageResource(PictureSelectionConfig.uiStyle.picture_top_leftBack);
            } else {
                this.pictureLeftBack.setImageResource(R.drawable.picture_icon_back);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_gallery_backgroundColor != 0) {
                this.mRvGallery.setBackgroundColor(PictureSelectionConfig.uiStyle.picture_bottom_gallery_backgroundColor);
            }
            if (PictureSelectionConfig.uiStyle.picture_bottom_gallery_height > 0) {
                ViewGroup.LayoutParams params = this.mRvGallery.getLayoutParams();
                params.height = PictureSelectionConfig.uiStyle.picture_bottom_gallery_height;
            }
            if (this.config.isOriginalControl) {
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureText != 0) {
                    this.mCbOriginal.setText((CharSequence)this.getString(PictureSelectionConfig.uiStyle.picture_bottom_originalPictureText));
                } else {
                    this.mCbOriginal.setText((CharSequence)this.getString(R.string.picture_original_image));
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextSize != 0) {
                    this.mCbOriginal.setTextSize((float)PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextSize);
                } else {
                    this.mCbOriginal.setTextSize(14.0f);
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextColor != 0) {
                    this.mCbOriginal.setTextColor(PictureSelectionConfig.uiStyle.picture_bottom_originalPictureTextColor);
                } else {
                    this.mCbOriginal.setTextColor(Color.parseColor((String)"#FFFFFF"));
                }
                if (PictureSelectionConfig.uiStyle.picture_bottom_originalPictureCheckStyle != 0) {
                    this.mCbOriginal.setButtonDrawable(PictureSelectionConfig.uiStyle.picture_bottom_originalPictureCheckStyle);
                } else {
                    this.mCbOriginal.setButtonDrawable(R.drawable.picture_original_wechat_checkbox);
                }
            }
        } else if (PictureSelectionConfig.style != null) {
            if (PictureSelectionConfig.style.pictureCompleteBackgroundStyle != 0) {
                this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.style.pictureCompleteBackgroundStyle);
            } else {
                this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_bg);
            }
            if (PictureSelectionConfig.style.pictureRightTextSize != 0) {
                this.mTvPictureRight.setTextSize((float)PictureSelectionConfig.style.pictureRightTextSize);
            }
            if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureWeChatPreviewSelectedText)) {
                this.mTvSelected.setText((CharSequence)PictureSelectionConfig.style.pictureWeChatPreviewSelectedText);
            }
            if (PictureSelectionConfig.style.pictureWeChatPreviewSelectedTextSize != 0) {
                this.mTvSelected.setTextSize((float)PictureSelectionConfig.style.pictureWeChatPreviewSelectedTextSize);
            }
            if (PictureSelectionConfig.style.picturePreviewBottomBgColor != 0) {
                this.selectBarLayout.setBackgroundColor(PictureSelectionConfig.style.picturePreviewBottomBgColor);
            } else {
                this.selectBarLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_half_grey));
            }
            if (PictureSelectionConfig.style.pictureCompleteTextColor != 0) {
                this.mTvPictureRight.setTextColor(PictureSelectionConfig.style.pictureCompleteTextColor);
            } else if (PictureSelectionConfig.style.pictureCancelTextColor != 0) {
                this.mTvPictureRight.setTextColor(PictureSelectionConfig.style.pictureCancelTextColor);
            } else {
                this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
            }
            if (PictureSelectionConfig.style.pictureOriginalFontColor == 0) {
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            }
            if (PictureSelectionConfig.style.pictureWeChatChooseStyle != 0) {
                this.check.setBackgroundResource(PictureSelectionConfig.style.pictureWeChatChooseStyle);
            } else {
                this.check.setBackgroundResource(R.drawable.picture_wechat_select_cb);
            }
            if (this.config.isOriginalControl && PictureSelectionConfig.style.pictureOriginalControlStyle == 0) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
            if (PictureSelectionConfig.style.pictureWeChatLeftBackStyle != 0) {
                this.pictureLeftBack.setImageResource(PictureSelectionConfig.style.pictureWeChatLeftBackStyle);
            } else {
                this.pictureLeftBack.setImageResource(R.drawable.picture_icon_back);
            }
            if (!TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText)) {
                this.mTvPictureRight.setText((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText);
            }
        } else {
            this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_bg);
            this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
            this.selectBarLayout.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_half_grey));
            this.check.setBackgroundResource(R.drawable.picture_wechat_select_cb);
            this.pictureLeftBack.setImageResource(R.drawable.picture_icon_back);
            this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_white));
            if (this.config.isOriginalControl) {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_wechat_checkbox));
            }
        }
        this.onSelectNumChange(false);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int id2 = v.getId();
        if (id2 == R.id.picture_right) {
            boolean enable;
            boolean bl = enable = this.selectData.size() != 0;
            if (enable) {
                this.mTvPictureOk.performClick();
            } else {
                boolean isNewEnableStatus;
                this.btnCheck.performClick();
                boolean bl2 = isNewEnableStatus = this.selectData.size() != 0;
                if (isNewEnableStatus) {
                    this.mTvPictureOk.performClick();
                }
            }
        }
    }

    @Override
    protected void onUpdateSelectedChange(LocalMedia media) {
        this.onChangeMediaStatus(media);
    }

    @Override
    protected void onSelectedChange(boolean isAddRemove, LocalMedia media) {
        int itemCount;
        if (isAddRemove) {
            media.setChecked(true);
            if (this.config.selectionMode == 1) {
                this.mGalleryAdapter.addSingleMediaToData(media);
            }
        } else {
            media.setChecked(false);
            this.mGalleryAdapter.removeMediaToData(media);
            if (this.isBottomPreview) {
                if (this.selectData.size() > this.position) {
                    ((LocalMedia)this.selectData.get(this.position)).setChecked(true);
                }
                if (this.mGalleryAdapter.isDataEmpty()) {
                    this.onActivityBackPressed();
                } else {
                    int currentItem = this.viewPager.getCurrentItem();
                    this.adapter.remove(currentItem);
                    this.adapter.removeCacheView(currentItem);
                    this.position = currentItem;
                    this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.adapter.getSize()}));
                    this.check.setSelected(true);
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
        if ((itemCount = this.mGalleryAdapter.getItemCount()) > 5) {
            this.mRvGallery.smoothScrollToPosition(itemCount - 1);
        }
    }

    @Override
    protected void onPageSelectedChange(LocalMedia media) {
        super.onPageSelectedChange(media);
        this.goneParent();
        if (!this.config.previewEggs) {
            this.onChangeMediaStatus(media);
        }
    }

    private void onChangeMediaStatus(LocalMedia media) {
        int itemCount;
        if (this.mGalleryAdapter != null && (itemCount = this.mGalleryAdapter.getItemCount()) > 0) {
            boolean isChangeData = false;
            for (int i = 0; i < itemCount; ++i) {
                boolean isNewChecked;
                LocalMedia item = this.mGalleryAdapter.getItem(i);
                if (item == null || TextUtils.isEmpty((CharSequence)item.getPath())) continue;
                boolean isOldChecked = item.isChecked();
                boolean bl = isNewChecked = item.getPath().equals(media.getPath()) || item.getId() == media.getId();
                if (!isChangeData) {
                    isChangeData = isOldChecked && !isNewChecked || !isOldChecked && isNewChecked;
                }
                item.setChecked(isNewChecked);
            }
            if (isChangeData) {
                this.mGalleryAdapter.notifyDataSetChanged();
            }
        }
    }

    @Override
    protected void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        this.goneParent();
        boolean bl = enable = this.selectData.size() != 0;
        if (enable) {
            this.initCompleteText(this.selectData.size());
            if (this.mRvGallery.getVisibility() == 8) {
                this.mRvGallery.animate().alpha(1.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                this.mRvGallery.setVisibility(0);
                this.bottomLine.animate().alpha(1.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                this.bottomLine.setVisibility(0);
                this.mGalleryAdapter.setNewData(this.selectData);
            }
            if (PictureSelectionConfig.style != null) {
                if (PictureSelectionConfig.style.pictureCompleteTextColor != 0) {
                    this.mTvPictureRight.setTextColor(PictureSelectionConfig.style.pictureCompleteTextColor);
                }
                if (PictureSelectionConfig.style.pictureCompleteBackgroundStyle != 0) {
                    this.mTvPictureRight.setBackgroundResource(PictureSelectionConfig.style.pictureCompleteBackgroundStyle);
                }
            } else {
                this.mTvPictureRight.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_white));
                this.mTvPictureRight.setBackgroundResource(R.drawable.picture_send_button_bg);
            }
        } else {
            if (PictureSelectionConfig.style != null && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText)) {
                this.mTvPictureRight.setText((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText);
            } else {
                this.mTvPictureRight.setText((CharSequence)this.getString(R.string.picture_send));
            }
            this.mRvGallery.animate().alpha(0.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mRvGallery.setVisibility(8);
            this.bottomLine.animate().alpha(0.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.bottomLine.setVisibility(8);
        }
    }

    @Override
    protected void initCompleteText(int startCount) {
        boolean isNotEmptyStyle;
        boolean bl = isNotEmptyStyle = PictureSelectionConfig.style != null;
        if (this.config.isWithVideoImage) {
            if (this.config.selectionMode == 1) {
                if (startCount <= 0) {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_send)));
                } else {
                    boolean isCompleteReplaceNum;
                    boolean bl2 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                    if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                        this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, this.selectData.size(), 1));
                    } else {
                        this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText) ? PictureSelectionConfig.style.pictureCompleteText : this.getString(R.string.picture_send)));
                    }
                }
            } else {
                boolean isCompleteReplaceNum;
                boolean bl3 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                    this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, this.selectData.size(), this.config.maxSelectNum));
                } else {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_send_num, new Object[]{this.selectData.size(), this.config.maxSelectNum})));
                }
            }
        } else {
            int maxSize;
            String mimeType = this.selectData.size() > 0 ? ((LocalMedia)this.selectData.get(0)).getMimeType() : "";
            int n = maxSize = PictureMimeType.isHasVideo(mimeType) && this.config.maxVideoSelectNum > 0 ? this.config.maxVideoSelectNum : this.config.maxSelectNum;
            if (this.config.selectionMode == 1) {
                if (startCount <= 0) {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_send)));
                } else {
                    boolean isCompleteReplaceNum;
                    boolean bl4 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                    if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                        this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, this.selectData.size(), 1));
                    } else {
                        this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText) ? PictureSelectionConfig.style.pictureCompleteText : this.getString(R.string.picture_send)));
                    }
                }
            } else {
                boolean isCompleteReplaceNum;
                boolean bl5 = isCompleteReplaceNum = isNotEmptyStyle && PictureSelectionConfig.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureCompleteText)) {
                    this.mTvPictureRight.setText((CharSequence)String.format(PictureSelectionConfig.style.pictureCompleteText, this.selectData.size(), maxSize));
                } else {
                    this.mTvPictureRight.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)PictureSelectionConfig.style.pictureUnCompleteText) ? PictureSelectionConfig.style.pictureUnCompleteText : this.getString(R.string.picture_send_num, new Object[]{this.selectData.size(), maxSize})));
                }
            }
        }
    }
}

