/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import androidx.exifinterface.media.ExifInterface;
import com.luck.picture.lib.tools.PictureFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static void rotateImage(boolean isCameraRotateImage, String path) {
        try {
            int degree;
            if (isCameraRotateImage && (degree = BitmapUtils.readPictureDegree(path)) > 0) {
                BitmapFactory.Options opts = new BitmapFactory.Options();
                opts.inSampleSize = 2;
                File file = new File(path);
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opts);
                if ((bitmap = BitmapUtils.rotatingImage(bitmap, degree)) != null) {
                    BitmapUtils.saveBitmapFile(bitmap, file);
                    bitmap.recycle();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap rotatingImage(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBitmapFile(Bitmap bitmap, File file) {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
            bos.flush();
            PictureFileUtils.close(bos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close(bos);
        }
    }

    public static int readPictureDegree(String filePath) {
        try {
            ExifInterface exifInterface = new ExifInterface(filePath);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

