/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.entity.LocalMedia;
import com.yalantis.ucrop.callback.BitmapLoadCallback;
import com.yalantis.ucrop.model.ExifInfo;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import com.yalantis.ucrop.util.MimeType;
import com.yalantis.ucrop.util.SdkUtils;
import java.io.File;
import java.util.List;

public class PicturePhotoGalleryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<LocalMedia> list;
    private OnItemClickListener listener;

    public PicturePhotoGalleryAdapter(List<LocalMedia> list) {
        this.list = list;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int position) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ucrop_picture_gf_adapter_edit_list, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        LocalMedia photoInfo = this.list.get(position);
        String path = photoInfo.getPath();
        if (photoInfo.isCut()) {
            holder.iv_dot.setVisibility(0);
            holder.iv_dot.setImageResource(R.drawable.ucrop_oval_true);
        } else {
            holder.iv_dot.setVisibility(4);
        }
        boolean isHasVideo = MimeType.isHasVideo(photoInfo.getMimeType());
        if (isHasVideo) {
            holder.mIvPhoto.setVisibility(8);
            holder.mIvVideo.setVisibility(0);
            holder.mIvVideo.setImageResource(R.drawable.ucrop_ic_default_video);
        } else {
            holder.mIvPhoto.setVisibility(0);
            holder.mIvVideo.setVisibility(8);
            Uri uri = SdkUtils.isQ() || MimeType.isHttp(path) ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
            holder.tvGif.setVisibility(MimeType.isGif(photoInfo.getMimeType()) ? 0 : 8);
            int maxImageWidth = 200;
            int maxImageHeight = 220;
            Uri outputUri = TextUtils.isEmpty((CharSequence)photoInfo.getCropHttpOutUri()) ? null : Uri.fromFile((File)new File(photoInfo.getCropHttpOutUri()));
            BitmapLoadUtils.decodeBitmapInBackground(holder.itemView.getContext(), uri, outputUri, maxImageWidth, maxImageHeight, new BitmapLoadCallback(){

                @Override
                public void onBitmapLoaded(@NonNull Bitmap bitmap, @NonNull ExifInfo exifInfo, @NonNull String imageInputPath, @Nullable String imageOutputPath) {
                    if (holder.mIvPhoto != null) {
                        holder.mIvPhoto.setImageBitmap(bitmap);
                    }
                }

                @Override
                public void onFailure(@NonNull Exception bitmapWorkerException) {
                    if (holder.mIvPhoto != null) {
                        holder.mIvPhoto.setImageResource(R.color.ucrop_color_ba3);
                    }
                }
            });
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PicturePhotoGalleryAdapter.this.listener != null) {
                        PicturePhotoGalleryAdapter.this.listener.onItemClick(holder.getAdapterPosition(), v);
                    }
                }
            });
        }
    }

    public int getItemCount() {
        return this.list != null ? this.list.size() : 0;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, View var2);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mIvPhoto;
        ImageView iv_dot;
        ImageView mIvVideo;
        TextView tvGif;

        public ViewHolder(View view) {
            super(view);
            this.mIvPhoto = (ImageView)view.findViewById(R.id.iv_photo);
            this.mIvVideo = (ImageView)view.findViewById(R.id.iv_video);
            this.iv_dot = (ImageView)view.findViewById(R.id.iv_dot);
            this.tvGif = (TextView)view.findViewById(R.id.tv_gif);
        }
    }
}

