/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;

public class BitmapUtils {
    public static Bitmap toHorizontalMirror(Bitmap bmp) {
        int w = bmp.getWidth();
        int h = bmp.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(-1.0f, 1.0f);
        matrix.postRotate(w > h ? 90.0f : 0.0f);
        return Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
    }

    public static int computeSize(int srcWidth, int srcHeight) {
        srcWidth = srcWidth % 2 == 1 ? srcWidth + 1 : srcWidth;
        srcHeight = srcHeight % 2 == 1 ? srcHeight + 1 : srcHeight;
        int longSide = Math.max(srcWidth, srcHeight);
        int shortSide = Math.min(srcWidth, srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 1;
            }
            if (longSide < 4990) {
                return 2;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 4;
            }
            return longSide / 1280;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale));
    }
}

