/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.luck.lib.camerax.PictureCameraActivity;
import com.luck.lib.camerax.permissions.PermissionResultCallback;
import com.luck.lib.camerax.permissions.SimpleXPermissionUtil;
import java.util.ArrayList;
import java.util.List;

public class PermissionChecker {
    public static final int PERMISSION_SETTING_CODE = 1102;
    public static final int PERMISSION_RECORD_AUDIO_SETTING_CODE = 1103;
    private static final int REQUEST_CODE = 10086;
    private static PermissionChecker mInstance;

    private PermissionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermissionChecker getInstance() {
        if (mInstance != null) return mInstance;
        Class<PermissionChecker> clazz = PermissionChecker.class;
        synchronized (PermissionChecker.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PermissionChecker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void requestPermissions(Activity activity, String[] permissionArray, PermissionResultCallback callback) {
        ArrayList<String[]> groupList = new ArrayList<String[]>();
        groupList.add(permissionArray);
        this.requestPermissions(activity, groupList, 10086, callback);
    }

    public void requestPermissions(Activity activity, List<String[]> permissionGroupList, PermissionResultCallback callback) {
        this.requestPermissions(activity, permissionGroupList, 10086, callback);
    }

    private void requestPermissions(Activity activity, List<String[]> permissionGroupList, int requestCode, PermissionResultCallback permissionResultCallback) {
        if (activity instanceof PictureCameraActivity) {
            if (Build.VERSION.SDK_INT < 23) {
                if (permissionResultCallback != null) {
                    permissionResultCallback.onGranted();
                }
                return;
            }
            ArrayList<String> permissionList = new ArrayList<String>();
            for (String[] permissionArray : permissionGroupList) {
                for (String permission2 : permissionArray) {
                    if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) == 0) continue;
                    permissionList.add(permission2);
                }
            }
            if (permissionList.size() > 0) {
                ((PictureCameraActivity)activity).setPermissionsResultAction(permissionResultCallback);
                String[] requestArray = new String[permissionList.size()];
                permissionList.toArray(requestArray);
                ActivityCompat.requestPermissions((Activity)activity, (String[])requestArray, (int)requestCode);
            } else if (permissionResultCallback != null) {
                permissionResultCallback.onGranted();
            }
        }
    }

    public void onRequestPermissionsResult(int[] grantResults, PermissionResultCallback action) {
        if (SimpleXPermissionUtil.isAllGranted(grantResults)) {
            action.onGranted();
        } else {
            action.onDenied();
        }
    }

    public static boolean checkSelfPermission(Context ctx, String[] permissions) {
        boolean isAllGranted = true;
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)ctx.getApplicationContext(), (String)permission2) == 0) continue;
            isAllGranted = false;
            break;
        }
        return isAllGranted;
    }
}

