/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.luck.lib.camerax.CameraImageEngine;
import com.luck.lib.camerax.CustomCameraConfig;
import com.luck.lib.camerax.PictureCameraActivity;
import com.luck.lib.camerax.listener.OnSimpleXPermissionDeniedListener;
import com.luck.lib.camerax.listener.OnSimpleXPermissionDescriptionListener;
import com.luck.lib.camerax.utils.FileUtils;

public class SimpleCameraX {
    private static final String EXTRA_PREFIX = "com.luck.lib.camerax";
    public static final String EXTRA_OUTPUT_PATH_DIR = "com.luck.lib.camerax.OutputPathDir";
    public static final String EXTRA_CAMERA_FILE_NAME = "com.luck.lib.camerax.CameraFileName";
    public static final String EXTRA_CAMERA_MODE = "com.luck.lib.camerax.CameraMode";
    public static final String EXTRA_VIDEO_FRAME_RATE = "com.luck.lib.camerax.VideoFrameRate";
    public static final String EXTRA_VIDEO_BIT_RATE = "com.luck.lib.camerax.VideoBitRate";
    public static final String EXTRA_CAMERA_AROUND_STATE = "com.luck.lib.camerax.CameraAroundState";
    public static final String EXTRA_RECORD_VIDEO_MAX_SECOND = "com.luck.lib.camerax.RecordVideoMaxSecond";
    public static final String EXTRA_RECORD_VIDEO_MIN_SECOND = "com.luck.lib.camerax.RecordVideoMinSecond";
    public static final String EXTRA_CAMERA_IMAGE_FORMAT = "com.luck.lib.camerax.CameraImageFormat";
    public static final String EXTRA_CAMERA_IMAGE_FORMAT_FOR_Q = "com.luck.lib.camerax.CameraImageFormatForQ";
    public static final String EXTRA_CAMERA_VIDEO_FORMAT = "com.luck.lib.camerax.CameraVideoFormat";
    public static final String EXTRA_CAMERA_VIDEO_FORMAT_FOR_Q = "com.luck.lib.camerax.CameraVideoFormatForQ";
    public static final String EXTRA_CAPTURE_LOADING_COLOR = "com.luck.lib.camerax.CaptureLoadingColor";
    public static final String EXTRA_DISPLAY_RECORD_CHANGE_TIME = "com.luck.lib.camerax.DisplayRecordChangeTime";
    public static final String EXTRA_MANUAL_FOCUS = "com.luck.lib.camerax.isManualFocus";
    public static final String EXTRA_ZOOM_PREVIEW = "com.luck.lib.camerax.isZoomPreview";
    public static final String EXTRA_AUTO_ROTATION = "com.luck.lib.camerax.isAutoRotation";
    private final Intent mCameraIntent = new Intent();
    private final Bundle mCameraBundle = new Bundle();

    public static SimpleCameraX of() {
        return new SimpleCameraX();
    }

    private SimpleCameraX() {
    }

    public void start(@NonNull Activity activity, int requestCode) {
        if (CustomCameraConfig.imageEngine == null) {
            throw new NullPointerException("Missing ImageEngine,please implement SimpleCamerax.setImageEngine");
        }
        activity.startActivityForResult(this.getIntent((Context)activity), requestCode);
    }

    public void start(@NonNull Context context, @NonNull Fragment fragment, int requestCode) {
        if (CustomCameraConfig.imageEngine == null) {
            throw new NullPointerException("Missing ImageEngine,please implement SimpleCamerax.setImageEngine");
        }
        fragment.startActivityForResult(this.getIntent(context), requestCode);
    }

    public Intent getIntent(@NonNull Context context) {
        this.mCameraIntent.setClass(context, PictureCameraActivity.class);
        this.mCameraIntent.putExtras(this.mCameraBundle);
        return this.mCameraIntent;
    }

    public SimpleCameraX setImageEngine(CameraImageEngine engine) {
        CustomCameraConfig.imageEngine = engine;
        return this;
    }

    public SimpleCameraX setPermissionDescriptionListener(OnSimpleXPermissionDescriptionListener explainListener) {
        CustomCameraConfig.explainListener = explainListener;
        return this;
    }

    public SimpleCameraX setPermissionDeniedListener(OnSimpleXPermissionDeniedListener deniedListener) {
        CustomCameraConfig.deniedListener = deniedListener;
        return this;
    }

    public SimpleCameraX setCameraMode(int cameraMode) {
        this.mCameraBundle.putInt(EXTRA_CAMERA_MODE, cameraMode);
        return this;
    }

    public SimpleCameraX setVideoFrameRate(int videoFrameRate) {
        this.mCameraBundle.putInt(EXTRA_VIDEO_FRAME_RATE, videoFrameRate);
        return this;
    }

    public SimpleCameraX setVideoBitRate(int bitRate) {
        this.mCameraBundle.putInt(EXTRA_VIDEO_BIT_RATE, bitRate);
        return this;
    }

    public SimpleCameraX setCameraAroundState(boolean isCameraAroundState) {
        this.mCameraBundle.putBoolean(EXTRA_CAMERA_AROUND_STATE, isCameraAroundState);
        return this;
    }

    public SimpleCameraX setOutputPathDir(String outputPath) {
        this.mCameraBundle.putString(EXTRA_OUTPUT_PATH_DIR, outputPath);
        return this;
    }

    public SimpleCameraX setCameraOutputFileName(String fileName) {
        this.mCameraBundle.putString(EXTRA_CAMERA_FILE_NAME, fileName);
        return this;
    }

    public SimpleCameraX setRecordVideoMaxSecond(int maxSecond) {
        this.mCameraBundle.putInt(EXTRA_RECORD_VIDEO_MAX_SECOND, maxSecond * 1000 + 500);
        return this;
    }

    public SimpleCameraX setRecordVideoMinSecond(int minSecond) {
        this.mCameraBundle.putInt(EXTRA_RECORD_VIDEO_MIN_SECOND, minSecond * 1000);
        return this;
    }

    public SimpleCameraX setCameraImageFormat(String format) {
        this.mCameraBundle.putString(EXTRA_CAMERA_IMAGE_FORMAT, format);
        return this;
    }

    public SimpleCameraX setCameraImageFormatForQ(String format) {
        this.mCameraBundle.putString(EXTRA_CAMERA_IMAGE_FORMAT_FOR_Q, format);
        return this;
    }

    public SimpleCameraX setCameraVideoFormat(String format) {
        this.mCameraBundle.putString(EXTRA_CAMERA_VIDEO_FORMAT, format);
        return this;
    }

    public SimpleCameraX setCameraVideoFormatForQ(String format) {
        this.mCameraBundle.putString(EXTRA_CAMERA_VIDEO_FORMAT_FOR_Q, format);
        return this;
    }

    public SimpleCameraX setCaptureLoadingColor(int color2) {
        this.mCameraBundle.putInt(EXTRA_CAPTURE_LOADING_COLOR, color2);
        return this;
    }

    public SimpleCameraX isDisplayRecordChangeTime(boolean isDisplayRecordTime) {
        this.mCameraBundle.putBoolean(EXTRA_DISPLAY_RECORD_CHANGE_TIME, isDisplayRecordTime);
        return this;
    }

    public SimpleCameraX isManualFocusCameraPreview(boolean isManualFocus) {
        this.mCameraBundle.putBoolean(EXTRA_MANUAL_FOCUS, isManualFocus);
        return this;
    }

    public SimpleCameraX isZoomCameraPreview(boolean isZoom) {
        this.mCameraBundle.putBoolean(EXTRA_ZOOM_PREVIEW, isZoom);
        return this;
    }

    public SimpleCameraX isAutoRotation(boolean isAutoRotation) {
        this.mCameraBundle.putBoolean(EXTRA_AUTO_ROTATION, isAutoRotation);
        return this;
    }

    public static void putOutputUri(Intent intent, Uri uri) {
        intent.putExtra("output", (Parcelable)uri);
    }

    public static String getOutputPath(Intent intent) {
        Uri uri = (Uri)intent.getParcelableExtra("output");
        if (uri == null) {
            return "";
        }
        return FileUtils.isContent(uri.toString()) ? uri.toString() : uri.getPath();
    }
}

