/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import io.grpc.ServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.OnGrpcServerEnabled;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={NettyServerBuilder.class})
public class ShadedNettyConfiguration {
    @Bean
    @OnGrpcServerEnabled
    public ServerBuilder<?> nettyServerBuilder(GRpcServerProperties grpcServerProperties) {
        return Optional.ofNullable(grpcServerProperties.getNettyServer()).map(n -> {
            NettyServerBuilder builder = Optional.ofNullable(n.getPrimaryListenAddress()).map(NettyServerBuilder::forAddress).orElse(NettyServerBuilder.forPort((int)grpcServerProperties.getPortOrDefault()));
            Optional.ofNullable(n.getAdditionalListenAddresses()).ifPresent(l -> l.forEach(arg_0 -> ((NettyServerBuilder)builder).addListenAddress(arg_0)));
            Optional.ofNullable(n.getFlowControlWindow()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).flowControlWindow(arg_0));
            Optional.ofNullable(n.getInitialFlowControlWindow()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).initialFlowControlWindow(arg_0));
            Optional.ofNullable(n.getKeepAliveTime()).ifPresent(t -> builder.keepAliveTime(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getKeepAliveTimeout()).ifPresent(t -> builder.keepAliveTimeout(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getPermitKeepAliveTime()).ifPresent(t -> builder.permitKeepAliveTime(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConnectionAge()).ifPresent(t -> builder.maxConnectionAge(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConnectionAgeGrace()).ifPresent(t -> builder.maxConnectionAgeGrace(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConnectionIdle()).ifPresent(t -> builder.maxConnectionIdle(t.toMillis(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(n.getMaxConcurrentCallsPerConnection()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).maxConcurrentCallsPerConnection(arg_0));
            Optional.ofNullable(n.getPermitKeepAliveWithoutCalls()).ifPresent(arg_0 -> ((NettyServerBuilder)builder).permitKeepAliveWithoutCalls(arg_0));
            Optional.ofNullable(n.getMaxInboundMessageSize()).ifPresent(s -> builder.maxInboundMessageSize((int)s.toBytes()));
            Optional.ofNullable(n.getMaxInboundMetadataSize()).ifPresent(s -> builder.maxInboundMetadataSize((int)s.toBytes()));
            return builder;
        }).orElse(ServerBuilder.forPort((int)grpcServerProperties.getPortOrDefault()));
    }
}

