/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.services.HealthStatusManager;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcServerBuilderConfigurer;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.type.StandardMethodMetadata;

public class GRpcServerRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerRunner.class);
    @Autowired
    private HealthStatusManager healthStatusManager;
    @Autowired
    private AbstractApplicationContext applicationContext;
    @Autowired
    private GRpcServerProperties gRpcServerProperties;
    private GRpcServerBuilderConfigurer configurer;
    private Server server;
    private final ServerBuilder<?> serverBuilder;

    public GRpcServerRunner(GRpcServerBuilderConfigurer configurer, ServerBuilder<?> serverBuilder) {
        this.configurer = configurer;
        this.serverBuilder = serverBuilder;
    }

    public void run(String ... args) throws Exception {
        log.info("Starting gRPC Server ...");
        Collection globalInterceptors = this.getBeanNamesByTypeWithAnnotation(GRpcGlobalInterceptor.class, ServerInterceptor.class).map(name -> (ServerInterceptor)this.applicationContext.getBeanFactory().getBean(name, ServerInterceptor.class)).collect(Collectors.toList());
        this.serverBuilder.addService(this.healthStatusManager.getHealthService());
        this.getBeanNamesByTypeWithAnnotation(GRpcService.class, BindableService.class).forEach(name -> {
            BindableService srv = (BindableService)this.applicationContext.getBeanFactory().getBean(name, BindableService.class);
            ServerServiceDefinition serviceDefinition = srv.bindService();
            GRpcService gRpcServiceAnn = (GRpcService)this.applicationContext.findAnnotationOnBean(name, GRpcService.class);
            serviceDefinition = this.bindInterceptors(serviceDefinition, gRpcServiceAnn, globalInterceptors);
            this.serverBuilder.addService(serviceDefinition);
            String serviceName = serviceDefinition.getServiceDescriptor().getName();
            this.healthStatusManager.setStatus(serviceName, HealthCheckResponse.ServingStatus.SERVING);
            log.info("'{}' service has been registered.", (Object)srv.getClass().getName());
        });
        this.configurer.configure(this.serverBuilder);
        this.server = this.serverBuilder.build().start();
        log.info("gRPC Server started, listening on port {}.", (Object)this.server.getPort());
        this.startDaemonAwaitThread();
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GRpcService gRpcService, Collection<ServerInterceptor> globalInterceptors) {
        Stream<ServerInterceptor> privateInterceptors = Stream.of(gRpcService.interceptors()).map(interceptorClass -> {
            try {
                return 0 < this.applicationContext.getBeanNamesForType(interceptorClass).length ? (ServerInterceptor)this.applicationContext.getBean(interceptorClass) : (ServerInterceptor)interceptorClass.newInstance();
            }
            catch (Exception e) {
                throw new BeanCreationException("Failed to create interceptor instance.", (Throwable)e);
            }
        });
        List interceptors = Stream.concat(gRpcService.applyGlobalInterceptors() ? globalInterceptors.stream() : Stream.empty(), privateInterceptors).distinct().collect(Collectors.toList());
        interceptors.sort(AnnotationAwareOrderComparator.INSTANCE);
        Collections.reverse(interceptors);
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, interceptors);
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread(() -> {
            try {
                this.server.awaitTermination();
            }
            catch (InterruptedException e) {
                log.error("gRPC server stopped.", (Throwable)e);
            }
        });
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    public void destroy() throws Exception {
        log.info("Shutting down gRPC server ...");
        this.server.getServices().forEach(def -> this.healthStatusManager.clearStatus(def.getServiceDescriptor().getName()));
        Optional.ofNullable(this.server).ifPresent(Server::shutdown);
        log.info("gRPC server stopped.");
    }

    private <T> Stream<String> getBeanNamesByTypeWithAnnotation(Class<? extends Annotation> annotationType, Class<T> beanType) throws Exception {
        return Stream.of(this.applicationContext.getBeanNamesForType(beanType)).filter(name -> {
            BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(name);
            Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(annotationType);
            if (!beansWithAnnotation.isEmpty()) {
                return beansWithAnnotation.containsKey(name);
            }
            if (beanDefinition.getSource() instanceof StandardMethodMetadata) {
                StandardMethodMetadata metadata = (StandardMethodMetadata)beanDefinition.getSource();
                return metadata.isAnnotated(annotationType.getName());
            }
            return false;
        });
    }
}

