/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.socket;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.Streams;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class UdpSend
implements AutoCloseable {
    private final String host;
    private final int port;
    private final InetAddress inetAddress;
    private final DatagramSocket ds;

    public UdpSend(String host, int port) {
        this.host = host;
        this.port = port;
        try {
            this.ds = new DatagramSocket();
            this.inetAddress = InetAddress.getByName(host);
            this.ds.setSendBufferSize(4096);
            this.ds.setSoTimeout(10000);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public UdpSend bufferSize(int bufferSize) throws SocketException {
        this.ds.setSendBufferSize(bufferSize);
        return this;
    }

    public UdpSend timeout(int timeOut) throws SocketException {
        this.ds.setSoTimeout(timeOut);
        return this;
    }

    public UdpSend send(byte[] bs) throws IOException {
        DatagramPacket dp = new DatagramPacket(bs, bs.length, this.inetAddress, this.port);
        this.ds.send(dp);
        return this;
    }

    public UdpSend send(byte[] bs, int len) throws IOException {
        DatagramPacket dp = new DatagramPacket(bs, len, this.inetAddress, this.port);
        this.ds.send(dp);
        return this;
    }

    public UdpSend send(byte[] bs, int off, int len) throws IOException {
        DatagramPacket dp = new DatagramPacket(bs, off, len, this.inetAddress, this.port);
        this.ds.send(dp);
        return this;
    }

    public UdpSend sendLf() throws IOException {
        DatagramPacket dp = new DatagramPacket("\n".getBytes(), 1, this.inetAddress, this.port);
        this.ds.send(dp);
        return this;
    }

    @Override
    public void close() {
        Streams.close((AutoCloseable)this.ds);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public DatagramSocket getDatagramSocket() {
        return this.ds;
    }
}

