/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection.ssh;

import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.orion.lang.utils.Exceptions;
import com.orion.net.base.ssh.BaseShellExecutor;
import java.io.IOException;

public class ShellExecutor
extends BaseShellExecutor {
    protected final Session session;

    public ShellExecutor(Session session) {
        this.session = session;
    }

    @Override
    public void x11Forward(boolean enable) {
        throw Exceptions.unsupported((String)"unsupported x11 forwarding");
    }

    @Override
    public void resize() {
        try {
            this.session.requestWindowChange(this.cols, this.rows, this.width, this.height);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public void exec() {
        if (this.streamHandler == null) {
            throw Exceptions.runtime((String)"shell std output stream handler is null");
        }
        if (this.run) {
            throw Exceptions.runtime((String)"shell executor can only be executed once");
        }
        this.run = true;
        try {
            this.session.requestPTY(this.terminalType, this.cols, this.rows, this.width, this.height, null);
            this.session.startShell();
        }
        catch (IOException e) {
            throw Exceptions.connection((Throwable)e);
        }
        this.outputStream = this.session.getStdin();
        this.inputStream = new StreamGobbler(this.session.getStdout());
        super.listenerStdout();
    }

    @Override
    public void close() {
        super.close();
        this.session.close();
    }

    public Session getSession() {
        return this.session;
    }
}

