/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection.ssh;

import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.orion.lang.utils.Exceptions;
import com.orion.net.base.ssh.BaseCommandExecutor;
import java.io.IOException;
import java.io.SequenceInputStream;

public class CommandExecutor
extends BaseCommandExecutor {
    protected final Session session;
    private final String command;
    private final String commandCharset;
    private int waitFor;
    private long waitTime;

    public CommandExecutor(Session session, String command) {
        this(session, command, "UTF-8");
    }

    public CommandExecutor(Session session, String command, String commandCharset) {
        this.session = session;
        this.command = command;
        this.commandCharset = commandCharset;
    }

    @Override
    public void pty(boolean use) {
        if (!use) {
            return;
        }
        try {
            this.session.requestDumbPTY();
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((String)"set pty type error", (Throwable)e);
        }
    }

    public void waitFor() {
        this.waitFor = 50;
    }

    public void waitFor(int type) {
        this.waitFor = type;
    }

    public void waitFor(int type, long timeout) {
        this.waitFor = type;
        this.waitTime = timeout;
    }

    public void timeout(long timeout) {
        this.waitFor = 50;
        this.waitTime = timeout;
    }

    public void exec() {
        if (this.streamHandler == null) {
            throw Exceptions.runtime((String)"command std output stream handler is null");
        }
        if (this.run) {
            throw Exceptions.runtime((String)"this executor can only be executed once");
        }
        this.run = true;
        try {
            if (this.commandCharset != null) {
                this.session.execCommand(this.command, this.commandCharset);
            } else {
                this.session.execCommand(this.command);
            }
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)"execute command error", (Throwable)e);
        }
        this.inputStream = new StreamGobbler(this.session.getStdout());
        this.errorStream = new StreamGobbler(this.session.getStderr());
        this.outputStream = this.session.getStdin();
        if (this.inherit) {
            this.inheritStream = new SequenceInputStream(this.inputStream, this.errorStream);
        }
        this.listenerStdoutAndError();
        try {
            if (this.waitFor != 0) {
                this.session.waitForCondition(this.waitFor, this.waitTime);
                this.done = true;
            }
        }
        catch (IOException e) {
            throw Exceptions.timeout((Throwable)e);
        }
    }

    @Override
    public void close() {
        super.close();
        this.session.close();
    }

    @Override
    public int getExitCode() {
        return this.session.getExitStatus();
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public int getWaitFor() {
        return this.waitFor;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public Session getSession() {
        return this.session;
    }

    public String toString() {
        return "[" + this.command + "]";
    }
}

