/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection.sftp;

import ch.ethz.ssh2.SFTPv3FileHandle;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.sftp.SftpFile;
import com.orion.net.base.file.transfer.BaseFileUploader;
import com.orion.net.remote.connection.sftp.SftpExecutor;
import java.io.File;
import java.io.IOException;

public class SftpUploader
extends BaseFileUploader {
    private static final String LOCK_SUFFIX = "osu";
    private final SftpExecutor executor;
    private SFTPv3FileHandle handle;
    private long current;

    public SftpUploader(SftpExecutor executor, String remote, String local) {
        this(executor, remote, new File(local));
    }

    public SftpUploader(SftpExecutor executor, String remote, File local) {
        super(remote, local, LOCK_SUFFIX, 32768);
        Valid.notNull((Object)executor, (String)"sftp executor is null", (Object[])new Object[0]);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SftpExecutor sftpExecutor = this.executor;
            synchronized (sftpExecutor) {
                super.startUpload();
            }
        }
        catch (IOException e) {
            throw Exceptions.sftp((String)("sftp upload exception local file: " + this.local.getAbsolutePath() + " -> remote file: " + this.remote), (Throwable)e);
        }
    }

    @Override
    protected long getFileSize() {
        SftpFile remoteFile = this.executor.getFile(this.remote);
        if (remoteFile == null) {
            try {
                this.executor.touchTruncate(this.remote);
                return -1L;
            }
            catch (Exception e) {
                throw Exceptions.sftp((String)("touch remote file error > " + this.remote), (Throwable)e);
            }
        }
        return remoteFile.getSize();
    }

    @Override
    protected void initUpload(boolean breakPoint, long skip) {
        if (breakPoint) {
            this.current += skip;
            this.handle = this.executor.openFileHandler(this.remote, 3);
        } else {
            this.handle = this.executor.openFileHandler(this.remote, 2);
        }
    }

    @Override
    protected void write(byte[] bs, int len) throws IOException {
        this.executor.write(this.handle, this.current, bs, 0, len);
        this.current += (long)len;
    }

    @Override
    protected void transferFinish() {
        this.close();
    }

    public void close() {
        if (this.handle != null) {
            this.executor.closeFile(this.handle);
        }
    }

    @Override
    public void abort() {
        Streams.close((AutoCloseable)((Object)this.executor));
    }

    public SftpExecutor getExecutor() {
        return this.executor;
    }
}

