/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection.sftp;

import ch.ethz.ssh2.SFTPv3FileAttributes;
import com.orion.lang.utils.io.FileType;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.time.Dates;
import com.orion.net.base.file.sftp.SftpFile;
import java.util.Date;

public class SftpFileWrapper
extends SftpFile {
    private final SFTPv3FileAttributes attrs;

    protected SftpFileWrapper(String path, SFTPv3FileAttributes attrs) {
        this.path = path;
        this.attrs = attrs;
        this.accessTime = Dates.date((Object)attrs.atime);
        this.modifyTime = Dates.date((Object)attrs.mtime);
        this.size = attrs.size;
        this.uid = attrs.uid;
        this.gid = attrs.gid;
        this.permission = Files1.permission8to10((int)(attrs.permissions & 0xFFF));
        String permissionString = Files1.permission10toString((int)this.permission);
        permissionString = attrs.isDirectory() ? FileType.DIRECTORY.getSymbol() + permissionString : (attrs.isSymlink() ? FileType.SYMLINK.getSymbol() + permissionString : FileType.REGULAR_FILE.getSymbol() + permissionString);
        this.permissionString = permissionString;
    }

    public SFTPv3FileAttributes getAttrs() {
        return this.attrs;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
        this.attrs.size = size;
    }

    @Override
    public void setUid(int uid) {
        this.uid = uid;
        this.attrs.uid = uid;
    }

    @Override
    public void setGid(int gid) {
        this.gid = gid;
        this.attrs.gid = gid;
    }

    @Override
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
        this.attrs.mtime = (int)(modifyTime.getTime() / 1000L);
    }

    @Override
    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
        this.attrs.atime = (int)(accessTime.getTime() / 1000L);
    }

    @Override
    public void setPermission(int permission) {
        this.permission = permission;
        this.attrs.permissions = Files1.permission10to8((int)permission);
    }
}

