/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection.sftp;

import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.SFTPv3FileAttributes;
import ch.ethz.ssh2.SFTPv3FileHandle;
import com.orion.lang.define.StreamEntry;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.collect.Lists;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.sftp.BaseSftpExecutor;
import com.orion.net.base.file.sftp.SftpErrorMessage;
import com.orion.net.base.file.sftp.SftpFile;
import com.orion.net.remote.connection.sftp.SftpDownloader;
import com.orion.net.remote.connection.sftp.SftpFileWrapper;
import com.orion.net.remote.connection.sftp.SftpUploader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SftpExecutor
extends BaseSftpExecutor {
    private static final Integer DEFAULT_PERMISSIONS = Files1.permission10to8((int)644);
    private final SFTPv3Client client;

    public SftpExecutor(SFTPv3Client client) {
        this(client, "UTF-8");
    }

    public SftpExecutor(SFTPv3Client client, String charset) {
        this.client = client;
        this.charset = charset;
        try {
            client.setCharset(charset);
        }
        catch (IOException e) {
            throw Exceptions.unsupportedEncoding((Throwable)e);
        }
    }

    @Override
    public void bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void charset(String charset) {
        try {
            this.client.setCharset(charset);
            this.charset = charset;
        }
        catch (IOException e) {
            throw Exceptions.unsupportedEncoding((Throwable)e);
        }
    }

    public void requestParallelism(int parallelism) {
        this.client.setRequestParallelism(parallelism);
    }

    @Override
    public boolean isExist(String path) {
        try {
            return this.client.lstat(path) != null;
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return false;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public String getPath(String path) {
        try {
            return this.client.canonicalPath(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return null;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public String getLinkPath(String path) {
        try {
            return this.client.readLink(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return null;
            }
            if (SftpErrorMessage.BAD_MESSAGE.isCause(e)) {
                return null;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public SftpFile getFile(String path) {
        return this.getFile(path, false);
    }

    @Override
    public SftpFile getFile(String path, boolean followSymbolic) {
        try {
            SFTPv3FileAttributes attr = followSymbolic ? this.client.stat(path) : this.client.lstat(path);
            return new SftpFileWrapper(path, attr);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return null;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public long getSize(String path) {
        try {
            SFTPv3FileAttributes attr = this.client.stat(path);
            if (attr == null) {
                return -1L;
            }
            return attr.size;
        }
        catch (IOException e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return -1L;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void setFileAttribute(SftpFile attribute) {
        try {
            this.client.setstat(attribute.getPath(), ((SftpFileWrapper)attribute).getAttrs());
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void setModifyTime(String path, Date date) {
        try {
            SFTPv3FileAttributes attr = this.client.stat(path);
            attr.mtime = (int)(date.getTime() / 1000L);
            this.client.setstat(path, attr);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void chmod(String file, int permission) {
        try {
            SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
            attr.permissions = Files1.permission10to8((int)permission);
            this.client.setstat(file, attr);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void chown(String file, int uid) {
        try {
            SFTPv3FileAttributes attr = this.client.stat(file);
            attr.uid = uid;
            this.client.setstat(file, attr);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void chgrp(String file, int gid) {
        try {
            SFTPv3FileAttributes attr = this.client.stat(file);
            attr.gid = gid;
            this.client.setstat(file, attr);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void truncate(String path) {
        this.touch(path, true);
    }

    @Override
    public void mkdir(String path) {
        this.mkdir(path, DEFAULT_PERMISSIONS);
    }

    public void mkdir(String path, int permissions) {
        try {
            this.client.mkdir(path, permissions);
        }
        catch (IOException e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    public void mkdirs(String path, int permissions) {
        super.doMakeDirs(path, p -> this.mkdir(path, permissions));
    }

    @Override
    public void removeDir(String path) {
        try {
            this.client.rmdir(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void removeFile(String path) {
        try {
            this.client.rm(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void touch(String path) {
        this.touch(path, false);
    }

    @Override
    public void touchTruncate(String path) {
        this.touch(path, true);
    }

    @Override
    public void touch(String path, boolean truncate) {
        try {
            this.mkdirs(Files1.getParentPath((String)path));
            SFTPv3FileHandle handle = truncate ? this.client.createFileTruncate(path) : this.client.createFile(path);
            this.closeFile(handle);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void touchLink(String source, String target) {
        try {
            if (!this.isSameParentPath(source, target)) {
                this.mkdirs(Files1.getParentPath((String)target));
            }
            this.client.createSymlink(target, source);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    protected void doMove(String source, String target) {
        try {
            this.client.mv(source, target);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    public SFTPv3FileHandle openReadFileHandler(String path) {
        return this.openFileHandler(path, 1);
    }

    public SFTPv3FileHandle openWriteFileHandler(String path) {
        return this.openFileHandler(path, 2);
    }

    public SFTPv3FileHandle openWriteAppendFileHandler(String path) {
        return this.openFileHandler(path, 3);
    }

    public SFTPv3FileHandle openReadWriteAppendFileHandler(String path) {
        return this.openFileHandler(path, 4);
    }

    public SFTPv3FileHandle openFileHandler(String path, int type) {
        try {
            this.mkdirs(Files1.getParentPath((String)path));
            switch (type) {
                case 1: {
                    return this.client.openFileRO(path);
                }
                case 2: {
                    return this.client.openFileRW(path);
                }
                case 3: {
                    return this.client.openFileWAppend(path);
                }
                case 4: {
                    return this.client.openFileRWAppend(path);
                }
            }
            throw Exceptions.argument((String)("type " + type + " is unsupported"));
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    public boolean closeFile(SFTPv3FileHandle handle) {
        if (handle == null) {
            return true;
        }
        try {
            handle.getClient().closeFile(handle);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int read(SFTPv3FileHandle handle, byte[] bs) throws IOException {
        return this.read(handle, 0L, bs, 0, bs.length);
    }

    public int read(SFTPv3FileHandle handle, long skip, byte[] bs) throws IOException {
        return this.read(handle, skip, bs, 0, bs.length);
    }

    public int read(SFTPv3FileHandle handle, byte[] bs, int offset, int len) throws IOException {
        return this.read(handle, 0L, bs, offset, len);
    }

    public int read(SFTPv3FileHandle handle, long skip, byte[] bs, int offset, int len) throws IOException {
        return this.client.read(handle, skip, bs, offset, len);
    }

    @Override
    public int read(String path, long skip, byte[] bs, int offset, int len) throws IOException {
        SFTPv3FileHandle handle = null;
        try {
            handle = this.client.openFileRO(path);
            int n = this.read(handle, skip, bs, offset, len);
            return n;
        }
        catch (Exception e) {
            throw Exceptions.io((String)("cannot read file " + path), (Throwable)e);
        }
        finally {
            this.closeFile(handle);
        }
    }

    @Override
    protected long doTransfer(String path, OutputStream out, long skip, int size, boolean close) throws IOException {
        if (size != -1 && size <= 0) {
            throw Exceptions.runtime((String)"read size must > 0 or -1");
        }
        SFTPv3FileHandle handle = null;
        try {
            handle = this.client.openFileRO(path);
            long l = this.transfer(handle, out, skip, size, close);
            return l;
        }
        catch (Exception e) {
            throw Exceptions.io((String)("cannot read file " + path), (Throwable)e);
        }
        finally {
            this.closeFile(handle);
        }
    }

    public long transfer(SFTPv3FileHandle handle, String file) throws IOException {
        Files1.touch((String)file);
        return this.transfer(handle, Files1.openOutputStream((String)file), 0L, -1, true);
    }

    public long transfer(SFTPv3FileHandle handle, File file) throws IOException {
        Files1.touch((File)file);
        return this.transfer(handle, Files1.openOutputStream((File)file), 0L, -1, true);
    }

    public long transfer(SFTPv3FileHandle handle, OutputStream out) throws IOException {
        return this.transfer(handle, out, 0L, -1, false);
    }

    public long transfer(SFTPv3FileHandle handle, OutputStream out, long skip) throws IOException {
        return this.transfer(handle, out, skip, -1, false);
    }

    public long transfer(SFTPv3FileHandle handle, OutputStream out, long skip, int size) throws IOException {
        return this.transfer(handle, out, skip, size, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transfer(SFTPv3FileHandle handle, OutputStream out, long skip, int size, boolean close) throws IOException {
        if (size != -1 && size <= 0) {
            throw Exceptions.runtime((String)"read size must > 0 or -1");
        }
        try {
            long total = 0L;
            long curr = skip;
            byte[] bs = new byte[this.bufferSize];
            if (size != -1) {
                int read;
                int last = size % this.bufferSize;
                long readTimes = Long.max(size / this.bufferSize, 1L);
                if (last == 0) {
                    ++readTimes;
                }
                for (long i = 0L; i < readTimes && (read = i == readTimes - 1L ? this.client.read(handle, curr, bs, 0, last) : this.client.read(handle, curr, bs, 0, this.bufferSize)) != -1; ++i) {
                    out.write(bs, 0, read);
                    total += (long)read;
                    curr += (long)read;
                }
            } else {
                int read;
                while ((read = this.client.read(handle, curr, bs, 0, this.bufferSize)) != -1) {
                    out.write(bs, 0, read);
                    total += (long)read;
                    curr += (long)read;
                }
            }
            long l = total;
            return l;
        }
        finally {
            if (close) {
                Streams.close((AutoCloseable)out);
            }
        }
    }

    @Override
    protected void doWrite(String path, InputStream in, StreamEntry entry, List<String> lines) throws IOException {
        this.write(path, 0L, in, entry, lines, 1);
    }

    @Override
    protected void doAppend(String path, InputStream in, StreamEntry entry, List<String> lines) throws IOException {
        this.write(path, 0L, in, entry, lines, 3);
    }

    public void override(String path, InputStream in) throws IOException {
        this.write(path, 0L, in, null, null, 2);
    }

    public void override(String path, long fileOffset, InputStream in) throws IOException {
        this.write(path, fileOffset, in, null, null, 2);
    }

    public void override(String path, byte[] bs) throws IOException {
        this.write(path, 0L, null, new StreamEntry(bs), null, 2);
    }

    public void override(String path, byte[] bs, int off, int len) throws IOException {
        this.write(path, 0L, null, new StreamEntry(bs, off, len), null, 2);
    }

    public void override(String path, long fileOffset, byte[] bs) throws IOException {
        this.write(path, fileOffset, null, new StreamEntry(bs), null, 2);
    }

    public void override(String path, long fileOffset, byte[] bs, int off, int len) throws IOException {
        this.write(path, fileOffset, null, new StreamEntry(bs, off, len), null, 2);
    }

    public void overrideLine(String path, String line) throws IOException {
        this.write(path, 0L, null, null, Lists.singleton((Object)line), 2);
    }

    public void overrideLine(String path, long fileOffset, String line) throws IOException {
        this.write(path, fileOffset, null, null, Lists.singleton((Object)line), 2);
    }

    public void overrideLines(String path, List<String> lines) throws IOException {
        this.write(path, 0L, null, null, lines, 2);
    }

    public void overrideLines(String path, long fileOffset, List<String> lines) throws IOException {
        this.write(path, fileOffset, null, null, lines, 2);
    }

    private void write(String path, long fileOffset, InputStream in, StreamEntry entry, List<String> lines, int type) throws IOException {
        SFTPv3FileHandle handle = null;
        try {
            this.touch(path, type == 1);
            handle = type == 3 ? this.client.openFileRWAppend(path) : this.client.openFileRW(path);
            this.write(handle, fileOffset, in, entry, lines);
            this.closeFile(handle);
        }
        catch (Exception e) {
            try {
                throw Exceptions.io((String)("cannot write file " + path), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeFile(handle);
                throw throwable;
            }
        }
    }

    public void write(SFTPv3FileHandle handle, InputStream in) throws IOException {
        this.write(handle, 0L, in, null, null);
    }

    public void write(SFTPv3FileHandle handle, long fileOffset, InputStream in) throws IOException {
        this.write(handle, fileOffset, in, null, null);
    }

    public void write(SFTPv3FileHandle handle, byte[] bs) throws IOException {
        this.write(handle, 0L, null, new StreamEntry(bs), null);
    }

    public void write(SFTPv3FileHandle handle, byte[] bs, int off, int len) throws IOException {
        this.write(handle, 0L, null, new StreamEntry(bs, off, len), null);
    }

    public void write(SFTPv3FileHandle handle, long fileOffset, byte[] bs) throws IOException {
        this.write(handle, fileOffset, null, new StreamEntry(bs), null);
    }

    public void write(SFTPv3FileHandle handle, long fileOffset, byte[] bs, int off, int len) throws IOException {
        this.write(handle, fileOffset, null, new StreamEntry(bs, off, len), null);
    }

    public void writeLine(SFTPv3FileHandle handle, String line) throws IOException {
        this.write(handle, 0L, null, null, Lists.singleton((Object)line));
    }

    public void writeLine(SFTPv3FileHandle handle, long fileOffset, String line) throws IOException {
        this.write(handle, fileOffset, null, null, Lists.singleton((Object)line));
    }

    public void writeLines(SFTPv3FileHandle handle, List<String> lines) throws IOException {
        this.write(handle, 0L, null, null, lines);
    }

    public void writeLines(SFTPv3FileHandle handle, long fileOffset, List<String> lines) throws IOException {
        this.write(handle, fileOffset, null, null, lines);
    }

    private void write(SFTPv3FileHandle handle, long fileOffset, InputStream in, StreamEntry entry, List<String> lines) throws IOException {
        block3: {
            block4: {
                block2: {
                    int read;
                    if (in == null) break block2;
                    byte[] bs = new byte[this.bufferSize];
                    while ((read = in.read(bs)) != -1) {
                        this.client.write(handle, fileOffset, bs, 0, read);
                        fileOffset += (long)read;
                    }
                    break block3;
                }
                if (entry == null) break block4;
                this.client.write(handle, fileOffset, entry.getBytes(), entry.getOff(), entry.getLen());
                break block3;
            }
            if (lines == null) break block3;
            for (String line : lines) {
                byte[] bytes = Strings.bytes((String)(line + "\n"), (String)this.charset);
                this.client.write(handle, fileOffset, bytes, 0, bytes.length);
                fileOffset += (long)bytes.length;
            }
        }
    }

    @Override
    public SftpUploader upload(String remote, File local) {
        return new SftpUploader(this, remote, local);
    }

    @Override
    public SftpUploader upload(String remote, String local) {
        return new SftpUploader(this, remote, local);
    }

    @Override
    public SftpDownloader download(String remote, File local) {
        return new SftpDownloader(this, remote, local);
    }

    @Override
    public SftpDownloader download(String remote, String local) {
        return new SftpDownloader(this, remote, local);
    }

    @Override
    public List<SftpFile> ll(String path) {
        try {
            ArrayList<SftpFile> list = new ArrayList<SftpFile>();
            List files = this.client.ls(path);
            for (SFTPv3DirectoryEntry l : files) {
                String filename = l.filename;
                if (".".equals(filename) || "..".equals(filename)) continue;
                list.add(new SftpFileWrapper(Files1.getPath((String)path, (String)filename), l.attributes));
            }
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public int getServerVersion() {
        return this.client.getProtocolVersion();
    }

    public void close() {
        this.client.close();
    }

    public SFTPv3Client getClient() {
        return this.client;
    }
}

