/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection.sftp;

import ch.ethz.ssh2.SFTPv3FileHandle;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.sftp.SftpFile;
import com.orion.net.base.file.transfer.BaseFileDownloader;
import com.orion.net.remote.connection.sftp.SftpExecutor;
import java.io.File;
import java.io.IOException;

public class SftpDownloader
extends BaseFileDownloader {
    private static final String LOCK_SUFFIX = "osd";
    private final SftpExecutor executor;
    private SFTPv3FileHandle handle;
    private long current;

    public SftpDownloader(SftpExecutor executor, String remote, String local) {
        this(executor, remote, new File(local));
    }

    public SftpDownloader(SftpExecutor executor, String remote, File local) {
        super(remote, local, LOCK_SUFFIX, 32768);
        Valid.notNull((Object)executor, (String)"sftp executor is null", (Object[])new Object[0]);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SftpExecutor sftpExecutor = this.executor;
            synchronized (sftpExecutor) {
                super.startDownload();
            }
        }
        catch (IOException e) {
            throw Exceptions.sftp((String)("sftp download exception remote file: " + this.remote + " -> local file: " + this.local.getAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    protected long getFileSize() {
        SftpFile remoteFile = this.executor.getFile(this.remote);
        if (remoteFile == null) {
            throw Exceptions.notFound((String)"not found download remote file");
        }
        return remoteFile.getSize();
    }

    @Override
    protected void initDownload(boolean breakPoint, long skip) {
        this.current += skip;
        this.handle = this.executor.openFileHandler(this.remote, 1);
        if (this.handle == null) {
            throw Exceptions.sftp((String)"unopened remote file stream");
        }
    }

    @Override
    protected int read(byte[] bs) throws IOException {
        int r = this.executor.read(this.handle, this.current, bs);
        if (r != -1) {
            this.current += (long)r;
        }
        return r;
    }

    @Override
    protected void transferFinish() {
        this.close();
    }

    public void close() {
        if (this.handle != null) {
            this.executor.closeFile(this.handle);
        }
    }

    @Override
    public void abort() {
        Streams.close((AutoCloseable)((Object)this.executor));
    }

    public SftpExecutor getExecutor() {
        return this.executor;
    }
}

