/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection.scp;

import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.SCPOutputStream;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScpExecutor {
    private final SCPClient client;

    public ScpExecutor(SCPClient client) {
        this.client = client;
    }

    public boolean downloadFile(String remoteFile, String localDir) {
        return this.downloadFile(remoteFile, new File(Files1.getPath((String)localDir, (String)Files1.getFileName((String)remoteFile))));
    }

    public boolean downloadFile(String remoteFile, File localFile) {
        try {
            Files1.touch((File)localFile);
            this.downloadFile(remoteFile, Files1.openOutputStream((File)localFile), null, true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void downloadFile(String remoteFile, OutputStream out) throws IOException {
        this.downloadFile(remoteFile, out, null, false);
    }

    public void downloadFile(String remoteFile, Writer writer) throws IOException {
        this.downloadFile(remoteFile, null, writer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String remoteFile, OutputStream out, Writer writer, boolean close) throws IOException {
        try (InputStream in = this.getFileInputStream(remoteFile);){
            if (out != null) {
                Streams.transfer((InputStream)in, (OutputStream)out);
            } else {
                Streams.transfer((InputStream)in, (Writer)writer);
            }
        }
        finally {
            if (close) {
                Streams.close((AutoCloseable)out);
                Streams.close((AutoCloseable)writer);
            }
        }
    }

    public Map<String, Boolean> downloadFiles(File localDir, List<String> remoteFiles) {
        return this.downloadFiles(localDir.getAbsolutePath(), remoteFiles);
    }

    public Map<String, Boolean> downloadFiles(String localDir, List<String> remoteFiles) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String remoteFile : remoteFiles) {
            File localFile = new File(Files1.getPath((String)localDir, (String)Files1.getFileName((String)remoteFile)));
            result.put(remoteFile, this.downloadFile(remoteFile, localFile));
        }
        return result;
    }

    public InputStream getFileInputStream(String remoteFile) throws IOException {
        return this.client.get(remoteFile);
    }

    public boolean uploadFile(File localFile, String remoteDir) {
        return this.uploadFile(localFile, remoteDir, null);
    }

    public boolean uploadFile(String localFile, String remoteDir) {
        return this.uploadFile(new File(localFile), remoteDir, null);
    }

    public boolean uploadFile(String localFile, String remoteDir, String remoteFileName) {
        return this.uploadFile(new File(localFile), remoteDir, remoteFileName);
    }

    public boolean uploadFile(File localFile, String remoteDir, String remoteFileName) {
        if (remoteFileName == null) {
            remoteFileName = localFile.getName();
        }
        try {
            this.uploadFile(Files1.openInputStream((File)localFile), localFile.length(), remoteDir, remoteFileName, true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void uploadFile(InputStream in, long len, String remoteDir, String remoteFileName) throws IOException {
        this.uploadFile(in, len, remoteDir, remoteFileName, false);
    }

    public void uploadFile(InputStream in, String remoteDir, String remoteFileName) throws IOException {
        this.uploadFile(in, in.available(), remoteDir, remoteFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(InputStream in, long len, String remoteDir, String remoteFileName, boolean close) throws IOException {
        try (SCPOutputStream out = this.client.put(remoteFileName, len, remoteDir, "0600");){
            Streams.transfer((InputStream)in, (OutputStream)out);
            out.flush();
        }
        finally {
            if (close) {
                Streams.close((AutoCloseable)in);
            }
        }
    }

    public Map<String, Boolean> uploadFilesPath(String remoteDir, List<String> localFiles) {
        return this.uploadFiles(remoteDir, localFiles, null);
    }

    public Map<String, Boolean> uploadFiles(String remoteDir, List<File> localFiles) {
        return this.uploadFiles(remoteDir, null, localFiles);
    }

    private Map<String, Boolean> uploadFiles(String remoteDir, List<String> localFiles, List<File> localFiles1) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (localFiles != null) {
            for (String localFile : localFiles) {
                result.put(localFile, this.uploadFile(new File(localFile), remoteDir));
            }
        } else {
            for (File file : localFiles1) {
                result.put(file.getAbsolutePath(), this.uploadFile(file, remoteDir));
                this.uploadFile(file, remoteDir);
            }
        }
        return result;
    }

    public Map<String, Boolean> uploadFiles(String remoteDir, String localDir) {
        return this.uploadFiles(remoteDir, new File(localDir));
    }

    public Map<String, Boolean> uploadFiles(String remoteDir, File localDir) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List files = Files1.listFiles((File)localDir, (boolean)true);
        String path = localDir.getAbsolutePath();
        for (File file : files) {
            String filePath = file.getAbsolutePath();
            boolean upload = this.uploadFile(file, Files1.getPath((String)remoteDir, (String)filePath.substring(path.length(), filePath.length() - file.getName().length())), file.getName());
            result.put(filePath, upload);
        }
        return result;
    }

    public String getCharset() {
        return this.client.getCharset();
    }

    public void setCharset(String charset) throws IOException {
        this.client.setCharset(charset);
    }

    public SCPClient getClient() {
        return this.client;
    }
}

