/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.connection;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.HTTPProxyData;
import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.log.Logger;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.net.remote.connection.scp.ScpExecutor;
import com.orion.net.remote.connection.sftp.SftpExecutor;
import com.orion.net.remote.connection.ssh.CommandExecutor;
import com.orion.net.remote.connection.ssh.ShellExecutor;
import java.io.File;
import java.io.IOException;

public class ConnectionStore
implements AutoCloseable {
    private final Connection connection;
    private final String host;
    private final int port;
    private boolean auth;
    private final ConnectionInfo info;

    public ConnectionStore(String host) {
        this(host, 22, null);
    }

    public ConnectionStore(String host, int port) {
        this(host, port, null);
    }

    public ConnectionStore(String host, int port, String proxyHost, int proxyPort) {
        this(host, port, new HTTPProxyData(proxyHost, proxyPort));
    }

    public ConnectionStore(String host, int port, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this(host, port, new HTTPProxyData(proxyHost, proxyPort, proxyUser, proxyPassword));
    }

    private ConnectionStore(String host, int port, HTTPProxyData proxy) {
        this.host = host;
        this.port = port;
        this.connection = new Connection(host, port, proxy);
        try {
            this.info = this.connection.connect();
        }
        catch (IOException e) {
            throw Exceptions.connection((Throwable)e);
        }
    }

    public static void enableLogger() {
        Logger.enabled = true;
    }

    public static void disableLogger() {
        Logger.enabled = false;
    }

    public ConnectionStore auth(String username) {
        return this.auth(username, null, null, null);
    }

    public ConnectionStore auth(String username, String password) {
        return this.auth(username, password, null, null);
    }

    public ConnectionStore auth(String username, File pemKeyFile, String password) {
        return this.auth(username, password, pemKeyFile, null);
    }

    public ConnectionStore auth(String username, char[] pemKey, String password) {
        return this.auth(username, password, null, pemKey);
    }

    private ConnectionStore auth(String username, String password, File pemKeyFile, char[] pemKey) {
        try {
            boolean authenticate = password == null ? this.connection.authenticateWithNone(username) : (pemKeyFile != null ? this.connection.authenticateWithPublicKey(username, pemKeyFile, password) : (pemKey != null ? this.connection.authenticateWithPublicKey(username, pemKey, password) : this.connection.authenticateWithPassword(username, password)));
            if (!authenticate) {
                throw Exceptions.authentication((String)("authentication failure username: " + username));
            }
            this.auth = true;
        }
        catch (Exception e) {
            throw Exceptions.authentication((String)"authenticate command is error", (Throwable)e);
        }
        return this;
    }

    public CommandExecutor getCommandExecutor(String command) {
        return this.getCommandExecutor(command, "UTF-8");
    }

    public CommandExecutor getCommandExecutor(String command, String commandCharset) {
        Valid.isTrue((boolean)this.auth, (String)"unauthorized", (Object[])new Object[0]);
        try {
            return new CommandExecutor(this.connection.openSession(), command, commandCharset);
        }
        catch (IOException e) {
            throw Exceptions.connection((String)"could not be open session", (Throwable)e);
        }
    }

    public ShellExecutor getShellExecutor() {
        Valid.isTrue((boolean)this.auth, (String)"unauthorized", (Object[])new Object[0]);
        try {
            return new ShellExecutor(this.connection.openSession());
        }
        catch (IOException e) {
            throw Exceptions.connection((String)"could not be open session", (Throwable)e);
        }
    }

    public SftpExecutor getSftpExecutor() {
        return this.getSftpExecutor("UTF-8");
    }

    public SftpExecutor getSftpExecutor(String charset) {
        Valid.isTrue((boolean)this.auth, (String)"unauthorized", (Object[])new Object[0]);
        try {
            return new SftpExecutor(new SFTPv3Client(this.connection), charset);
        }
        catch (IOException e) {
            throw Exceptions.connection((String)"could not be open sftp client", (Throwable)e);
        }
    }

    public ScpExecutor getScpExecutor() {
        Valid.isTrue((boolean)this.auth, (String)"unauthorized", (Object[])new Object[0]);
        try {
            return new ScpExecutor(this.connection.createSCPClient());
        }
        catch (IOException e) {
            throw Exceptions.connection((String)"could not be open scp client", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isAuth() {
        return this.auth;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ConnectionInfo getInfo() {
        return this.info;
    }
}

