/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.channel.ssh;

import com.jcraft.jsch.ChannelShell;
import com.orion.lang.utils.Exceptions;
import com.orion.net.base.ssh.BaseShellExecutor;
import com.orion.net.remote.channel.ChannelConnector;
import java.io.IOException;

public class ShellExecutor
extends BaseShellExecutor
implements ChannelConnector {
    private final ChannelShell channel;

    public ShellExecutor(ChannelShell channel) {
        this.channel = channel;
        try {
            this.inputStream = channel.getInputStream();
            this.outputStream = channel.getOutputStream();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    @Override
    public void x11Forward(boolean enable) {
        this.channel.setXForwarding(enable);
    }

    @Override
    public void resize() {
        try {
            this.channel.setPtySize(this.cols, this.rows, this.width, this.height);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    @Override
    public void connect() {
        this.channel.setPtyType(this.terminalType, this.cols, this.rows, this.width, this.height);
        try {
            this.channel.connect();
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
    }

    @Override
    public void connect(int timeout) {
        this.channel.setPtyType(this.terminalType, this.cols, this.rows, this.width, this.height);
        try {
            this.channel.connect(timeout);
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
    }

    public void exec() {
        if (this.streamHandler == null) {
            throw Exceptions.runtime((String)"shell std output stream handler is null");
        }
        if (!this.isConnected()) {
            throw Exceptions.runtime((String)"channel is not connected");
        }
        if (this.run) {
            throw Exceptions.runtime((String)"shell executor can only be executed once");
        }
        this.run = true;
        super.listenerStdout();
    }

    @Override
    public void close() {
        super.close();
        this.disconnectChannel();
    }

    public ChannelShell getChannel() {
        return this.channel;
    }
}

