/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.channel.ssh;

import com.jcraft.jsch.ChannelExec;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.net.base.ssh.BaseCommandExecutor;
import com.orion.net.remote.channel.ChannelConnector;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CommandExecutor
extends BaseCommandExecutor
implements ChannelConnector {
    private final ChannelExec channel;
    private final byte[] command;

    public CommandExecutor(ChannelExec channel, String command) {
        this(channel, Strings.bytes((String)command, (Charset)StandardCharsets.UTF_8));
    }

    public CommandExecutor(ChannelExec channel, String command, String charset) {
        this(channel, Strings.bytes((String)command, (String)charset));
    }

    public CommandExecutor(ChannelExec channel, byte[] command) {
        this.channel = channel;
        this.command = command;
        this.channel.setCommand(command);
        try {
            this.inputStream = channel.getInputStream();
            this.errorStream = channel.getErrStream();
            this.outputStream = channel.getOutputStream();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        channel.setPty(true);
    }

    @Override
    public void pty(boolean use) {
        this.channel.setPty(use);
    }

    public void sendSignal(String signal) {
        try {
            this.channel.sendSignal(signal);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    public void env(byte[] key, byte[] value) {
        this.channel.setEnv(key, value);
    }

    public void env(String key, String value) {
        this.channel.setEnv(key, value);
    }

    public void exec() {
        if (this.streamHandler == null) {
            throw Exceptions.runtime((String)"command std out stream handler is null");
        }
        if (!this.isConnected()) {
            throw Exceptions.runtime((String)"channel is not connected");
        }
        if (this.run) {
            throw Exceptions.runtime((String)"this executor can only be executed once");
        }
        this.run = true;
        if (this.inherit) {
            this.inheritStream = new SequenceInputStream(this.inputStream, this.errorStream);
        }
        this.listenerStdoutAndError();
    }

    @Override
    public void close() {
        super.close();
        this.disconnectChannel();
    }

    @Override
    public int getExitCode() {
        return this.channel.getExitStatus();
    }

    public ChannelExec getChannel() {
        return this.channel;
    }

    @Override
    public String getCommand() {
        return new String(this.command, StandardCharsets.UTF_8);
    }

    public byte[] getCommandBytes() {
        return this.command;
    }

    public String toString() {
        return this.command == null ? "[]" : "[" + this.getCommand() + "]";
    }
}

