/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.channel.sftp;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.sftp.SftpFile;
import com.orion.net.base.file.transfer.BaseFileUploader;
import com.orion.net.remote.channel.sftp.SftpExecutor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class SftpUploader
extends BaseFileUploader {
    private static final String LOCK_SUFFIX = "osu";
    private final SftpExecutor executor;
    private OutputStream out;

    public SftpUploader(SftpExecutor executor, String remote, String local) {
        this(executor, remote, new File(local));
    }

    public SftpUploader(SftpExecutor executor, String remote, File local) {
        super(remote, local, LOCK_SUFFIX, 8192);
        Valid.notNull((Object)executor, (String)"sftp executor is null", (Object[])new Object[0]);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SftpExecutor sftpExecutor = this.executor;
            synchronized (sftpExecutor) {
                super.startUpload();
            }
        }
        catch (IOException e) {
            throw Exceptions.sftp((String)("sftp upload exception local file: " + this.local.getAbsolutePath() + " -> remote file: " + this.remote), (Throwable)e);
        }
    }

    @Override
    protected long getFileSize() {
        SftpFile remoteFile = this.executor.getFile(this.remote);
        if (remoteFile == null) {
            try {
                return -1L;
            }
            catch (Exception e) {
                throw Exceptions.sftp((String)("touch remote file error > " + this.remote), (Throwable)e);
            }
        }
        return remoteFile.getSize();
    }

    @Override
    protected void initUpload(boolean breakPoint, long skip) throws IOException {
        this.out = breakPoint ? this.executor.openOutputStreamAppend(this.remote) : this.executor.openOutputStreamWriter(this.remote);
    }

    @Override
    protected void write(byte[] bs, int len) throws IOException {
        this.out.write(bs, 0, len);
    }

    @Override
    protected void transferFinish() {
        this.close();
    }

    public void close() {
        Streams.close((AutoCloseable)this.out);
    }

    @Override
    public void abort() {
        Streams.close((AutoCloseable)((Object)this.executor));
    }

    public SftpExecutor getExecutor() {
        return this.executor;
    }
}

