/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.channel.sftp;

import com.jcraft.jsch.SftpATTRS;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.time.Dates;
import com.orion.net.base.file.sftp.SftpFile;
import java.util.Date;

public class SftpFileWrapper
extends SftpFile {
    private final SftpATTRS attrs;

    protected SftpFileWrapper(String path, SftpATTRS attrs) {
        this.path = path;
        this.attrs = attrs;
        this.accessTime = Dates.date((int)attrs.getATime());
        this.modifyTime = Dates.date((int)attrs.getMTime());
        this.size = attrs.getSize();
        this.uid = attrs.getUId();
        this.gid = attrs.getGId();
        this.permission = Files1.permission8to10((int)(attrs.getPermissions() & 0xFFF));
        this.permissionString = attrs.getPermissionsString();
    }

    public SftpATTRS getAttrs() {
        return this.attrs;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
        this.attrs.setSIZE(size);
    }

    @Override
    public void setUid(int uid) {
        this.uid = uid;
        this.attrs.setUIDGID(uid, this.gid);
    }

    @Override
    public void setGid(int gid) {
        this.gid = gid;
        this.attrs.setUIDGID(this.uid, gid);
    }

    @Override
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
        this.attrs.setACMODTIME((int)(this.accessTime.getTime() / 1000L), (int)(modifyTime.getTime() / 1000L));
    }

    @Override
    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
        this.attrs.setACMODTIME((int)(accessTime.getTime() / 1000L), (int)(this.modifyTime.getTime() / 1000L));
    }

    @Override
    public void setPermission(int permission) {
        this.permission = permission;
        this.attrs.setPERMISSIONS(Files1.permission10to8((int)permission));
    }
}

