/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.channel.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.orion.lang.define.StreamEntry;
import com.orion.lang.utils.Charsets;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.net.base.file.sftp.BaseSftpExecutor;
import com.orion.net.base.file.sftp.SftpErrorMessage;
import com.orion.net.base.file.sftp.SftpFile;
import com.orion.net.remote.channel.ChannelConnector;
import com.orion.net.remote.channel.sftp.SftpDownloader;
import com.orion.net.remote.channel.sftp.SftpFileWrapper;
import com.orion.net.remote.channel.sftp.SftpUploader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class SftpExecutor
extends BaseSftpExecutor
implements ChannelConnector {
    private final ChannelSftp channel;

    public SftpExecutor(ChannelSftp channel) {
        this(channel, "UTF-8");
    }

    public SftpExecutor(ChannelSftp channel, String charset) {
        this.channel = channel;
        this.charset = charset;
    }

    @Override
    public void bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void charset(String charset) {
        try {
            this.channel.setFilenameEncoding(Charsets.of((String)charset));
            this.charset = charset;
        }
        catch (Exception e) {
            throw Exceptions.sftp((String)"set sftp charset error", (Throwable)e);
        }
    }

    @Override
    public boolean isExist(String path) {
        try {
            return this.channel.lstat(path) != null;
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return false;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public String getPath(String path) {
        try {
            return this.channel.realpath(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return null;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public String getLinkPath(String path) {
        try {
            return this.channel.readlink(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return null;
            }
            if (SftpErrorMessage.BAD_MESSAGE.isCause(e)) {
                return null;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public SftpFile getFile(String path) {
        return this.getFile(path, false);
    }

    @Override
    public SftpFile getFile(String path, boolean followSymbolic) {
        try {
            SftpATTRS attr = followSymbolic ? this.channel.stat(path) : this.channel.lstat(path);
            return new SftpFileWrapper(path, attr);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return null;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public long getSize(String path) {
        SftpFile file = this.getFile(path, false);
        if (file == null) {
            return -1L;
        }
        return file.getSize();
    }

    @Override
    public void setFileAttribute(SftpFile attribute) {
        try {
            this.channel.setStat(attribute.getPath(), ((SftpFileWrapper)attribute).getAttrs());
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void setModifyTime(String path, Date date) {
        try {
            this.channel.setMtime(path, (int)(date.getTime() / 1000L));
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void chmod(String file, int permission) {
        try {
            this.channel.chmod(Files1.permission10to8((int)permission), file);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void chown(String file, int uid) {
        try {
            this.channel.chown(uid, file);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void chgrp(String file, int gid) {
        try {
            this.channel.chgrp(gid, file);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void mkdir(String path) {
        try {
            this.channel.mkdir(path);
        }
        catch (SftpException e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void removeDir(String path) {
        try {
            this.channel.rmdir(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void removeFile(String path) {
        try {
            this.channel.rm(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void touch(String path) {
        this.touch(path, false);
    }

    @Override
    public void touchTruncate(String path) {
        this.touch(path, true);
    }

    @Override
    public void touch(String path, boolean truncate) {
        OutputStream out = null;
        try {
            out = truncate ? this.openOutputStream(path, 0) : this.openOutputStream(path, 1);
            out.flush();
        }
        catch (Exception e) {
            try {
                throw Exceptions.sftp((Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.close(out);
                throw throwable;
            }
        }
        Streams.close((AutoCloseable)out);
    }

    @Override
    public void truncate(String path) {
        try {
            this.touchTruncate(path);
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    public void touchHardLink(String source, String target) {
        this.touchLink(source, target, true);
    }

    public void touchSymLink(String source, String target) {
        this.touchLink(source, target, false);
    }

    @Override
    public void touchLink(String source, String target) {
        this.touchLink(source, target, false);
    }

    public void touchLink(String source, String target, boolean hard) {
        try {
            if (!this.isSameParentPath(source, target)) {
                this.mkdirs(Files1.getParentPath((String)target));
            }
            if (hard) {
                this.channel.hardlink(source, target);
            } else {
                this.channel.symlink(source, target);
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    protected void doMove(String source, String target) {
        try {
            this.channel.rename(source, target);
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    public InputStream openInputStream(String path) throws IOException {
        return this.openInputStream(path, 0L);
    }

    public InputStream openInputStream(String path, long skip) throws IOException {
        try {
            return this.channel.get(path, null, skip);
        }
        catch (Exception e) {
            throw Exceptions.io((String)("could open file input stream " + path), (Throwable)e);
        }
    }

    public OutputStream openOutputStreamWriter(String path) throws IOException {
        return this.openOutputStream(path, 0);
    }

    public OutputStream openOutputStreamAppend(String path) throws IOException {
        return this.openOutputStream(path, 2);
    }

    public OutputStream openOutputStream(String path, int mode) throws IOException {
        try {
            this.mkdirs(Files1.getParentPath((String)path));
            return this.channel.put(path, mode);
        }
        catch (Exception e) {
            throw Exceptions.io((String)("could open file output stream " + path), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String path, long skip, byte[] bs, int offset, int len) throws IOException {
        int n;
        InputStream in = null;
        try {
            in = this.openInputStream(path, skip);
            n = in.read(bs, offset, len);
        }
        catch (Throwable throwable) {
            Streams.close(in);
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        return n;
    }

    public String readLine(String path) throws IOException {
        return this.readLine(path, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String path, long skip) throws IOException {
        String string;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            in = this.openInputStream(path, skip);
            reader = new BufferedReader(new InputStreamReader(in, this.charset));
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            Streams.close(in);
            Streams.close(reader);
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        Streams.close((AutoCloseable)reader);
        return string;
    }

    public List<String> readLines(String path) throws IOException {
        return this.readLines(path, 0L, 0);
    }

    public List<String> readLines(String path, long skip) throws IOException {
        return this.readLines(path, skip, 0);
    }

    public List<String> readLines(String path, int lines) throws IOException {
        return this.readLines(path, 0L, lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readLines(String path, long skip, int lines) throws IOException {
        ArrayList<String> arrayList;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            in = this.openInputStream(path, skip);
            reader = new BufferedReader(new InputStreamReader(in, this.charset));
            ArrayList<String> list = new ArrayList<String>();
            if (lines > 0) {
                String line;
                for (int i = 0; i < lines && (line = reader.readLine()) != null; ++i) {
                    list.add(line);
                }
            } else {
                String line;
                while ((line = reader.readLine()) != null) {
                    list.add(line);
                }
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            Streams.close(in);
            Streams.close(reader);
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        Streams.close((AutoCloseable)reader);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doTransfer(String path, OutputStream out, long skip, int size, boolean close) throws IOException {
        InputStream in;
        long r;
        block12: {
            r = 0L;
            byte[] bs = new byte[this.bufferSize];
            in = null;
            try {
                int read;
                in = this.openInputStream(path, skip);
                if (size != -1) {
                    boolean mod = size % this.bufferSize == 0;
                    long readTimes = size / this.bufferSize;
                    if (mod || readTimes == 0L) {
                        ++readTimes;
                    }
                    int i = 0;
                    while ((long)i < readTimes) {
                        int read2;
                        if (readTimes == 1L) {
                            read2 = in.read(bs, 0, size);
                            out.write(bs, 0, read2);
                            r += (long)read2;
                        } else {
                            read2 = in.read(bs, 0, this.bufferSize);
                            if (read2 == -1) break block12;
                            out.write(bs, 0, read2);
                            r += (long)read2;
                        }
                        ++i;
                    }
                    break block12;
                }
                while ((read = in.read(bs, 0, this.bufferSize)) != -1) {
                    out.write(bs, 0, read);
                    r += (long)read;
                }
            }
            catch (Throwable throwable) {
                Streams.close(in);
                if (close) {
                    Streams.close((AutoCloseable)out);
                }
                throw throwable;
            }
        }
        Streams.close((AutoCloseable)in);
        if (close) {
            Streams.close((AutoCloseable)out);
        }
        return r;
    }

    @Override
    protected void doWrite(String path, InputStream in, StreamEntry entry, List<String> lines) throws IOException {
        this.write(path, in, entry, lines, 0);
    }

    @Override
    protected void doAppend(String path, InputStream in, StreamEntry entry, List<String> lines) throws IOException {
        this.write(path, in, entry, lines, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String path, InputStream in, StreamEntry entry, List<String> lines, int mode) throws IOException {
        this.touch(path, mode == 0);
        OutputStream out = null;
        try {
            out = this.openOutputStream(path, mode);
            if (in != null) {
                int read;
                byte[] bs = new byte[this.bufferSize];
                while ((read = in.read(bs)) != -1) {
                    out.write(bs, 0, read);
                }
            } else if (entry != null) {
                out.write(entry.getBytes(), entry.getOff(), entry.getLen());
            } else if (lines != null) {
                for (String line : lines) {
                    out.write(Strings.bytes((String)(line + "\n"), (String)this.charset));
                }
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            throw throwable;
        }
        Streams.close((AutoCloseable)out);
    }

    @Override
    public SftpUploader upload(String remote, File local) {
        return new SftpUploader(this, remote, local);
    }

    @Override
    public SftpUploader upload(String remote, String local) {
        return new SftpUploader(this, remote, local);
    }

    @Override
    public SftpDownloader download(String remote, File local) {
        return new SftpDownloader(this, remote, local);
    }

    @Override
    public SftpDownloader download(String remote, String local) {
        return new SftpDownloader(this, remote, local);
    }

    @Override
    public List<SftpFile> ll(String path) {
        ArrayList<SftpFile> list = new ArrayList<SftpFile>();
        try {
            Vector files = this.channel.ls(path);
            for (Object file : files) {
                ChannelSftp.LsEntry entity = (ChannelSftp.LsEntry)file;
                String filename = entity.getFilename();
                if (".".equals(filename) || "..".equals(filename)) continue;
                list.add(new SftpFileWrapper(Files1.getPath((String)path, (String)filename), entity.getAttrs()));
            }
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return new ArrayList<SftpFile>();
            }
            throw Exceptions.sftp((Throwable)e);
        }
        return list;
    }

    public String getHome() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void connect() {
        try {
            this.channel.connect();
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
        this.charset(this.charset);
    }

    @Override
    public void connect(int timeout) {
        try {
            this.channel.connect(timeout);
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
        this.charset(this.charset);
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public int getServerVersion() {
        try {
            return this.channel.getServerVersion();
        }
        catch (SftpException e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    public void close() {
        this.channel.disconnect();
    }

    public ChannelSftp getChannel() {
        return this.channel;
    }
}

