/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.channel;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.net.remote.channel.SessionLogger;
import com.orion.net.remote.channel.SessionStore;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SessionHolder {
    public static final SessionHolder HOLDER = new SessionHolder(new JSch());
    public static final int DEFAULT_SSH_PORT = 22;
    public final JSch ch;

    public SessionHolder() {
        this(new JSch());
    }

    public SessionHolder(JSch ch) {
        Valid.notNull((Object)ch, (String)"jsch is null", (Object[])new Object[0]);
        this.ch = ch;
    }

    public static SessionHolder getHolder() {
        return HOLDER;
    }

    public void setLogger(SessionLogger logger) {
        final int loggerLevel = logger.getLevel();
        this.ch.setInstanceLogger(new Logger(){

            public boolean isEnabled(int level) {
                return loggerLevel <= level;
            }

            public void log(int level, String message) {
                SessionLogger.log(level, message);
            }
        });
    }

    public void addIdentity(String keyPath, String password) {
        Valid.notNull((Object)password, (String)"public key password is null", (Object[])new Object[0]);
        try {
            this.ch.addIdentity(keyPath, password);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("add identity error " + e.getMessage()));
        }
    }

    public void addIdentity(String keyPath, byte[] password) {
        Valid.notNull((Object)password, (String)"public key password is null", (Object[])new Object[0]);
        try {
            this.ch.addIdentity(keyPath, password);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("add identity error " + e.getMessage()));
        }
    }

    public void addIdentity(String keyPath) {
        try {
            this.ch.addIdentity(keyPath);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("add identity error " + e.getMessage()));
        }
    }

    public void removeIdentity(String keyPath) {
        Vector identities = this.ch.getIdentityRepository().getIdentities();
        for (Object identity : identities) {
            String key;
            if (!(identity instanceof Identity) || !Files1.getPath((String)(key = ((Identity)identity).getName())).equals(Files1.getPath((String)keyPath))) continue;
            try {
                this.ch.removeIdentity((Identity)identity);
            }
            catch (Exception e) {
                throw Exceptions.runtime((String)("remove identity error " + e.getMessage()));
            }
        }
    }

    public void removeAllIdentity() {
        try {
            this.ch.removeAllIdentity();
        }
        catch (JSchException e) {
            throw Exceptions.runtime((String)("remove all identity error " + e.getMessage()));
        }
    }

    public List<String> getLoadKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Vector identities = this.ch.getIdentityRepository().getIdentities();
        for (Object identity : identities) {
            if (!(identity instanceof Identity)) continue;
            keys.add(Files1.getPath((String)((Identity)identity).getName()));
        }
        return keys;
    }

    public void setKnownHosts(String filePath) {
        try {
            this.ch.setKnownHosts(filePath);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("set unknown hosts error " + e.getMessage()));
        }
    }

    public void setKnownHosts(InputStream inputStream) {
        try {
            this.ch.setKnownHosts(inputStream);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("set unknown hosts error " + e.getMessage()));
        }
    }

    public SessionStore getSession(String host, String username) {
        return this.getSession(host, 22, username);
    }

    public SessionStore getSession(String host, int port, String username) {
        try {
            return new SessionStore(this.ch.getSession(username, host, port));
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
    }

    static {
        JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
        JSch.setConfig((String)"server_host_key", (String)(JSch.getConfig((String)"server_host_key") + ",ssh-rsa"));
        JSch.setConfig((String)"PubkeyAcceptedAlgorithms", (String)(JSch.getConfig((String)"PubkeyAcceptedAlgorithms") + ",ssh-rsa"));
    }
}

