/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.remote.channel;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.orion.lang.able.SafeCloseable;
import com.orion.net.remote.TerminalType;
import java.io.OutputStream;

public class ConsoleShell
implements SafeCloseable {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private Session session;
    private ChannelShell channelShell;

    public ConsoleShell(String host, String username, String password) {
        this.host = host;
        this.port = 22;
        this.username = username;
        this.password = password;
    }

    public ConsoleShell(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public void openShell() throws Exception {
        JSch c = new JSch();
        this.session = c.getSession(this.username, this.host, this.port);
        this.session.setPassword(this.password);
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.connect(3000);
        this.channelShell = (ChannelShell)this.session.openChannel("shell");
        this.channelShell.setPtyType(TerminalType.XTERM.getType());
        this.channelShell.setInputStream(System.in);
        this.channelShell.setOutputStream((OutputStream)System.out);
        this.channelShell.connect();
    }

    public void close() {
        this.session.disconnect();
        this.channelShell.disconnect();
    }

    public Session getSession() {
        return this.session;
    }

    public ChannelShell getChannelShell() {
        return this.channelShell;
    }
}

