/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.instance;

import com.orion.lang.define.StreamEntry;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.time.Dates;
import com.orion.net.ftp.client.FtpFile;
import com.orion.net.ftp.client.FtpFileFilter;
import com.orion.net.ftp.client.bigfile.FtpDownloader;
import com.orion.net.ftp.client.bigfile.FtpUploader;
import com.orion.net.ftp.client.config.FtpConfig;
import com.orion.net.ftp.client.instance.BaseFtpInstance;
import com.orion.net.ftp.client.instance.IFtpInstance;
import com.orion.net.ftp.client.pool.FtpClientPool;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpInstance
extends BaseFtpInstance {
    public FtpInstance(FtpClientPool pool) {
        super(pool);
    }

    public FtpInstance(FTPClient client, FtpConfig config) {
        super(client, config);
    }

    @Override
    public void change() {
        try {
            this.client.changeWorkingDirectory(this.serverCharset(this.config.getRemoteRootDir()));
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public void change(String dir) {
        try {
            if (!this.client.changeWorkingDirectory(this.serverCharset(this.config.getRemoteRootDir() + dir))) {
                this.mkdirs(dir);
                this.client.changeWorkingDirectory(this.serverCharset(this.config.getRemoteRootDir() + dir));
            }
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public String getWorkDirectory() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public boolean isExist(String file) {
        String parentPath = Files1.getParentPath((String)file);
        List<FtpFile> list = this.listFiles(parentPath, false, true);
        for (FtpFile s : list) {
            if (!Files1.getFileName((String)s.getPath()).equals(Files1.getFileName((String)file.trim()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public FtpFile getFile(String file) {
        String parentPath = Files1.getParentPath((String)file);
        List<FtpFile> files = this.listFiles(parentPath, false, true);
        for (FtpFile ftpFile : files) {
            if (!ftpFile.getName().equals(Files1.getFileName((String)file))) continue;
            return ftpFile;
        }
        return null;
    }

    @Override
    public long getSize(String file) {
        FtpFile ftpFile = this.getFile(file);
        if (ftpFile == null) {
            return -1L;
        }
        return ftpFile.getSize();
    }

    @Override
    public long getModifyTime(String file) {
        try {
            String modificationTime = this.client.getModificationTime(file);
            if (modificationTime == null) {
                return -1L;
            }
            String time = modificationTime.split(" ")[1];
            return Dates.parse((String)time, (String)"yyyyMMddHHmmss").getTime();
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public void setModifyTime(String file, Date time) {
        try {
            this.client.setModificationTime(file, Dates.format((Date)time, (String)"yyyyMMddHHmmss"));
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public void truncate(String file) throws IOException {
        OutputStream out = null;
        try {
            out = this.client.storeFileStream(this.serverCharset(this.config.getRemoteRootDir() + file));
            out.flush();
        }
        catch (Exception e) {
            try {
                throw Exceptions.ftp((Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.close(out);
                if (out != null) {
                    this.client.completePendingCommand();
                }
                throw throwable;
            }
        }
        Streams.close((AutoCloseable)out);
        if (out != null) {
            this.client.completePendingCommand();
        }
    }

    @Override
    public void rm(String file) {
        FtpFile ftpFile = this.getFile(file);
        if (ftpFile == null) {
            return;
        }
        if (ftpFile.isDirectory()) {
            this.removeDir(file);
        } else {
            this.removeFile(file);
        }
    }

    @Override
    public void removeFile(String file) {
        try {
            this.client.deleteFile(this.serverCharset(file));
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public void removeDir(String dir) {
        try {
            String d = this.serverCharset(this.config.getRemoteRootDir() + dir);
            List<FtpFile> list = this.listFiles(dir, false, true);
            for (FtpFile s : list) {
                String path = s.getPath();
                if (s.isDirectory()) {
                    this.removeDir(path);
                    this.client.removeDirectory(this.serverCharset(Files1.getPath((String)this.config.getRemoteRootDir(), (String)path)));
                    continue;
                }
                this.client.deleteFile(this.serverCharset(Files1.getPath((String)this.config.getRemoteRootDir(), (String)path)));
            }
            this.client.changeWorkingDirectory(this.serverCharset(this.config.getRemoteRootDir() + Files1.getParentPath((String)dir)));
            this.client.removeDirectory(this.serverCharset(Files1.getFileName((String)dir)));
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public void mkdirs(String dir) {
        try {
            String[] dirs = Files1.getPath((String)dir).split("/");
            String base = this.config.getRemoteRootDir();
            for (String d : dirs) {
                if (d == null || "".equals(d) || this.client.changeWorkingDirectory(base = this.serverCharset(base + "/" + d))) continue;
                this.client.makeDirectory(base);
                this.client.changeWorkingDirectory(base);
            }
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public void touch(String file) {
        String fileName = Files1.getFileName((String)file);
        String filePath = this.serverCharset(this.config.getRemoteRootDir() + file);
        String parentPath = Files1.getParentPath((String)Files1.getPath((String)file));
        this.mkdirs(parentPath);
        for (FtpFile s : this.listFiles(parentPath, false)) {
            if (!Files1.getFileName((String)s.getPath()).equals(fileName)) continue;
            return;
        }
        this.change(parentPath);
        try {
            this.client.storeFile(this.serverCharset(filePath), (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public void mv(String source, String target) {
        source = Files1.getPath((String)source);
        target = Files1.getPath((String)target);
        try {
            target = target.charAt(0) == '/' ? this.config.getRemoteRootDir() + Files1.normalize((String)target) : Files1.normalize((String)Files1.getPath((String)(source + "/../" + target)));
            this.change(Files1.getParentPath((String)source));
            this.mkdirs(Files1.getParentPath((String)target));
            this.client.rename(source, target);
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public InputStream openInputStream(String file) throws IOException {
        try {
            return this.client.retrieveFileStream(this.serverCharset(this.config.getRemoteRootDir() + file));
        }
        catch (Exception e) {
            throw Exceptions.io((String)("cannot get file input stream " + file), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openInputStream(String file, long skip) throws IOException {
        try {
            this.client.setRestartOffset(skip);
            InputStream inputStream = this.openInputStream(file);
            return inputStream;
        }
        finally {
            this.client.setRestartOffset(0L);
        }
    }

    @Override
    public OutputStream openOutputStream(String file) throws IOException {
        return this.openOutputStream(file, false);
    }

    @Override
    public OutputStream openOutputStream(String file, boolean append) throws IOException {
        this.mkdirs(Files1.getParentPath((String)file));
        try {
            if (append) {
                return this.client.appendFileStream(this.serverCharset(this.config.getRemoteRootDir() + file));
            }
            return this.client.storeFileStream(this.serverCharset(this.config.getRemoteRootDir() + file));
        }
        catch (Exception e) {
            throw Exceptions.io((String)("cannot get file out stream " + file), (Throwable)e);
        }
    }

    @Override
    public void readFromFile(String file, OutputStream out) throws IOException {
        this.mkdirs(Files1.getParentPath((String)file));
        try {
            this.client.retrieveFile(this.serverCharset(this.config.getRemoteRootDir() + file), out);
        }
        catch (Exception e) {
            throw Exceptions.io((String)("cannot write to stream " + file), (Throwable)e);
        }
    }

    @Override
    public void appendToFile(String file, InputStream in) throws IOException {
        this.mkdirs(Files1.getParentPath((String)file));
        try {
            this.client.appendFile(this.serverCharset(this.config.getRemoteRootDir() + file), in);
        }
        catch (Exception e) {
            throw Exceptions.io((String)("cannot write to stream " + file), (Throwable)e);
        }
    }

    @Override
    public void writeToFile(String file, InputStream in) throws IOException {
        this.mkdirs(Files1.getParentPath((String)file));
        try {
            this.client.storeFile(this.serverCharset(this.config.getRemoteRootDir() + file), in);
        }
        catch (Exception e) {
            throw Exceptions.io((String)("cannot write to stream " + file), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String file, long skip, byte[] bs, int off, int len) throws IOException {
        int n;
        InputStream in = null;
        try {
            this.client.setRestartOffset(skip);
            in = this.openInputStream(file);
            n = in.read(bs, off, len);
        }
        catch (Throwable throwable) {
            Streams.close(in);
            this.client.setRestartOffset(0L);
            if (in != null) {
                this.client.completePendingCommand();
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        this.client.setRestartOffset(0L);
        if (in != null) {
            this.client.completePendingCommand();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(String file, long skip) throws IOException {
        String string;
        BufferedReader in = null;
        try {
            this.client.setRestartOffset(skip);
            in = new BufferedReader(new InputStreamReader(this.openInputStream(file), this.config.getRemoteFileNameCharset()));
            string = in.readLine();
        }
        catch (Throwable throwable) {
            Streams.close(in);
            this.client.setRestartOffset(0L);
            if (in != null) {
                this.client.completePendingCommand();
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        this.client.setRestartOffset(0L);
        if (in != null) {
            this.client.completePendingCommand();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> readLines(String file, long skip, int lines) throws IOException {
        ArrayList<String> arrayList;
        BufferedReader in = null;
        try {
            String line;
            this.client.setRestartOffset(skip);
            in = new BufferedReader(new InputStreamReader(this.openInputStream(file), this.config.getRemoteFileNameCharset()));
            ArrayList<String> list = new ArrayList<String>();
            if (lines != -1) {
                for (int i = 0; i < lines && (line = in.readLine()) != null; ++i) {
                    list.add(line);
                }
            } else {
                while ((line = in.readLine()) != null) {
                    list.add(line);
                }
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            Streams.close(in);
            this.client.setRestartOffset(0L);
            if (in != null) {
                this.client.completePendingCommand();
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        this.client.setRestartOffset(0L);
        if (in != null) {
            this.client.completePendingCommand();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doTransfer(String path, OutputStream out, long skip, int size, boolean close) throws IOException {
        InputStream in;
        long r;
        block14: {
            r = 0L;
            byte[] bs = new byte[this.bufferSize];
            in = null;
            try {
                int read;
                in = this.openInputStream(path, skip);
                if (size != -1) {
                    boolean mod = size % this.bufferSize == 0;
                    long readTimes = size / this.bufferSize;
                    if (mod || readTimes == 0L) {
                        ++readTimes;
                    }
                    int i = 0;
                    while ((long)i < readTimes) {
                        int read2;
                        if (readTimes == 1L) {
                            read2 = in.read(bs, 0, size);
                            out.write(bs, 0, read2);
                            r += (long)read2;
                        } else {
                            read2 = in.read(bs, 0, this.bufferSize);
                            if (read2 == -1) break block14;
                            out.write(bs, 0, read2);
                            r += (long)read2;
                        }
                        ++i;
                    }
                    break block14;
                }
                while ((read = in.read(bs, 0, this.bufferSize)) != -1) {
                    out.write(bs, 0, read);
                    r += (long)read;
                }
            }
            catch (Throwable throwable) {
                Streams.close(in);
                this.client.setRestartOffset(0L);
                if (in != null) {
                    this.client.completePendingCommand();
                }
                if (close) {
                    Streams.close((AutoCloseable)out);
                }
                throw throwable;
            }
        }
        Streams.close((AutoCloseable)in);
        this.client.setRestartOffset(0L);
        if (in != null) {
            this.client.completePendingCommand();
        }
        if (close) {
            Streams.close((AutoCloseable)out);
        }
        return r;
    }

    @Override
    protected void doWrite(String path, InputStream in, StreamEntry entry, List<String> lines) throws IOException {
        this.write(path, in, entry, lines, false);
    }

    @Override
    protected void doAppend(String path, InputStream in, StreamEntry entry, List<String> lines) throws IOException {
        this.write(path, in, entry, lines, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String path, InputStream in, StreamEntry entry, List<String> lines, boolean append) throws IOException {
        OutputStream out = null;
        try {
            out = this.openOutputStream(path, append);
            if (in != null) {
                int read;
                byte[] bs = new byte[this.bufferSize];
                while ((read = in.read(bs)) != -1) {
                    out.write(bs, 0, read);
                }
            } else if (entry != null) {
                out.write(entry.getBytes(), entry.getOff(), entry.getLen());
            } else if (lines != null) {
                for (String line : lines) {
                    out.write(Strings.bytes((String)(line + "\n")));
                }
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            if (out != null) {
                this.client.completePendingCommand();
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)out);
        if (out != null) {
            this.client.completePendingCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void uploadFile(String remoteFile, InputStream in, boolean close) throws IOException {
        BufferedInputStream buffer = null;
        try {
            String parentPath = Files1.getParentPath((String)remoteFile);
            this.mkdirs(parentPath);
            buffer = new BufferedInputStream(in);
            this.client.storeFile(this.serverCharset(this.config.getRemoteRootDir() + remoteFile), (InputStream)buffer);
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            Streams.close((AutoCloseable)in);
            Streams.close(buffer);
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        Streams.close((AutoCloseable)buffer);
    }

    @Override
    public void uploadDir(String remoteDir, String localDir, boolean child) throws IOException {
        localDir = Files1.getPath((String)localDir);
        List dirs = Files1.listDirs((String)localDir, (boolean)child);
        List files = Files1.listFiles((String)localDir, (boolean)child);
        for (File dir : dirs) {
            this.mkdirs(Files1.getPath((String)remoteDir, (String)dir.getAbsolutePath().substring(localDir.length())));
        }
        for (File file : files) {
            String path = Files1.getPath((String)remoteDir, (String)file.getAbsolutePath().substring(localDir.length()));
            this.change(Files1.getParentPath((String)path));
            this.uploadFile(path, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(String remoteFile, OutputStream out, boolean close) throws IOException {
        InputStream in;
        block6: {
            in = null;
            try {
                this.client.setRestartOffset(0L);
                in = this.openInputStream(remoteFile);
                if (in == null) {
                    throw Exceptions.ftp((String)("not found file " + remoteFile));
                }
                Streams.transfer((InputStream)in, (OutputStream)out);
                if (!close) break block6;
            }
            catch (Throwable throwable) {
                if (close) {
                    Streams.close((AutoCloseable)out);
                }
                Streams.close(in);
                this.client.setRestartOffset(0L);
                if (in != null) {
                    this.client.completePendingCommand();
                }
                throw throwable;
            }
            Streams.close((AutoCloseable)out);
        }
        Streams.close((AutoCloseable)in);
        this.client.setRestartOffset(0L);
        if (in != null) {
            this.client.completePendingCommand();
        }
    }

    @Override
    public void downloadDir(String remoteDir, String localDir, boolean child) throws IOException {
        remoteDir = Files1.getPath((String)remoteDir);
        if (!child) {
            List<FtpFile> list = this.listFiles(remoteDir, false);
            for (FtpFile s : list) {
                this.downloadFile(s.getPath(), Files1.getPath((String)localDir, (String)Files1.getFileName((String)s.getPath())));
            }
        } else {
            List<FtpFile> list = this.listDirs(remoteDir, true);
            for (FtpFile s : list) {
                Files1.mkdirs((String)Files1.getPath((String)localDir, (String)s.getPath().substring(remoteDir.length())));
            }
            list = this.listFiles(remoteDir, true);
            for (FtpFile s : list) {
                this.downloadFile(s.getPath(), Files1.getPath((String)localDir, (String)s.getPath().substring(remoteDir.length())));
            }
        }
    }

    @Override
    public FtpUploader upload(String remote, String local) {
        return new FtpUploader(this, remote, local);
    }

    @Override
    public FtpUploader upload(String remote, File local) {
        return new FtpUploader(this, remote, local);
    }

    @Override
    public FtpDownloader download(String remote, String local) {
        return new FtpDownloader((IFtpInstance)this, remote, local);
    }

    @Override
    public FtpDownloader download(String remote, File local) {
        return new FtpDownloader((IFtpInstance)this, remote, local);
    }

    @Override
    protected List<FtpFile> listFilesSearch(String path, FtpFileFilter filter, boolean child, boolean dir) {
        String base = this.config.getRemoteRootDir();
        ArrayList<FtpFile> list = new ArrayList<FtpFile>();
        try {
            FTPFile[] files;
            for (FTPFile file : files = this.client.listFiles(this.serverCharset(Files1.getPath((String)base, (String)path)))) {
                FtpFile f;
                String fn = file.getName();
                String t = Files1.getPath((String)path, (String)fn);
                boolean isDir = file.isDirectory();
                if ((!isDir || dir) && filter.accept(f = new FtpFile(t, file))) {
                    list.add(f);
                }
                if (!isDir || !child) continue;
                list.addAll(this.listFilesSearch(t + "/", filter, true, dir));
            }
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
        return list;
    }
}

